/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.dimension.TentTeleporter;
import nomadictents.event.TentEvent;
import nomadictents.init.Content;
import nomadictents.init.TentConfig;
import nomadictents.init.TentSaveData;
import nomadictents.structure.util.TentData;

public class TileEntityTentDoor
extends TileEntity {
    private static final String S_TENT_DATA = "TentData";
    private static final String S_PLAYER_X = "PlayerPrevX";
    private static final String S_PLAYER_Y = "PlayerPrevY";
    private static final String S_PLAYER_Z = "PlayerPrevZ";
    private static final String S_PLAYER_YAW = "PlayerPrevFacing";
    private static final String S_PLAYER_UUID = "PlayerUUID";
    private static final String S_PLAYER_DIM = "PreviousPlayerDimension";
    private TentData tent = new TentData();
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevFacing;
    private DimensionType prevDim = DimensionType.field_223227_a_;
    private UUID owner;

    public TileEntityTentDoor() {
        super(Content.TE_DOOR);
    }

    public static BlockPos getTentDoorPos(long tentID) {
        int x = (int)(tentID % 64L) * 32;
        int y = 70;
        int z = (int)(tentID / 64L) * 32;
        return new BlockPos(x, y, z);
    }

    public static long getTentID(BlockPos pos) {
        return (long)(pos.func_177958_n() / 32) + (long)(pos.func_177952_p() / 32) * 64L;
    }

    public void setTentData(TentData tentData) {
        this.tent = tentData;
    }

    public TentData getTentData() {
        return this.tent;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.tent = new TentData(nbt.func_74775_l(S_TENT_DATA));
        this.prevX = nbt.func_74769_h(S_PLAYER_X);
        this.prevY = nbt.func_74769_h(S_PLAYER_Y);
        this.prevZ = nbt.func_74769_h(S_PLAYER_Z);
        this.prevFacing = nbt.func_74760_g(S_PLAYER_YAW);
        this.prevDim = DimensionType.func_186069_a((int)nbt.func_74762_e(S_PLAYER_DIM));
        this.owner = nbt.func_74764_b(S_PLAYER_UUID) ? nbt.func_186857_a(S_PLAYER_UUID) : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a(S_TENT_DATA, (INBT)this.tent.serializeNBT());
        nbt.func_74780_a(S_PLAYER_X, this.prevX);
        nbt.func_74780_a(S_PLAYER_Y, this.prevY);
        nbt.func_74780_a(S_PLAYER_Z, this.prevZ);
        nbt.func_74776_a(S_PLAYER_YAW, this.prevFacing);
        nbt.func_74768_a(S_PLAYER_DIM, this.getPrevDimension() != null ? this.getPrevDimension().func_186068_a() : TentDimensionManager.getOverworldDim().func_186068_a());
        if (this.owner != null) {
            nbt.func_186854_a(S_PLAYER_UUID, this.owner);
        }
        return nbt;
    }

    public BlockPos getDoorPos() {
        return TileEntityTentDoor.getTentDoorPos(this.getTentData().getID());
    }

    public void setOverworldXYZ(double posX, double posY, double posZ) {
        this.prevX = posX;
        this.prevY = posY;
        this.prevZ = posZ;
    }

    public void setPrevDimension(DimensionType prevDimension) {
        this.prevDim = prevDimension;
    }

    public void setPrevFacing(float facing) {
        this.prevFacing = facing;
    }

    public DimensionType getPrevDimension() {
        return this.prevDim;
    }

    public double getPrevX() {
        return this.prevX;
    }

    public double getPrevY() {
        return this.prevY;
    }

    public double getPrevZ() {
        return this.prevZ;
    }

    public float getPrevFacing() {
        return this.prevFacing;
    }

    public void setOwner(@Nullable UUID uuid) {
        this.owner = uuid;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean isOwner(PlayerEntity player) {
        return !this.hasOwner() || player.func_184812_l_() || PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e()).equals(this.owner);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    @Nullable
    public PlayerEntity getOwner() {
        if (this.hasOwner() && !this.field_145850_b.field_72995_K) {
            return this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
        }
        return null;
    }

    private boolean teleport(Entity entity) {
        ServerPlayerEntity player;
        DimensionType dimFrom = entity.func_130014_f_().func_201675_m().func_186058_p();
        DimensionType dimTo = TentDimensionManager.isTent(dimFrom) ? this.getPrevDimension() : TentDimensionManager.getTentDim();
        ServerPlayerEntity serverPlayerEntity = player = entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
        if (TentDimensionManager.isTent(dimTo) && MinecraftForge.EVENT_BUS.post((Event)new TentEvent.PreEnter(this, entity))) {
            return false;
        }
        if (TentDimensionManager.isTent(dimTo) && player != null && !player.func_184812_l_() && ((Boolean)TentConfig.CONFIG.ENTER_MUST_BE_SAFE.get()).booleanValue()) {
            AxisAlignedBB box = new AxisAlignedBB(this.field_174879_c).func_72314_b(8.0, 5.0, 8.0);
            List list = entity.func_130014_f_().func_175647_a(MonsterEntity.class, box, e -> e.func_191990_c((PlayerEntity)player));
            if (!list.isEmpty()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.monsters_nearby", new Object[0]), true);
                return false;
            }
        }
        entity.func_181015_d(this.func_174877_v());
        if (entity.field_71088_bW > 0) {
            entity.field_71088_bW = entity.func_82147_ab();
        } else {
            entity.field_71088_bW = entity.func_82147_ab();
            TentTeleporter tel = new TentTeleporter(dimFrom, dimTo, this);
            if (player != null && ((Boolean)TentConfig.CONFIG.ALLOW_OVERWORLD_SETSPAWN.get()).booleanValue() && dimFrom == TentDimensionManager.getTentDim() && dimTo == TentDimensionManager.getOverworldDim()) {
                TileEntityTentDoor.attemptSetSpawn(this.func_145831_w(), player, this.func_174877_v().func_177982_a(this.tent.getWidth().getDoorZ(), 0, 0), this.prevX, this.prevY, this.prevZ);
            }
            if (entity != null && entity.func_70089_S()) {
                return tel.func_85188_a(entity);
            }
        }
        return false;
    }

    private static boolean attemptSetSpawn(World worldFrom, ServerPlayerEntity player, BlockPos tentCenter, double prevX, double prevY, double prevZ) {
        BlockPos bedSpawn;
        DimensionType overworldId = TentDimensionManager.getOverworldDim();
        ServerWorld overworld = worldFrom.func_73046_m().func_71218_a(overworldId);
        BlockPos prevCoords = new BlockPos(prevX, prevY, prevZ);
        TentSaveData data = TentSaveData.get(player.func_184102_h());
        UUID uuid = PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e());
        BlockPos oldSpawn = player.getBedLocation(overworldId);
        BlockPos blockPos = bedSpawn = oldSpawn != null ? player.getBedLocation(overworldId) : null;
        if (bedSpawn == null) {
            oldSpawn = overworld.func_175694_M();
        }
        if (TileEntityTentDoor.isSpawnInTent((PlayerEntity)player, tentCenter, true) && !data.containsSpawn(uuid) && overworld.func_201675_m().func_76567_e()) {
            data.putSpawn(uuid, oldSpawn);
            player.setSpawnPoint(prevCoords, true, true, overworldId);
            return true;
        }
        if (TileEntityTentDoor.isSpawnInTent((PlayerEntity)player, tentCenter, false)) {
            TileEntityTentDoor.resetOverworldSpawn((PlayerEntity)player);
        }
        return false;
    }

    public void onPlayerRemove(PlayerEntity playerIn) {
        if (((Boolean)TentConfig.CONFIG.ALLOW_OVERWORLD_SETSPAWN.get()).booleanValue()) {
            BlockPos tentCenter = this.getDoorPos().func_177982_a(this.getTentData().getWidth().getDoorZ(), 0, 0);
            MinecraftServer mcServer = playerIn.func_130014_f_().func_73046_m();
            for (ServerPlayerEntity player : mcServer.func_184103_al().func_181057_v()) {
                if (player == null || !TileEntityTentDoor.isSpawnInTent((PlayerEntity)player, tentCenter, false)) continue;
                TileEntityTentDoor.resetOverworldSpawn((PlayerEntity)player);
            }
        }
    }

    private static void resetOverworldSpawn(PlayerEntity player) {
        DimensionType overworldId = TentDimensionManager.getOverworldDim();
        UUID uuid = PlayerEntity.func_175147_b((String)player.func_200200_C_().func_150261_e());
        TentSaveData data = TentSaveData.get(player.func_184102_h());
        BlockPos posToSet = player.getBedLocation(overworldId);
        if (posToSet == null) {
            BlockPos oldSpawn = data.getSpawn(uuid);
            posToSet = oldSpawn == null ? player.func_130014_f_().func_201675_m().getSpawnPoint() : oldSpawn;
        }
        player.setSpawnPoint(posToSet, false, true, overworldId);
        data.removeSpawn(uuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSpawnInTent(PlayerEntity player, BlockPos tentCenter, boolean andBed) {
        DimensionType tent = TentDimensionManager.getTentDim();
        BlockPos bedPos = player.getBedLocation(tent);
        if (andBed && bedPos != null) {
            boolean flag = player.isSpawnForced(tent);
            if (bedPos != null) {
                Optional optional = PlayerEntity.func_213822_a((IWorldReader)player.func_184102_h().func_71218_a(tent), (BlockPos)bedPos, (boolean)flag);
                bedPos = optional.isPresent() ? new BlockPos((Vec3d)optional.get()) : null;
            }
        }
        double maxDistanceSq = Math.pow(16.0, 2.0) + 1.0;
        if (bedPos == null) return false;
        BlockPos blockPos = new BlockPos(tentCenter.func_177958_n(), bedPos.func_177956_o(), tentCenter.func_177952_p());
        if (!(blockPos.func_177951_i((Vec3i)bedPos) < maxDistanceSq)) return false;
        return true;
    }

    public boolean onEntityCollide(Entity entity, Direction tentDir) {
        if (this.canTeleportEntity(entity) && (entity instanceof PlayerEntity && ((Boolean)TentConfig.CONFIG.ALLOW_PLAYER_COLLIDE.get()).booleanValue() || !(entity instanceof PlayerEntity) && ((Boolean)TentConfig.CONFIG.ALLOW_NONPLAYER_COLLIDE.get()).booleanValue())) {
            if (!TentDimensionManager.isTent((IWorld)entity.func_130014_f_())) {
                BlockPos respawn = this.func_174877_v().func_177967_a(tentDir.func_176734_d(), 1);
                double posX = (double)respawn.func_177958_n() + 0.5;
                double posY = (double)respawn.func_177956_o() + 0.01;
                double posZ = (double)respawn.func_177952_p() + 0.5;
                this.setOverworldXYZ(posX, posY, posZ);
                this.setPrevFacing(tentDir.func_185119_l());
            }
            return this.teleport(entity);
        }
        return false;
    }

    public boolean onPlayerActivate(PlayerEntity player) {
        if (this.canTeleportEntity((Entity)player)) {
            if (!TentDimensionManager.isTent((IWorld)player.func_130014_f_())) {
                double posX = player.func_226277_ct_();
                double posY = player.func_226278_cu_();
                double posZ = player.func_226281_cx_();
                this.setOverworldXYZ(posX, posY, posZ);
                this.setPrevFacing(player.func_70079_am());
            }
            return this.teleport((Entity)player);
        }
        return false;
    }

    public boolean canTeleportEntity(Entity entity) {
        if (entity == null || entity.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!TentDimensionManager.isTent((IWorld)entity.func_130014_f_()) && ((Boolean)TentConfig.CONFIG.OWNER_ENTRANCE.get()).booleanValue() && entity instanceof PlayerEntity && !this.isOwner((PlayerEntity)entity)) {
            return false;
        }
        boolean ridingFlag = entity.func_184218_aH() || entity.func_184207_aI();
        boolean isInvalidClass = entity instanceof EndermanEntity;
        return !ridingFlag && !isInvalidClass && entity.func_184222_aU();
    }
}

