/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.crafting;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import nomadictents.crafting.RecipeUpgradeWidth;
import nomadictents.init.Content;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class RecipeUpgradeColor
extends ShapedRecipe {
    public static final String CATEGORY = "tent_upgrade_color";
    public static final RecipeUpgradeColor EMPTY = new RecipeUpgradeColor();
    private final DyeColor colorOut;

    public RecipeUpgradeColor(ResourceLocation id, DyeColor color, NonNullList<Ingredient> ingredients, boolean hasWater) {
        super(id, CATEGORY, hasWater ? 1 : 3, hasWater ? 2 : 3, ingredients, new TentData().setColor(color).setAll(TentType.SHAMIANA, TentWidth.SMALL, TentDepth.NORMAL).getDropStack());
        this.colorOut = color;
    }

    private RecipeUpgradeColor() {
        super(new ResourceLocation("empty"), CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.colorOut = DyeColor.WHITE;
    }

    public static boolean hasWaterBucket(NonNullList<Ingredient> ingredients) {
        for (Ingredient i : ingredients) {
            for (ItemStack s : i.func_193365_a()) {
                if (s.func_190926_b() || s.func_77973_b() != Items.field_151131_as) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (this != EMPTY && super.func_77569_a(inv, worldIn)) {
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            if (tentStack.func_190926_b()) {
                return false;
            }
            TentData data = new TentData(tentStack.func_190925_c("TentData"));
            if (data.getTent() == TentType.SHAMIANA && (this.colorOut == DyeColor.WHITE || data.getColor() == DyeColor.WHITE)) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (this == EMPTY) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        CompoundNBT resultTag = result.func_196082_o();
        if (inputTent != null && inputTent.func_77942_o()) {
            TentData tentData = new TentData(inputTent);
            tentData.setColor(this.colorOut);
            resultTag.func_218657_a("TentData", (INBT)tentData.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Content.SERIALIZER_COLOR;
    }

    public DyeColor getColorOut() {
        return this.colorOut;
    }

    public static class Factory
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            String colorName = JSONUtils.func_151200_h((JsonObject)json, (String)"result_color");
            DyeColor color = DyeColor.WHITE;
            for (DyeColor c : DyeColor.values()) {
                if (!c.func_176610_l().equals(colorName)) continue;
                color = c;
                break;
            }
            return new RecipeUpgradeColor(recipeId, color, (NonNullList<Ingredient>)recipe.func_192400_c(), RecipeUpgradeColor.hasWaterBucket((NonNullList<Ingredient>)recipe.func_192400_c()));
        }

        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            if ("empty".equals(recipeId.func_110623_a())) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            DyeColor color = DyeColor.func_196056_a((int)buffer.func_150792_a());
            return new RecipeUpgradeColor(recipeId, color, (NonNullList<Ingredient>)recipe.func_192400_c(), RecipeUpgradeColor.hasWaterBucket((NonNullList<Ingredient>)recipe.func_192400_c()));
        }

        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipeIn) {
            super.func_199427_a_(buffer, recipeIn);
            RecipeUpgradeColor recipe = (RecipeUpgradeColor)recipeIn;
            buffer.func_150787_b(recipe.getColorOut().func_196059_a());
        }
    }
}

