/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.crafting;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import nomadictents.crafting.RecipeUpgradeWidth;
import nomadictents.init.Content;
import nomadictents.item.ItemDepthUpgrade;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class RecipeUpgradeDepth
extends ShapedRecipe {
    public static final String CATEGORY = "tent_upgrade_depth";
    public static final RecipeUpgradeDepth EMPTY = new RecipeUpgradeDepth();
    private final TentType tent;
    private final TentWidth widthIn;
    private final TentDepth depthIn;
    private final TentDepth depthOut;

    public RecipeUpgradeDepth(ResourceLocation id, TentDepth depthFrom, TentDepth depthTo, TentType tentType, TentWidth minSize, NonNullList<Ingredient> ingredients) {
        super(id, CATEGORY, 3, 3, ingredients, new TentData().setAll(tentType, minSize, depthTo).getDropStack());
        this.depthIn = depthFrom;
        this.depthOut = depthTo;
        this.tent = tentType;
        this.widthIn = minSize;
    }

    private RecipeUpgradeDepth() {
        super(new ResourceLocation("empty"), CATEGORY, 3, 3, NonNullList.func_191196_a(), ItemStack.field_190927_a);
        this.tent = TentType.YURT;
        this.widthIn = TentWidth.SMALL;
        this.depthIn = TentDepth.NORMAL;
        this.depthOut = TentDepth.NORMAL;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (this != EMPTY && super.func_77569_a(inv, worldIn)) {
            ItemStack tentStack = RecipeUpgradeWidth.getTentStack(inv);
            ItemStack upgradeStack = RecipeUpgradeWidth.getStackMatching(inv, ItemDepthUpgrade.class);
            if (tentStack.func_190926_b() || upgradeStack.func_190926_b()) {
                return false;
            }
            TentData data = new TentData(tentStack.func_190925_c("TentData"));
            if (data.getTent() == this.tent && data.getDepth() == this.depthIn && data.getWidth().getId() >= this.widthIn.getId() && this.depthOut.getId() < data.getWidth().getMaxDepth()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        CompoundNBT resultTag;
        if (this == EMPTY) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = super.func_77572_b(inv);
        ItemStack inputTent = RecipeUpgradeWidth.getTentStack(inv);
        CompoundNBT compoundNBT = resultTag = result.func_77942_o() ? result.func_77978_p() : new CompoundNBT();
        if (inputTent != null && inputTent.func_77942_o()) {
            TentData tentData = new TentData(inputTent);
            tentData.setDepth(this.depthOut);
            resultTag.func_218657_a("TentData", (INBT)tentData.serializeNBT());
        }
        result.func_77982_d(resultTag);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Content.SERIALIZER_DEPTH;
    }

    public TentType getTentType() {
        return this.tent;
    }

    public TentWidth getMinSize() {
        return this.widthIn;
    }

    public TentDepth getDepthIn() {
        return this.depthIn;
    }

    public TentDepth getDepthOut() {
        return this.depthOut;
    }

    public static class Factory
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            if (json.has("disabled")) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199425_a_(recipeId, json);
            TentType tentType = TentType.getByName(JSONUtils.func_151200_h((JsonObject)json, (String)"tent_type"));
            TentWidth minWidth = TentWidth.getByName(JSONUtils.func_151200_h((JsonObject)json, (String)"min_size"));
            TentDepth depthIn = TentDepth.getById((byte)JSONUtils.func_151203_m((JsonObject)json, (String)"input_depth"));
            TentDepth depthOut = TentDepth.getById((byte)JSONUtils.func_151203_m((JsonObject)json, (String)"result_depth"));
            return new RecipeUpgradeDepth(recipeId, depthIn, depthOut, tentType, minWidth, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            if ("empty".equals(recipeId.func_110623_a())) {
                return EMPTY;
            }
            ShapedRecipe recipe = super.func_199426_a_(recipeId, buffer);
            TentType tentType = TentType.getById(buffer.readByte());
            TentWidth minWidth = TentWidth.getById(buffer.readByte());
            TentDepth depthIn = TentDepth.getById(buffer.readByte());
            TentDepth depthOut = TentDepth.getById(buffer.readByte());
            return new RecipeUpgradeDepth(recipeId, depthIn, depthOut, tentType, minWidth, (NonNullList<Ingredient>)recipe.func_192400_c());
        }

        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipeIn) {
            super.func_199427_a_(buffer, recipeIn);
            RecipeUpgradeDepth recipe = (RecipeUpgradeDepth)recipeIn;
            buffer.writeByte((int)recipe.getTentType().getId());
            buffer.writeByte((int)recipe.getMinSize().getId());
            buffer.writeByte((int)recipe.getDepthIn().getId());
            buffer.writeByte((int)recipe.getDepthOut().getId());
        }
    }
}

