/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.event;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.structure.util.TentData;

public class TentEvent
extends Event {
    private final TileEntityTentDoor teDoor;

    public TentEvent(TileEntityTentDoor door) {
        this.teDoor = door;
    }

    public TileEntityTentDoor getDoor() {
        return this.teDoor;
    }

    @Nullable
    public TentData getData() {
        return this.teDoor != null ? this.teDoor.getTentData() : null;
    }

    @Nullable
    public BlockPos getDoorPos() {
        return this.teDoor != null ? this.teDoor.func_174877_v() : null;
    }

    public boolean isInsideTent() {
        return this.teDoor != null && TentDimensionManager.isTent((IWorld)this.teDoor.func_145831_w());
    }

    @Nullable
    public Dimension getDimensionId() {
        return this.teDoor != null ? this.teDoor.func_145831_w().func_201675_m() : null;
    }

    public static enum TentResult {
        NONE,
        BUILT_FIRST,
        UPGRADED;

    }

    public static class PostEnter
    extends TentEvent {
        private final Entity entity;
        private final TentResult tentResult;

        public PostEnter(TileEntityTentDoor door, Entity entityIn, TentResult resultIn) {
            super(door);
            this.entity = entityIn;
            this.tentResult = resultIn;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public boolean isPlayer() {
            return this.entity instanceof PlayerEntity;
        }

        public TentResult getTentResult() {
            return this.tentResult;
        }
    }

    @Cancelable
    public static class PreEnter
    extends TentEvent {
        private final Entity entity;

        public PreEnter(TileEntityTentDoor door, Entity entityIn) {
            super(door);
            this.entity = entityIn;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public boolean isPlayer() {
            return this.entity instanceof PlayerEntity;
        }
    }

    public static class Deconstruct
    extends TentEvent {
        final PlayerEntity player;

        public Deconstruct(TileEntityTentDoor door, PlayerEntity playerIn) {
            super(door);
            this.player = playerIn;
        }

        public ItemStack getTentStack() {
            return this.getData() != null ? this.getData().getDropStack() : ItemStack.field_190927_a;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }
    }
}

