/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.event;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ChorusFruitItem;
import net.minecraft.item.EnderPearlItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.dimension.TentTeleporter;
import nomadictents.init.NomadicTents;
import nomadictents.init.TentConfig;
import nomadictents.item.ItemTent;
import nomadictents.structure.util.TentData;

public class TentEventHandler {
    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        NomadicTents.LOGGER.debug("nomadictents: FMLServerStartingEvent");
        TentDimensionManager.registerDimension();
    }

    @SubscribeEvent
    public void onPlayerWake(PlayerWakeUpEvent event) {
    }

    @SubscribeEvent
    public void onSpawnEntity(EntityJoinWorldEvent event) {
        PlayerEntity thrower;
        EnderPearlEntity pearl;
        ItemStack stack;
        if (((Boolean)TentConfig.CONFIG.IS_TENT_FIREPROOF.get()).booleanValue() && event.getEntity() instanceof ItemEntity && (stack = ((ItemEntity)event.getEntity()).func_92059_d()) != null && stack.func_77973_b() instanceof ItemTent) {
            event.getEntity().func_184224_h(true);
        }
        if (event.getEntity() instanceof EnderPearlEntity && (pearl = (EnderPearlEntity)event.getEntity()).func_85052_h() instanceof PlayerEntity && TentEventHandler.canCancelTeleport(thrower = (PlayerEntity)pearl.func_85052_h())) {
            pearl.func_70106_y();
            thrower.func_146105_b(new TranslationTextComponent("chat.no_teleport", new Object[0]).func_211708_a(TextFormatting.RED), true);
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Start event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && TentEventHandler.isTeleportItem(event.getItem()) && TentEventHandler.canCancelTeleport(player = (PlayerEntity)event.getEntityLiving())) {
            event.setDuration(-100);
            player.func_146105_b(new TranslationTextComponent("chat.no_teleport", new Object[0]).func_211708_a(TextFormatting.RED), true);
        }
    }

    private static boolean canCancelTeleport(PlayerEntity player) {
        return (Boolean)TentConfig.CONFIG.RESTRICT_TELEPORT_TENT_DIM.get() != false && TentDimensionManager.isTent((IWorld)player.func_130014_f_()) && !player.func_184812_l_();
    }

    private static boolean isTeleportItem(ItemStack i) {
        return i != null && !i.func_190926_b() && (i.func_77973_b() instanceof ChorusFruitItem || i.func_77973_b() instanceof EnderPearlItem);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && !event.getPlayer().func_130014_f_().func_201670_d() && ((Boolean)TentConfig.CONFIG.ALLOW_RESPAWN_INTERCEPT.get()).booleanValue()) {
            BlockPos respawnPos;
            DimensionType tentDim = TentDimensionManager.getTentDim();
            DimensionType respawnDim = TentDimensionManager.getOverworldDim();
            DimensionType curDim = event.getPlayer().func_130014_f_().func_201675_m().func_186058_p();
            ServerPlayerEntity playerMP = (ServerPlayerEntity)event.getPlayer();
            ServerWorld overworld = playerMP.func_184102_h().func_71218_a(respawnDim);
            if (curDim.func_186068_a() == tentDim.func_186068_a() && null == (respawnPos = TentEventHandler.getBedPos(playerMP, tentDim))) {
                respawnPos = TentEventHandler.getBedPos(playerMP, respawnDim);
                if (null == respawnPos) {
                    respawnPos = overworld.func_175694_M();
                }
                TentTeleporter tel = new TentTeleporter(playerMP.func_184102_h(), tentDim, respawnDim, new BlockPos(0, 0, 0), null, respawnPos.func_177958_n(), respawnPos.func_177956_o(), respawnPos.func_177952_p(), playerMP.field_70177_z, new TentData());
                tel.func_85188_a((Entity)playerMP);
                playerMP.func_70634_a((double)respawnPos.func_177958_n(), (double)respawnPos.func_177956_o(), (double)respawnPos.func_177952_p());
            }
        }
    }

    private static BlockPos getBedPos(ServerPlayerEntity player, DimensionType dim) {
        BlockPos bedPos = player.getBedLocation(dim);
        boolean flag = player.isSpawnForced(dim);
        if (bedPos != null) {
            Optional optional = PlayerEntity.func_213822_a((IWorldReader)player.func_184102_h().func_71218_a(dim), (BlockPos)bedPos, (boolean)flag);
            return optional.isPresent() ? new BlockPos((Vec3d)optional.get()) : null;
        }
        return bedPos;
    }

    @SubscribeEvent
    public void onNameFormat(PlayerEvent.NameFormat event) {
        String prefix = "[Nomad King] ";
        String gold = TextFormatting.GOLD.toString();
        String reset = TextFormatting.RESET.toString();
        if ("skyjay1".equals(event.getUsername())) {
            String special = gold + prefix + reset;
            event.setDisplayname(special.concat(event.getDisplayname()));
        }
    }
}

