/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.init;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import nomadictents.event.ClientTentEventHandler;
import nomadictents.event.TentEventHandler;
import nomadictents.init.Content;
import nomadictents.init.TentConfig;
import nomadictents.proxies.ClientProxy;
import nomadictents.proxies.CommonProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nomadictents")
@Mod.EventBusSubscriber(modid="nomadictents", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NomadicTents {
    public static final String MODID = "nomadictents";
    public static final String HWYLA = "waila";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new CommonProxy());
    public static final ItemGroup TAB = new ItemGroup("nomadictents"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Content.ITEM_TENT);
        }
    };
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"nomadictents");

    public NomadicTents() {
        LOGGER.debug("nomadictents: RegisterConfig");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, TentConfig.SPEC);
        LOGGER.debug("nomadictents: RegisterEventHandlers");
        MinecraftForge.EVENT_BUS.register((Object)new TentEventHandler());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                FMLJavaModLoadingContext.get().getModEventBus().register(ClientTentEventHandler.class);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while registering Client-Side event handler");
                LOGGER.error(e.getMessage());
            }
        });
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        LOGGER.debug("nomadictents: RegisterBlocks");
        PROXY.registerBlocks(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        LOGGER.debug("nomadictents: RegisterItems");
        PROXY.registerItems(event);
    }

    @SubscribeEvent
    public static void registerTileEntity(RegistryEvent.Register<TileEntityType<?>> event) {
        LOGGER.debug("nomadictents: RegisterTileEntityType");
        PROXY.registerTileEntity(event);
    }

    @SubscribeEvent
    public static void registerDimension(RegistryEvent.Register<ModDimension> event) {
        LOGGER.debug("nomadictents: RegisterDimension");
        PROXY.registerDimension(event);
    }

    @SubscribeEvent
    public static void registerBiome(RegistryEvent.Register<Biome> event) {
        LOGGER.debug("nomadictents: RegisterBiome");
        PROXY.registerBiome(event);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        LOGGER.debug("nomadictents: RegisterRecipeSerializer");
        PROXY.registerRecipeSerializers(event);
    }
}

