/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.init;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;
import nomadictents.dimension.TentDimensionManager;

public class TentSaveData
extends WorldSavedData {
    private static final String ID_COUNT = "IDCount";
    private static final String KEY_SPAWNS = "PlayerSpawnPoints";
    private static final String _UUID = ".UUID";
    private static final String _X = ".X";
    private static final String _Y = ".Y";
    private static final String _Z = ".Z";
    private long idCount = 0L;
    private Map<UUID, BlockPos> prevSpawnMap = new HashMap<UUID, BlockPos>();

    public TentSaveData(String s) {
        super(s);
    }

    public static TentSaveData get(MinecraftServer server) {
        return (TentSaveData)TentDimensionManager.getOverworld(server).func_217481_x().func_215752_a(() -> new TentSaveData("nomadictents"), "nomadictents");
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.idCount = nbt.func_74763_f(ID_COUNT);
        ListNBT tagList = nbt.func_150295_c(KEY_SPAWNS, 9);
        int l = tagList.size();
        for (int i = 0; i < l; ++i) {
            CompoundNBT nbtCompound = tagList.func_150305_b(i);
            if (!nbtCompound.func_74764_b("PlayerSpawnPoints.UUID") || !nbtCompound.func_74764_b("PlayerSpawnPoints.X") || !nbtCompound.func_74764_b("PlayerSpawnPoints.Y") || !nbtCompound.func_74764_b("PlayerSpawnPoints.Z")) continue;
            UUID uuid = UUID.fromString(nbtCompound.func_74779_i("PlayerSpawnPoints.UUID"));
            int x = nbtCompound.func_74762_e("PlayerSpawnPoints.X");
            int y = nbtCompound.func_74762_e("PlayerSpawnPoints.Y");
            int z = nbtCompound.func_74762_e("PlayerSpawnPoints.Z");
            this.prevSpawnMap.put(uuid, new BlockPos(x, y, z));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        nbt.func_74772_a(ID_COUNT, this.idCount);
        ListNBT tagList = new ListNBT();
        for (Map.Entry<UUID, BlockPos> uuid : this.prevSpawnMap.entrySet()) {
            BlockPos prevSpawn = uuid.getValue();
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74778_a("PlayerSpawnPoints.UUID", uuid.toString());
            tagCompound.func_74768_a("PlayerSpawnPoints.X", prevSpawn.func_177958_n());
            tagCompound.func_74768_a("PlayerSpawnPoints.Y", prevSpawn.func_177956_o());
            tagCompound.func_74768_a("PlayerSpawnPoints.Z", prevSpawn.func_177952_p());
            tagList.add((Object)tagCompound);
        }
        nbt.func_218657_a(KEY_SPAWNS, (INBT)tagList);
        return nbt;
    }

    public long getNextID() {
        this.func_76185_a();
        return ++this.idCount;
    }

    public long getCurrentID() {
        return this.idCount;
    }

    public void putSpawn(UUID uuid, BlockPos pos) {
        if (uuid != null) {
            this.func_76185_a();
            this.prevSpawnMap.put(uuid, pos);
        }
    }

    public boolean containsSpawn(UUID uuid) {
        return this.prevSpawnMap.containsKey(uuid);
    }

    @Nullable
    public BlockPos getSpawn(UUID uuid) {
        return this.prevSpawnMap.get(uuid);
    }

    @Nullable
    public BlockPos removeSpawn(UUID uuid) {
        this.func_76185_a();
        return this.prevSpawnMap.remove(uuid);
    }
}

