/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.plugins.vanilla.crafting.CraftingCategoryExtension;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.Ingredient;
import nomadictents.crafting.RecipeUpgradeDepth;
import nomadictents.item.ItemTent;
import nomadictents.structure.util.TentData;

public final class JEIDepthRecipe {
    private JEIDepthRecipe() {
    }

    public static final class Wrapper
    extends CraftingCategoryExtension<RecipeUpgradeDepth> {
        private final RecipeUpgradeDepth recipe;

        public Wrapper(RecipeUpgradeDepth recipeIn) {
            super((ICraftingRecipe)recipeIn);
            this.recipe = recipeIn;
        }

        public int getWidth() {
            return this.recipe.func_192403_f();
        }

        public int getHeight() {
            return this.recipe.func_192404_g();
        }

        public void setIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> inputList = new ArrayList<List<ItemStack>>();
            for (Ingredient ingredient : this.recipe.func_192400_c()) {
                for (ItemStack stack : ingredient.func_193365_a()) {
                    if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemTent)) continue;
                    TentData data = new TentData(stack).setAll(this.recipe.getTentType(), this.recipe.getMinSize(), this.recipe.getDepthIn());
                    data.writeTo(stack);
                }
                inputList.add(Arrays.asList(ingredient.func_193365_a()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, inputList);
            ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(this.recipe.func_77571_b()));
        }

        public RecipeUpgradeDepth getRecipe() {
            return this.recipe;
        }
    }
}

