/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.integration;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import nomadictents.block.BlockTentDoor;
import nomadictents.block.BlockTentFrame;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.init.Content;
import nomadictents.structure.util.TentData;

@WailaPlugin(value="nomadictents")
public final class WailaProvider
implements IWailaPlugin,
IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final WailaProvider INSTANCE = new WailaProvider();
    private static final String KEY_STRUCTURE_DATA = "TentData";

    public void register(IRegistrar register) {
        register.registerBlockDataProvider((IServerDataProvider)INSTANCE, BlockTentDoor.class);
        register.registerStackProvider((IComponentProvider)INSTANCE, BlockTentDoor.class);
        register.registerStackProvider((IComponentProvider)INSTANCE, BlockTentFrame.class);
        register.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.HEAD, BlockTentDoor.class);
        register.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.HEAD, BlockTentFrame.class);
        register.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, BlockTentFrame.class);
    }

    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof BlockTentDoor) {
            return new TentData(accessor.getServerData().func_74775_l(KEY_STRUCTURE_DATA)).getDropStack();
        }
        if (accessor.getBlock() instanceof BlockTentFrame) {
            return new ItemStack((IItemProvider)((BlockTentFrame)accessor.getBlock()).getBlockToBecome().func_177230_c());
        }
        return accessor.getStack();
    }

    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof BlockTentDoor) {
            TentData data = accessor.getServerData() != null && accessor.getServerData().func_74764_b(KEY_STRUCTURE_DATA) ? new TentData(accessor.getServerData().func_74775_l(KEY_STRUCTURE_DATA)) : new TentData();
            ITextComponent name = Content.ITEM_TENT.func_200295_i(data.getDropStack());
            tooltip.set(0, name.func_211708_a(TextFormatting.WHITE));
        } else if (accessor.getBlock() instanceof BlockTentFrame) {
            String header = accessor.getBlock().func_149739_a();
            tooltip.set(0, new TranslationTextComponent(header, new Object[0]).func_211708_a(TextFormatting.WHITE));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof BlockTentFrame) {
            float data = ((Integer)accessor.getBlockState().func_177229_b((IProperty)BlockTentFrame.PROGRESS)).intValue();
            String progress = "waila.progress";
            int percentInt = (int)(data / 7.0f * 100.0f);
            String percent = percentInt + "%";
            tooltip.add(new TranslationTextComponent(progress, new Object[]{percent}).func_211708_a(TextFormatting.GRAY));
        }
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, TileEntity tileEntity) {
        BlockState state = world.func_180495_p(tileEntity.func_174877_v());
        if (state != null && state.func_177230_c() instanceof BlockTentDoor && state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            tileEntity = world.func_175625_s(tileEntity.func_174877_v().func_177979_c(1));
        }
        if (tileEntity instanceof TileEntityTentDoor) {
            TileEntityTentDoor tetd = (TileEntityTentDoor)tileEntity;
            tag.func_218657_a(KEY_STRUCTURE_DATA, (INBT)tetd.getTentData().serializeNBT());
        }
    }
}

