/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.init.NomadicTents;
import nomadictents.init.TentConfig;
import nomadictents.init.TentSaveData;
import nomadictents.structure.StructureBase;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentDepth;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class ItemTent
extends Item {
    public static final int ERROR_TAG = Short.MIN_VALUE;
    public static final String TENT_DATA = "TentData";
    public static final String TAG_COPY_TOOL = "TentCopyTool";

    public ItemTent() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(NomadicTents.TAB));
        this.func_185043_a(new ResourceLocation("nomadictents", "tent"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ItemTent.TENT_DATA)) {
                    TentData data = new TentData(stack.func_179543_a(ItemTent.TENT_DATA));
                    return data.getTent().getId() * TentWidth.NUM_ENTRIES + data.getWidth().getId();
                }
                return 0.0f;
            }
        });
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        super.func_77622_d(stack, world, player);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext cxt) {
        if (!TentConfig.CONFIG.isDimBlacklisted(cxt.func_195991_k().func_201675_m().func_186058_p())) {
            BlockPos hitPos = cxt.func_195995_a().func_177984_a();
            Direction hitSide = cxt.func_196000_l();
            if (stack == null || stack.func_190926_b() || hitSide != Direction.UP) {
                return ActionResultType.FAIL;
            }
            if (ItemTent.shouldAssignID(stack.func_190925_c(TENT_DATA))) {
                CompoundNBT tag = ItemTent.assignID(cxt.func_195991_k(), stack);
                stack.func_77978_p().func_218657_a(TENT_DATA, (INBT)tag);
            }
            if (cxt.func_195999_j() == null || !cxt.func_195999_j().func_175151_a(hitPos, hitSide, stack)) {
                return ActionResultType.FAIL;
            }
            Direction playerFacing = cxt.func_195999_j().func_174811_aO();
            TentData data = new TentData(stack.func_179543_a(TENT_DATA));
            StructureBase struct = data.getStructure();
            if (struct.canGenerateFrameStructure(cxt.func_195991_k(), hitPos, data, playerFacing) && struct.generateFrameStructure(cxt.func_195991_k(), hitPos, data, playerFacing)) {
                TileEntity te = cxt.func_195991_k().func_175625_s(hitPos);
                if (te instanceof TileEntityTentDoor) {
                    TentData.applyToTileEntity(cxt.func_195999_j(), stack, (TileEntityTentDoor)te);
                } else {
                    NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + hitPos);
                }
                stack.func_190920_e(0);
            }
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TentData data = new TentData(stack);
        String prefix = "item.".concat("nomadictents").concat(".");
        return new TranslationTextComponent(prefix + data.getTent().func_176610_l() + "_" + data.getWidth().func_176610_l(), new Object[0]);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (tab != NomadicTents.TAB) {
            return;
        }
        TentDepth depth = TentDepth.NORMAL;
        for (TentType tent : TentType.values()) {
            for (TentWidth size : TentWidth.values()) {
                TentData data = new TentData().setAll(tent, size, depth);
                items.add((Object)data.getDropStack());
            }
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 0x7FFFFFFE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TentData data = new TentData(stack);
        TextFormatting color = data.getWidth().getTooltipColor();
        tooltip.add(new TranslationTextComponent("tooltip.extra_dimensional_space", new Object[0]).func_211708_a(color));
        if (data.getTent() == TentType.SHAMIANA) {
            String s = new TranslationTextComponent(data.getColor().func_176762_d(), new Object[0]).func_150254_d();
            s = s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
            tooltip.add(new StringTextComponent(s).func_211709_a(new TextFormatting[]{TextFormatting.WHITE, TextFormatting.ITALIC}));
        }
        int depthCount = TentDepth.countUpgrades(data);
        int maxCount = TentDepth.maxUpgrades(data);
        if (depthCount > 0 || flagIn.func_194127_a() || Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("tooltip.depth_upgrades", new Object[]{depthCount, maxCount}).func_211708_a(TextFormatting.GRAY));
        }
        if (flagIn.func_194127_a() || Screen.hasShiftDown()) {
            String id = data.getID() == -32768L ? "None" : String.valueOf(data.getID());
            tooltip.add(new TranslationTextComponent("tooltip.id", new Object[]{id}).func_211708_a(TextFormatting.GRAY));
        }
    }

    public static boolean shouldAssignID(CompoundNBT tentData) {
        return !tentData.func_74764_b("ID") || tentData.func_74763_f("ID") == -32768L;
    }

    public static CompoundNBT assignID(World world, ItemStack stack) {
        if (!world.field_72995_K) {
            TentData data = new TentData(stack);
            if (data.getID() == -32768L) {
                data.setID(ItemTent.getNextID(world));
            }
            return data.serializeNBT();
        }
        return new CompoundNBT();
    }

    public static long getNextID(World world) {
        return world.field_72995_K ? -1L : TentSaveData.get(world.func_73046_m()).getNextID();
    }
}

