/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.structure.StructureBase;
import nomadictents.structure.util.Blueprint;
import nomadictents.structure.util.TentData;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public class StructureBedouin
extends StructureBase {
    @Override
    public TentType getTentType() {
        return TentType.BEDOUIN;
    }

    @Override
    public boolean generate(World worldIn, BlockPos doorBase, TentData data, Direction dirForward, BlockState doorBlock, BlockState wallBlock, BlockState roofBlock) {
        boolean tentDim = TentDimensionManager.isTent((IWorld)worldIn);
        Blueprint bp = StructureBedouin.getBlueprints(data);
        if (bp == null) {
            return false;
        }
        this.buildLayer(worldIn, doorBase, dirForward, wallBlock, bp.getWallCoords());
        this.buildLayer(worldIn, doorBase, dirForward, roofBlock, bp.getRoofCoords());
        StructureBedouin.buildDoor(worldIn, doorBase, doorBlock, dirForward);
        if (this.getTentType().areFeaturesEnabled() && tentDim && wallBlock.func_185904_a() != Material.field_151579_a) {
            BlockState fire;
            BlockPos center = StructureBedouin.getCenter(doorBase, data.getWidth(), dirForward);
            BlockState blockState = fire = data.getWidth() == TentWidth.SMALL ? Blocks.field_150478_aa.func_176223_P() : (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((IProperty)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(true));
            if (worldIn.func_175623_d(center.func_177977_b()) || worldIn.func_180495_p(center.func_177977_b()).func_177230_c() == Blocks.field_150346_d) {
                worldIn.func_180501_a(center.func_177977_b(), Blocks.field_150347_e.func_176223_P(), 2);
            }
            if (worldIn.func_175623_d(center)) {
                worldIn.func_180501_a(center, fire, 2);
            }
        }
        return !bp.isEmpty();
    }

    /*
     * Opcode count of 16754 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static Blueprint makeBlueprints(TentWidth TentWidth2) {
        Blueprint bp = new Blueprint();
        switch (TentWidth2) {
            case SMALL: {
                bp.addWallCoords(new int[][]{{0, 0, 1}, {0, 0, 0}, {0, 0, -1}, {1, 0, -2}, {2, 0, -2}, {3, 0, -2}, {4, 0, -1}, {4, 0, 0}, {4, 0, 1}, {3, 0, 2}, {2, 0, 2}, {1, 0, 2}, {0, 1, 1}, {0, 1, 0}, {0, 1, -1}, {1, 1, -2}, {2, 1, -2}, {3, 1, -2}, {4, 1, -1}, {4, 1, 0}, {4, 1, 1}, {3, 1, 2}, {2, 1, 2}, {1, 1, 2}});
                bp.addRoofCoords(new int[][]{{0, 2, 0}, {1, 2, 1}, {2, 2, 1}, {3, 2, 1}, {4, 2, 0}, {1, 2, -1}, {2, 2, -1}, {3, 2, -1}, {1, 3, 0}, {2, 3, 0}, {3, 3, 0}});
                break;
            }
            case MEDIUM: {
                bp.addWallCoords(new int[][]{{0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {1, 0, 3}, {2, 0, 3}, {3, 0, 3}, {4, 0, 3}, {5, 0, 3}, {6, 0, -2}, {6, 0, -1}, {6, 0, 0}, {6, 0, 1}, {6, 0, 2}, {1, 0, -3}, {2, 0, -3}, {3, 0, -3}, {4, 0, -3}, {5, 0, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {1, 1, 3}, {2, 1, 3}, {3, 1, 3}, {4, 1, 3}, {5, 1, 3}, {6, 1, -2}, {6, 1, -1}, {6, 1, 0}, {6, 1, 1}, {6, 1, 2}, {1, 1, -3}, {2, 1, -3}, {3, 1, -3}, {4, 1, -3}, {5, 1, -3}});
                bp.addRoofCoords(new int[][]{{0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {1, 2, 2}, {2, 2, 2}, {3, 2, 2}, {4, 2, 2}, {5, 2, 2}, {6, 2, -1}, {6, 2, 0}, {6, 2, 1}, {1, 2, -2}, {2, 2, -2}, {3, 2, -2}, {4, 2, -2}, {5, 2, -2}, {0, 3, 0}, {1, 3, 1}, {2, 3, 1}, {3, 3, 1}, {4, 3, 1}, {5, 3, 1}, {6, 3, 0}, {1, 3, -1}, {2, 3, -1}, {3, 3, -1}, {4, 3, -1}, {5, 3, -1}, {1, 3, 0}, {2, 3, 0}, {3, 3, 0}, {4, 3, 0}, {5, 3, 0}});
                break;
            }
            case LARGE: {
                bp.addWallCoords(new int[][]{{0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {1, 0, 4}, {2, 0, 4}, {3, 0, 4}, {4, 0, 4}, {5, 0, 4}, {6, 0, 4}, {7, 0, 4}, {8, 0, -3}, {8, 0, -2}, {8, 0, -1}, {8, 0, 0}, {8, 0, 1}, {8, 0, 2}, {8, 0, 3}, {1, 0, -4}, {2, 0, -4}, {3, 0, -4}, {4, 0, -4}, {5, 0, -4}, {6, 0, -4}, {7, 0, -4}, {0, 1, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {1, 1, 4}, {2, 1, 4}, {3, 1, 4}, {4, 1, 4}, {5, 1, 4}, {6, 1, 4}, {7, 1, 4}, {8, 1, -3}, {8, 1, -2}, {8, 1, -1}, {8, 1, 0}, {8, 1, 1}, {8, 1, 2}, {8, 1, 3}, {1, 1, -4}, {2, 1, -4}, {3, 1, -4}, {4, 1, -4}, {5, 1, -4}, {6, 1, -4}, {7, 1, -4}});
                bp.addRoofCoords(new int[][]{{0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {1, 2, 3}, {2, 2, 3}, {3, 2, 3}, {4, 2, 3}, {5, 2, 3}, {6, 2, 3}, {7, 2, 3}, {8, 2, -2}, {8, 2, -1}, {8, 2, 0}, {8, 2, 1}, {8, 2, 2}, {1, 2, -3}, {2, 2, -3}, {3, 2, -3}, {4, 2, -3}, {5, 2, -3}, {6, 2, -3}, {7, 2, -3}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {8, 3, -1}, {8, 3, 0}, {8, 3, 1}, {1, 3, 2}, {2, 3, 2}, {3, 3, 2}, {4, 3, 2}, {5, 3, 2}, {6, 3, 2}, {7, 3, 2}, {1, 3, -2}, {2, 3, -2}, {3, 3, -2}, {4, 3, -2}, {5, 3, -2}, {6, 3, -2}, {7, 3, -2}, {0, 4, 0}, {8, 4, 0}, {1, 4, 1}, {2, 4, 1}, {3, 4, 1}, {4, 4, 1}, {5, 4, 1}, {6, 4, 1}, {7, 4, 1}, {1, 4, -1}, {2, 4, -1}, {3, 4, -1}, {4, 4, -1}, {5, 4, -1}, {6, 4, -1}, {7, 4, -1}, {1, 5, 0}, {2, 5, 0}, {3, 5, 0}, {4, 5, 0}, {5, 5, 0}, {6, 5, 0}, {7, 5, 0}});
                break;
            }
            case HUGE: {
                bp.addWallCoords(new int[][]{{0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {1, 0, 4}, {2, 0, 5}, {3, 0, 5}, {4, 0, 5}, {5, 0, 5}, {6, 0, 5}, {7, 0, 5}, {8, 0, 5}, {9, 0, 4}, {10, 0, 3}, {10, 0, 2}, {10, 0, 1}, {10, 0, 0}, {10, 0, -1}, {10, 0, -2}, {10, 0, -3}, {9, 0, -4}, {8, 0, -5}, {7, 0, -5}, {6, 0, -5}, {5, 0, -5}, {4, 0, -5}, {3, 0, -5}, {2, 0, -5}, {1, 0, -4}, {0, 1, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {1, 1, 4}, {2, 1, 5}, {3, 1, 5}, {4, 1, 5}, {5, 1, 5}, {6, 1, 5}, {7, 1, 5}, {8, 1, 5}, {9, 1, 4}, {10, 1, 3}, {10, 1, 2}, {10, 1, 1}, {10, 1, 0}, {10, 1, -1}, {10, 1, -2}, {10, 1, -3}, {9, 1, -4}, {8, 1, -5}, {7, 1, -5}, {6, 1, -5}, {5, 1, -5}, {4, 1, -5}, {3, 1, -5}, {2, 1, -5}, {1, 1, -4}});
                bp.addRoofCoords(new int[][]{{0, 2, -3}, {0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 2, 3}, {1, 2, 4}, {2, 2, 4}, {3, 2, 4}, {4, 2, 4}, {5, 2, 4}, {6, 2, 4}, {7, 2, 4}, {8, 2, 4}, {9, 2, 4}, {10, 2, 3}, {10, 2, 2}, {10, 2, 1}, {10, 2, 0}, {10, 2, -1}, {10, 2, -2}, {10, 2, -3}, {1, 2, -4}, {2, 2, -4}, {3, 2, -4}, {4, 2, -4}, {5, 2, -4}, {6, 2, -4}, {7, 2, -4}, {8, 2, -4}, {9, 2, -4}, {0, 3, -2}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {0, 3, 2}, {1, 3, 3}, {2, 3, 3}, {3, 3, 3}, {4, 3, 3}, {5, 3, 3}, {6, 3, 3}, {7, 3, 3}, {8, 3, 3}, {9, 3, 3}, {10, 3, 2}, {10, 3, 1}, {10, 3, 0}, {10, 3, -1}, {10, 3, -2}, {1, 3, -3}, {2, 3, -3}, {3, 3, -3}, {4, 3, -3}, {5, 3, -3}, {6, 3, -3}, {7, 3, -3}, {8, 3, -3}, {9, 3, -3}, {0, 4, -1}, {0, 4, 0}, {0, 4, 1}, {1, 4, 2}, {2, 4, 2}, {3, 4, 2}, {4, 4, 2}, {5, 4, 2}, {6, 4, 2}, {7, 4, 2}, {8, 4, 2}, {9, 4, 2}, {10, 4, 1}, {10, 4, 0}, {10, 4, -1}, {1, 4, -2}, {2, 4, -2}, {3, 4, -2}, {4, 4, -2}, {5, 4, -2}, {6, 4, -2}, {7, 4, -2}, {8, 4, -2}, {9, 4, -2}, {0, 5, 0}, {10, 5, 0}, {1, 5, 1}, {2, 5, 1}, {3, 5, 1}, {4, 5, 1}, {5, 5, 1}, {6, 5, 1}, {7, 5, 1}, {8, 5, 1}, {9, 5, 1}, {1, 5, -1}, {2, 5, -1}, {3, 5, -1}, {4, 5, -1}, {5, 5, -1}, {6, 5, -1}, {7, 5, -1}, {8, 5, -1}, {9, 5, -1}, {1, 6, 0}, {2, 6, 0}, {3, 6, 0}, {4, 6, 0}, {5, 6, 0}, {6, 6, 0}, {7, 6, 0}, {8, 6, 0}, {9, 6, 0}});
                break;
            }
            case GIANT: {
                bp.addWallCoords(new int[][]{{0, 0, -4}, {0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {0, 0, 4}, {1, 0, 5}, {2, 0, 6}, {3, 0, 6}, {4, 0, 6}, {5, 0, 6}, {6, 0, 6}, {7, 0, 6}, {8, 0, 6}, {9, 0, 6}, {10, 0, 6}, {11, 0, 5}, {12, 0, 4}, {12, 0, 3}, {12, 0, 2}, {12, 0, 1}, {12, 0, 0}, {12, 0, -1}, {12, 0, -2}, {12, 0, -3}, {12, 0, -4}, {11, 0, -5}, {10, 0, -6}, {9, 0, -6}, {8, 0, -6}, {7, 0, -6}, {6, 0, -6}, {5, 0, -6}, {4, 0, -6}, {3, 0, -6}, {2, 0, -6}, {1, 0, -5}, {0, 1, -4}, {0, 1, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {1, 1, 5}, {2, 1, 6}, {3, 1, 6}, {4, 1, 6}, {5, 1, 6}, {6, 1, 6}, {7, 1, 6}, {8, 1, 6}, {9, 1, 6}, {10, 1, 6}, {11, 1, 5}, {12, 1, 4}, {12, 1, 3}, {12, 1, 2}, {12, 1, 1}, {12, 1, 0}, {12, 1, -1}, {12, 1, -2}, {12, 1, -3}, {12, 1, -4}, {11, 1, -5}, {10, 1, -6}, {9, 1, -6}, {8, 1, -6}, {7, 1, -6}, {6, 1, -6}, {5, 1, -6}, {4, 1, -6}, {3, 1, -6}, {2, 1, -6}, {1, 1, -5}});
                bp.addRoofCoords(new int[][]{{0, 2, -4}, {0, 2, -3}, {0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 2, 3}, {0, 2, 4}, {1, 2, 5}, {2, 2, 5}, {3, 2, 5}, {4, 2, 5}, {5, 2, 5}, {6, 2, 5}, {7, 2, 5}, {8, 2, 5}, {9, 2, 5}, {10, 2, 5}, {11, 2, 5}, {12, 2, -4}, {12, 2, -3}, {12, 2, -2}, {12, 2, -1}, {12, 2, 0}, {12, 2, 1}, {12, 2, 2}, {12, 2, 3}, {12, 2, 4}, {1, 2, -5}, {2, 2, -5}, {3, 2, -5}, {4, 2, -5}, {5, 2, -5}, {6, 2, -5}, {7, 2, -5}, {8, 2, -5}, {9, 2, -5}, {10, 2, -5}, {11, 2, -5}, {0, 3, -3}, {0, 3, -2}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {0, 3, 2}, {0, 3, 3}, {1, 3, 4}, {2, 3, 4}, {3, 3, 4}, {4, 3, 4}, {5, 3, 4}, {6, 3, 4}, {7, 3, 4}, {8, 3, 4}, {9, 3, 4}, {10, 3, 4}, {11, 3, 4}, {12, 3, 3}, {12, 3, 2}, {12, 3, 1}, {12, 3, 0}, {12, 3, -1}, {12, 3, -2}, {12, 3, -3}, {1, 3, -4}, {2, 3, -4}, {3, 3, -4}, {4, 3, -4}, {5, 3, -4}, {6, 3, -4}, {7, 3, -4}, {8, 3, -4}, {9, 3, -4}, {10, 3, -4}, {11, 3, -4}, {0, 4, -2}, {0, 4, -1}, {0, 4, 0}, {0, 4, 1}, {0, 4, 2}, {1, 4, 3}, {2, 4, 3}, {3, 4, 3}, {4, 4, 3}, {5, 4, 3}, {6, 4, 3}, {7, 4, 3}, {8, 4, 3}, {9, 4, 3}, {10, 4, 3}, {11, 4, 3}, {12, 4, 2}, {12, 4, 1}, {12, 4, 0}, {12, 4, -1}, {12, 4, -2}, {1, 4, -3}, {2, 4, -3}, {3, 4, -3}, {4, 4, -3}, {5, 4, -3}, {6, 4, -3}, {7, 4, -3}, {8, 4, -3}, {9, 4, -3}, {10, 4, -3}, {11, 4, -3}, {0, 5, -1}, {0, 5, 0}, {0, 5, 1}, {1, 5, 2}, {2, 5, 2}, {3, 5, 2}, {4, 5, 2}, {5, 5, 2}, {6, 5, 2}, {7, 5, 2}, {8, 5, 2}, {9, 5, 2}, {10, 5, 2}, {11, 5, 2}, {12, 5, 1}, {12, 5, 0}, {12, 5, -1}, {1, 5, -2}, {2, 5, -2}, {3, 5, -2}, {4, 5, -2}, {5, 5, -2}, {6, 5, -2}, {7, 5, -2}, {8, 5, -2}, {9, 5, -2}, {10, 5, -2}, {11, 5, -2}, {12, 6, 0}, {0, 6, 0}, {1, 6, 1}, {2, 6, 1}, {3, 6, 1}, {4, 6, 1}, {5, 6, 1}, {6, 6, 1}, {7, 6, 1}, {8, 6, 1}, {9, 6, 1}, {10, 6, 1}, {11, 6, 1}, {12, 6, 0}, {1, 6, -1}, {2, 6, -1}, {3, 6, -1}, {4, 6, -1}, {5, 6, -1}, {6, 6, -1}, {7, 6, -1}, {8, 6, -1}, {9, 6, -1}, {10, 6, -1}, {11, 6, -1}, {1, 7, 0}, {2, 7, 0}, {3, 7, 0}, {4, 7, 0}, {5, 7, 0}, {6, 7, 0}, {7, 7, 0}, {8, 7, 0}, {9, 7, 0}, {10, 7, 0}, {11, 7, 0}});
                break;
            }
            case MEGA: {
                bp.addWallCoords(new int[][]{{0, 0, -5}, {0, 0, -4}, {0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {0, 0, 4}, {0, 0, 5}, {1, 0, 6}, {2, 0, 7}, {3, 0, 7}, {4, 0, 7}, {5, 0, 7}, {6, 0, 7}, {7, 0, 7}, {8, 0, 7}, {9, 0, 7}, {10, 0, 7}, {11, 0, 7}, {12, 0, 6}, {13, 0, 5}, {13, 0, 4}, {13, 0, 3}, {13, 0, 2}, {13, 0, 1}, {13, 0, 0}, {13, 0, -1}, {13, 0, -2}, {13, 0, -3}, {13, 0, -4}, {13, 0, -5}, {12, 0, -6}, {11, 0, -7}, {10, 0, -7}, {9, 0, -7}, {8, 0, -7}, {7, 0, -7}, {6, 0, -7}, {5, 0, -7}, {4, 0, -7}, {3, 0, -7}, {2, 0, -7}, {1, 0, -6}, {0, 1, -5}, {0, 1, -4}, {0, 1, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 1, 5}, {1, 1, 6}, {2, 1, 7}, {3, 1, 7}, {4, 1, 7}, {5, 1, 7}, {6, 1, 7}, {7, 1, 7}, {8, 1, 7}, {9, 1, 7}, {10, 1, 7}, {11, 1, 7}, {12, 1, 6}, {13, 1, 5}, {13, 1, 4}, {13, 1, 3}, {13, 1, 2}, {13, 1, 1}, {13, 1, 0}, {13, 1, -1}, {13, 1, -2}, {13, 1, -3}, {13, 1, -4}, {13, 1, -5}, {12, 1, -6}, {11, 1, -7}, {10, 1, -7}, {9, 1, -7}, {8, 1, -7}, {7, 1, -7}, {6, 1, -7}, {5, 1, -7}, {4, 1, -7}, {3, 1, -7}, {2, 1, -7}, {1, 1, -6}});
                bp.addRoofCoords(new int[][]{{0, 2, -5}, {0, 2, -4}, {0, 2, -3}, {0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 2, 3}, {0, 2, 4}, {0, 2, 5}, {1, 2, 6}, {2, 2, 6}, {3, 2, 6}, {4, 2, 6}, {5, 2, 6}, {6, 2, 6}, {7, 2, 6}, {8, 2, 6}, {9, 2, 6}, {10, 2, 6}, {11, 2, 6}, {12, 2, 6}, {13, 2, 5}, {13, 2, 4}, {13, 2, 3}, {13, 2, 2}, {13, 2, 1}, {13, 2, 0}, {13, 2, -1}, {13, 2, -2}, {13, 2, -3}, {13, 2, -4}, {13, 2, -5}, {12, 2, -6}, {11, 2, -6}, {10, 2, -6}, {9, 2, -6}, {8, 2, -6}, {7, 2, -6}, {6, 2, -6}, {5, 2, -6}, {4, 2, -6}, {3, 2, -6}, {2, 2, -6}, {1, 2, -6}, {0, 3, -4}, {0, 3, -3}, {0, 3, -2}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {0, 3, 2}, {0, 3, 3}, {0, 3, 4}, {1, 3, 5}, {1, 3, -5}, {2, 3, 5}, {3, 3, 5}, {4, 3, 5}, {5, 3, 5}, {6, 3, 5}, {7, 3, 5}, {8, 3, 5}, {9, 3, 5}, {10, 3, 5}, {11, 3, 5}, {12, 3, 5}, {13, 3, 4}, {13, 3, 3}, {13, 3, 2}, {13, 3, 1}, {13, 3, 0}, {13, 3, -1}, {13, 3, -2}, {13, 3, -3}, {13, 3, -4}, {2, 3, -5}, {3, 3, -5}, {4, 3, -5}, {5, 3, -5}, {6, 3, -5}, {7, 3, -5}, {8, 3, -5}, {9, 3, -5}, {10, 3, -5}, {11, 3, -5}, {12, 3, -5}, {0, 4, -3}, {0, 4, -2}, {0, 4, -1}, {0, 4, 0}, {0, 4, 1}, {0, 4, 2}, {0, 4, 3}, {1, 4, 4}, {1, 4, -4}, {2, 4, 4}, {3, 4, 4}, {4, 4, 4}, {5, 4, 4}, {6, 4, 4}, {7, 4, 4}, {8, 4, 4}, {9, 4, 4}, {10, 4, 4}, {11, 4, 4}, {12, 4, 4}, {13, 4, 3}, {13, 4, 2}, {13, 4, 1}, {13, 4, 0}, {13, 4, -1}, {13, 4, -2}, {13, 4, -3}, {2, 4, -4}, {3, 4, -4}, {4, 4, -4}, {5, 4, -4}, {6, 4, -4}, {7, 4, -4}, {8, 4, -4}, {9, 4, -4}, {10, 4, -4}, {11, 4, -4}, {12, 4, -4}, {0, 5, -2}, {0, 5, -1}, {0, 5, 0}, {0, 5, 1}, {0, 5, 2}, {1, 5, 3}, {1, 5, -3}, {2, 5, 3}, {3, 5, 3}, {4, 5, 3}, {5, 5, 3}, {6, 5, 3}, {7, 5, 3}, {8, 5, 3}, {9, 5, 3}, {10, 5, 3}, {11, 5, 3}, {12, 5, 3}, {13, 5, 2}, {13, 5, 1}, {13, 5, 0}, {13, 5, -1}, {13, 5, -2}, {2, 5, -3}, {3, 5, -3}, {4, 5, -3}, {5, 5, -3}, {6, 5, -3}, {7, 5, -3}, {8, 5, -3}, {9, 5, -3}, {10, 5, -3}, {11, 5, -3}, {12, 5, -3}, {0, 6, -1}, {0, 6, 0}, {0, 6, 1}, {1, 6, 2}, {1, 6, -2}, {2, 6, 2}, {3, 6, 2}, {4, 6, 2}, {5, 6, 2}, {6, 6, 2}, {7, 6, 2}, {8, 6, 2}, {9, 6, 2}, {10, 6, 2}, {11, 6, 2}, {12, 6, 2}, {13, 6, 1}, {13, 6, 0}, {13, 6, -1}, {2, 6, -2}, {3, 6, -2}, {4, 6, -2}, {5, 6, -2}, {6, 6, -2}, {7, 6, -2}, {8, 6, -2}, {9, 6, -2}, {10, 6, -2}, {11, 6, -2}, {12, 6, -2}, {13, 7, 0}, {0, 7, 0}, {1, 7, 1}, {1, 7, -1}, {2, 7, 1}, {3, 7, 1}, {4, 7, 1}, {5, 7, 1}, {6, 7, 1}, {7, 7, 1}, {8, 7, 1}, {9, 7, 1}, {10, 7, 1}, {11, 7, 1}, {12, 7, 1}, {13, 7, 0}, {2, 7, -1}, {3, 7, -1}, {4, 7, -1}, {5, 7, -1}, {6, 7, -1}, {7, 7, -1}, {8, 7, -1}, {9, 7, -1}, {10, 7, -1}, {11, 7, -1}, {12, 7, -1}, {1, 8, 0}, {2, 8, 0}, {3, 8, 0}, {4, 8, 0}, {5, 8, 0}, {6, 8, 0}, {7, 8, 0}, {8, 8, 0}, {9, 8, 0}, {10, 8, 0}, {11, 8, 0}, {12, 8, 0}});
            }
        }
        return bp;
    }
}

