/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import nomadictents.structure.StructureBedouin;
import nomadictents.structure.StructureIndlu;
import nomadictents.structure.StructureShamiana;
import nomadictents.structure.StructureTepee;
import nomadictents.structure.StructureYurt;
import nomadictents.structure.util.Blueprint;
import nomadictents.structure.util.TentType;
import nomadictents.structure.util.TentWidth;

public final class Blueprints {
    private static final Map<TentKey, Blueprint> map = new HashMap<TentKey, Blueprint>();

    private Blueprints() {
    }

    private static boolean put(TentType tent, TentWidth width, Blueprint bp) {
        TentKey key = new TentKey(tent, width);
        map.put(key, bp);
        return true;
    }

    @Nullable
    public static Blueprint get(TentType tent, TentWidth width) {
        TentKey key = new TentKey(tent, width);
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    static {
        for (TentWidth width : TentWidth.values()) {
            Blueprints.put(TentType.YURT, width, StructureYurt.makeBlueprints(width));
            Blueprints.put(TentType.TEPEE, width, StructureTepee.makeBlueprints(width));
            Blueprints.put(TentType.BEDOUIN, width, StructureBedouin.makeBlueprints(width));
            Blueprints.put(TentType.INDLU, width, StructureIndlu.makeBlueprints(width));
            Blueprints.put(TentType.SHAMIANA, width, StructureShamiana.makeBlueprints(width));
        }
    }

    private static final class TentKey {
        private final TentType tent;
        private final TentWidth width;

        private TentKey(TentType tentIn, TentWidth widthIn) {
            this.tent = tentIn;
            this.width = widthIn;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tent == null ? 0 : this.tent.hashCode());
            result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TentKey && other.getClass() == this.getClass()) {
                TentKey tentKeyOther = (TentKey)other;
                return tentKeyOther.tent == this.tent && tentKeyOther.width == this.width;
            }
            return false;
        }
    }
}

