/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.structure.util;

import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.IStringSerializable;
import nomadictents.block.BlockYurtRoof;
import nomadictents.block.Categories;
import nomadictents.init.Content;
import nomadictents.init.TentConfig;
import nomadictents.structure.StructureBase;
import nomadictents.structure.StructureBedouin;
import nomadictents.structure.StructureIndlu;
import nomadictents.structure.StructureShamiana;
import nomadictents.structure.StructureTepee;
import nomadictents.structure.StructureYurt;

public enum TentType implements IStringSerializable
{
    YURT(new StructureYurt()){

        @Override
        public boolean isEnabled() {
            return (Boolean)TentConfig.CONFIG.ALLOW_YURT.get();
        }

        @Override
        public boolean areFeaturesEnabled() {
            return (Boolean)TentConfig.CONFIG.ENABLE_YURT_FEATURES.get();
        }

        @Override
        public int getMaxSize() {
            return (Integer)TentConfig.CONFIG.TIERS_YURT.get();
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IYurtBlock.class;
        }

        @Override
        public BlockState getRoofBlock(boolean insideTent) {
            return (BlockState)Content.YURT_ROOF.func_176223_P().func_206870_a((IProperty)BlockYurtRoof.OUTSIDE, (Comparable)Boolean.valueOf(!insideTent));
        }

        @Override
        public BlockState getFrameBlock(boolean isRoof) {
            return isRoof ? Content.FRAME_YURT_ROOF.func_176223_P() : Content.FRAME_YURT_WALL.func_176223_P();
        }

        @Override
        public BlockState getWallBlock(boolean insideTent) {
            return insideTent ? Content.YURT_WALL_INNER.func_176223_P() : Content.YURT_WALL_OUTER.func_176223_P();
        }
    }
    ,
    TEPEE(new StructureTepee()){

        @Override
        public boolean isEnabled() {
            return (Boolean)TentConfig.CONFIG.ALLOW_TEPEE.get();
        }

        @Override
        public boolean areFeaturesEnabled() {
            return (Boolean)TentConfig.CONFIG.ENABLE_TEPEE_FEATURES.get();
        }

        @Override
        public int getMaxSize() {
            return (Integer)TentConfig.CONFIG.TIERS_TEPEE.get();
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.ITepeeBlock.class;
        }

        @Override
        public BlockState getWallBlock(boolean insideTent) {
            return Content.TEPEE_WALL_BLANK.func_176223_P();
        }

        @Override
        public BlockState getRoofBlock(boolean insideTent) {
            return Content.TEPEE_WALL_BLANK.func_176223_P();
        }

        @Override
        public BlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_TEPEE_WALL.func_176223_P();
        }
    }
    ,
    BEDOUIN(new StructureBedouin()){

        @Override
        public boolean isEnabled() {
            return (Boolean)TentConfig.CONFIG.ALLOW_BEDOUIN.get();
        }

        @Override
        public boolean areFeaturesEnabled() {
            return (Boolean)TentConfig.CONFIG.ENABLE_BEDOUIN_FEATURES.get();
        }

        @Override
        public int getMaxSize() {
            return (Integer)TentConfig.CONFIG.TIERS_BEDOUIN.get();
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IBedouinBlock.class;
        }

        @Override
        public BlockState getWallBlock(boolean insideTent) {
            return Content.BEDOUIN_WALL.func_176223_P();
        }

        @Override
        public BlockState getRoofBlock(boolean insideTent) {
            return Content.BEDOUIN_ROOF.func_176223_P();
        }

        @Override
        public BlockState getFrameBlock(boolean isRoof) {
            return isRoof ? Content.FRAME_BEDOUIN_ROOF.func_176223_P() : Content.FRAME_BEDOUIN_WALL.func_176223_P();
        }
    }
    ,
    INDLU(new StructureIndlu()){

        @Override
        public boolean isEnabled() {
            return (Boolean)TentConfig.CONFIG.ALLOW_INDLU.get();
        }

        @Override
        public boolean areFeaturesEnabled() {
            return (Boolean)TentConfig.CONFIG.ENABLE_INDLU_FEATURES.get();
        }

        @Override
        public int getMaxSize() {
            return (Integer)TentConfig.CONFIG.TIERS_INDLU.get();
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IIndluBlock.class;
        }

        @Override
        public BlockState getRoofBlock(boolean insideTent) {
            return Content.INDLU_WALL_OUTER.func_176223_P();
        }

        @Override
        public BlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_INDLU_WALL.func_176223_P();
        }

        @Override
        public BlockState getWallBlock(boolean insideTent) {
            return insideTent ? Content.INDLU_WALL_INNER.func_176223_P() : Content.INDLU_WALL_OUTER.func_176223_P();
        }
    }
    ,
    SHAMIANA(new StructureShamiana()){

        @Override
        public boolean isEnabled() {
            return (Boolean)TentConfig.CONFIG.ALLOW_SHAMIANA.get();
        }

        @Override
        public boolean areFeaturesEnabled() {
            return (Boolean)TentConfig.CONFIG.ENABLE_SHAMIANA_FEATURES.get();
        }

        @Override
        public int getMaxSize() {
            return (Integer)TentConfig.CONFIG.TIERS_SHAMIANA.get();
        }

        @Override
        public Class<? extends Categories.ITentBlockBase> getInterface() {
            return Categories.IShamianaBlock.class;
        }

        @Override
        public BlockState getRoofBlock(boolean insideTent) {
            return Content.SHAMIANA_WALL_WHITE.func_176223_P();
        }

        @Override
        public BlockState getWallBlock(boolean insideTent) {
            return Content.SHAMIANA_WALL_WHITE.func_176223_P();
        }

        @Override
        public BlockState getFrameBlock(boolean isRoof) {
            return Content.FRAME_SHAMIANA_WALL.func_176223_P();
        }
    };

    private final StructureBase structure;

    private TentType(StructureBase struct) {
        this.structure = struct;
    }

    public StructureBase getStructure() {
        return this.structure;
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    public static TentType getById(byte id) {
        return TentType.values()[id];
    }

    public static TentType getByName(String name) {
        for (TentType t : TentType.values()) {
            if (!name.equals(t.func_176610_l())) continue;
            return t;
        }
        return YURT;
    }

    public String func_176610_l() {
        return this.toString().toLowerCase();
    }

    public abstract boolean isEnabled();

    public abstract boolean areFeaturesEnabled();

    public abstract Class<? extends Categories.ITentBlockBase> getInterface();

    public abstract BlockState getWallBlock(boolean var1);

    public abstract BlockState getRoofBlock(boolean var1);

    public abstract BlockState getFrameBlock(boolean var1);

    public abstract int getMaxSize();
}

