/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.ingredients.Ingredients;
import mezz.jei.recipes.InternalRecipeManagerPlugin;
import mezz.jei.recipes.RecipeCatalystBuilder;
import mezz.jei.recipes.RecipeCategoryComparator;
import mezz.jei.recipes.RecipeCategoryData;
import mezz.jei.recipes.RecipeCategoryDataMap;
import mezz.jei.recipes.RecipeManagerPluginSafeWrapper;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.util.ErrorUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManager
implements IRecipeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IngredientManager ingredientManager;
    private final ImmutableList<IRecipeCategory> recipeCategories;
    private final Set<ResourceLocation> hiddenRecipeCategoryUids = new HashSet<ResourceLocation>();
    private final List<IRecipeCategory> recipeCategoriesVisibleCache = new ArrayList<IRecipeCategory>();
    private final RecipeCategoryDataMap recipeCategoriesDataMap;
    private final RecipeCategoryComparator recipeCategoryComparator;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final List<RecipeManagerPluginSafeWrapper> plugins = new ArrayList<RecipeManagerPluginSafeWrapper>();

    public RecipeManager(ImmutableList<IRecipeCategory> recipeCategories, ImmutableListMultimap<ResourceLocation, Object> recipes, ImmutableListMultimap<ResourceLocation, Object> recipeCatalysts, IngredientManager ingredientManager, ImmutableList<IRecipeManagerPlugin> plugins) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        this.ingredientManager = ingredientManager;
        this.recipeCategories = ImmutableList.copyOf(recipeCategories);
        this.recipeCategoryComparator = new RecipeCategoryComparator((List<IRecipeCategory>)recipeCategories);
        this.recipeInputMap = new RecipeMap(this.recipeCategoryComparator, ingredientManager);
        this.recipeOutputMap = new RecipeMap(this.recipeCategoryComparator, ingredientManager);
        RecipeCatalystBuilder recipeCatalystBuilder = new RecipeCatalystBuilder(ingredientManager);
        for (IRecipeCategory recipeCategory : recipeCategories) {
            ResourceLocation recipeCategoryUid = recipeCategory.getUid();
            if (!recipeCatalysts.containsKey((Object)recipeCategoryUid)) continue;
            ImmutableList catalysts = recipeCatalysts.get((Object)recipeCategoryUid);
            recipeCatalystBuilder.addCatalysts(recipeCategory, (List<Object>)catalysts, this.recipeInputMap);
        }
        ImmutableListMultimap<IRecipeCategory, Object> recipeCatalystsMap = recipeCatalystBuilder.buildRecipeCatalysts();
        this.recipeCategoriesDataMap = new RecipeCategoryDataMap((List<IRecipeCategory>)recipeCategories, recipeCatalystsMap);
        ImmutableMultimap<String, ResourceLocation> categoriesForRecipeCatalystKeys = recipeCatalystBuilder.buildCategoriesForRecipeCatalystKeys();
        InternalRecipeManagerPlugin internalRecipeManagerPlugin = new InternalRecipeManagerPlugin(this, categoriesForRecipeCatalystKeys, ingredientManager, this.recipeCategoriesDataMap, this.recipeInputMap, this.recipeOutputMap);
        this.plugins.add(new RecipeManagerPluginSafeWrapper(internalRecipeManagerPlugin));
        for (IRecipeManagerPlugin plugin : plugins) {
            this.plugins.add(new RecipeManagerPluginSafeWrapper(plugin));
        }
        this.addRecipes(recipes);
    }

    private void addRecipes(ImmutableListMultimap<ResourceLocation, Object> recipes) {
        ImmutableSet recipeCategoryUids = recipes.keySet();
        for (ResourceLocation recipeCategoryUid : recipeCategoryUids) {
            LOGGER.debug("Loading recipes: " + recipeCategoryUid.toString());
            for (Object recipe : recipes.get((Object)recipeCategoryUid)) {
                this.addRecipeTyped(recipe, recipeCategoryUid);
            }
        }
    }

    private <T> void addRecipeTyped(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        this.addRecipe(recipe, recipeCategoryData);
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return new Focus<V>(mode, ingredient);
    }

    @Override
    @Deprecated
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        if (hiddenRecipes.contains(recipe)) {
            this.unhideRecipe(recipe, recipeCategoryUid);
        } else {
            this.addRecipe(recipe, recipeCategoryData);
        }
    }

    @Override
    @Nullable
    public IRecipeCategory getRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        RecipeCategoryData<?> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategoryUid);
        return recipeCategoryData.getRecipeCategory();
    }

    private <T> void addRecipe(T recipe, RecipeCategoryData<T> recipeCategoryData) {
        IRecipeCategory<T> recipeCategory = recipeCategoryData.getRecipeCategory();
        try {
            Ingredients ingredients = new Ingredients();
            recipeCategory.setIngredients(recipe, ingredients);
            this.recipeInputMap.addRecipe(recipe, recipeCategory, ingredients.getInputIngredients());
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, ingredients.getOutputIngredients());
            recipeCategoryData.getRecipes().add(recipe);
            this.unhideRecipe(recipe, recipeCategory.getUid());
            this.recipeCategoriesVisibleCache.clear();
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = ErrorUtil.getInfoFromRecipe(recipe, recipeCategory);
            LOGGER.error("Found a broken recipe: {}\n", (Object)recipeInfo, (Object)e);
        }
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories() {
        if (this.recipeCategoriesVisibleCache.isEmpty()) {
            for (IRecipeCategory recipeCategory : this.recipeCategories) {
                if (!this.isCategoryVisible(recipeCategory)) continue;
                this.recipeCategoriesVisibleCache.add(recipeCategory);
            }
        }
        return this.recipeCategoriesVisibleCache;
    }

    private boolean isCategoryVisible(IRecipeCategory<?> recipeCategory) {
        List<Object> visibleCatalysts;
        if (this.hiddenRecipeCategoryUids.contains(recipeCategory.getUid())) {
            return false;
        }
        List<Object> allCatalysts = this.getRecipeCatalysts(recipeCategory, true);
        if (!allCatalysts.isEmpty() && (visibleCatalysts = this.getRecipeCatalysts(recipeCategory, false)).isEmpty()) {
            return false;
        }
        return !this.getRecipes(recipeCategory).isEmpty();
    }

    @Override
    public List<IRecipeCategory> getRecipeCategories(List<ResourceLocation> recipeCategoryUids) {
        ErrorUtil.checkNotNull(recipeCategoryUids, "recipeCategoryUids");
        ArrayList<IRecipeCategory> categories = new ArrayList<IRecipeCategory>();
        for (ResourceLocation recipeCategoryUid : recipeCategoryUids) {
            RecipeCategoryData<?> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategoryUid);
            IRecipeCategory<?> recipeCategory = recipeCategoryData.getRecipeCategory();
            if (!this.getRecipeCategories().contains(recipeCategory)) continue;
            categories.add(recipeCategory);
        }
        Comparator<IRecipeCategory> comparator = Comparator.comparing(IRecipeCategory::getUid, this.recipeCategoryComparator);
        categories.sort(comparator);
        return Collections.unmodifiableList(categories);
    }

    @Override
    public <V> List<IRecipeCategory> getRecipeCategories(IFocus<V> focus) {
        focus = Focus.check(focus);
        ArrayList<ResourceLocation> allRecipeCategoryUids = new ArrayList<ResourceLocation>();
        for (IRecipeManagerPlugin iRecipeManagerPlugin : this.plugins) {
            List<ResourceLocation> recipeCategoryUids = iRecipeManagerPlugin.getRecipeCategoryUids(focus);
            for (ResourceLocation recipeCategoryUid : recipeCategoryUids) {
                if (allRecipeCategoryUids.contains(recipeCategoryUid)) continue;
                RecipeCategoryData<?> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategoryUid);
                Set<?> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
                if (!hiddenRecipes.isEmpty()) {
                    List recipes;
                    IRecipeCategory recipeCategory = this.getRecipeCategory(recipeCategoryUid);
                    if (recipeCategory == null || (recipes = this.getRecipes(recipeCategory, focus)).isEmpty()) continue;
                    allRecipeCategoryUids.add(recipeCategoryUid);
                    continue;
                }
                allRecipeCategoryUids.add(recipeCategoryUid);
            }
        }
        return this.getRecipeCategories(allRecipeCategoryUids);
    }

    @Override
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        focus = Focus.check(focus);
        ArrayList<T> allRecipes = new ArrayList<T>();
        for (IRecipeManagerPlugin iRecipeManagerPlugin : this.plugins) {
            List<T> recipes = iRecipeManagerPlugin.getRecipes(recipeCategory, focus);
            allRecipes.addAll(recipes);
        }
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
        Set<T> set = recipeCategoryData.getHiddenRecipes();
        allRecipes.removeAll(set);
        return allRecipes;
    }

    @Override
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ArrayList<T> allRecipes = new ArrayList<T>();
        for (IRecipeManagerPlugin iRecipeManagerPlugin : this.plugins) {
            List<T> recipes = iRecipeManagerPlugin.getRecipes(recipeCategory);
            allRecipes.addAll(recipes);
        }
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
        Set<T> set = recipeCategoryData.getHiddenRecipes();
        allRecipes.removeAll(set);
        return allRecipes;
    }

    private <T> List<Object> getRecipeCatalysts(IRecipeCategory<T> recipeCategory, boolean includeHidden) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategory);
        ImmutableList<Object> catalysts = recipeCategoryData.getRecipeCatalysts();
        if (includeHidden) {
            return catalysts;
        }
        ArrayList<Object> visibleCatalysts = new ArrayList<Object>();
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        for (Object catalyst : catalysts) {
            if (!this.ingredientManager.isIngredientVisible(catalyst, ingredientFilter)) continue;
            visibleCatalysts.add(catalyst);
        }
        return visibleCatalysts;
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory) {
        return this.getRecipeCatalysts(recipeCategory, false);
    }

    @Override
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocus<?> focus) {
        Focus<?> checkedFocus = Focus.check(focus);
        RecipeLayout recipeLayout = RecipeLayout.create(-1, recipeCategory, recipe, checkedFocus, 0, 0);
        Preconditions.checkNotNull((Object)recipeLayout, (Object)"Recipe layout crashed during creation, see log.");
        return recipeLayout;
    }

    @Override
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.add(recipe);
        this.recipeCategoriesVisibleCache.clear();
    }

    @Override
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        RecipeCategoryData<T> recipeCategoryData = this.recipeCategoriesDataMap.get(recipe, recipeCategoryUid);
        Set<T> hiddenRecipes = recipeCategoryData.getHiddenRecipes();
        hiddenRecipes.remove(recipe);
        this.recipeCategoriesVisibleCache.clear();
    }

    @Override
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        RecipeCategoryData<?> recipeCategoryData = this.recipeCategoriesDataMap.get(recipeCategoryUid);
        IRecipeCategory<?> recipeCategory = recipeCategoryData.getRecipeCategory();
        this.hiddenRecipeCategoryUids.add(recipeCategoryUid);
        this.recipeCategoriesVisibleCache.remove(recipeCategory);
    }

    @Override
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        ErrorUtil.assertMainThread();
        this.recipeCategoriesDataMap.validate(recipeCategoryUid);
        this.hiddenRecipeCategoryUids.remove(recipeCategoryUid);
        this.recipeCategoriesVisibleCache.clear();
    }
}

