/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class FermenterRecipe
extends MultiblockRecipe {
    public static IRecipeType<FermenterRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:fermenter");
    public static RegistryObject<IERecipeSerializer<FermenterRecipe>> SERIALIZER;
    public IngredientWithSize input;
    public final FluidStack fluidOutput;
    @Nonnull
    public final ItemStack itemOutput;
    public static Map<ResourceLocation, FermenterRecipe> recipeList;

    public FermenterRecipe(ResourceLocation id, FluidStack fluidOutput, @Nonnull ItemStack itemOutput, IngredientWithSize input, int energy) {
        super(itemOutput, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.input = input;
        this.totalProcessEnergy = energy;
        this.totalProcessTime = 80;
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = ListUtils.fromItem(this.itemOutput);
    }

    @Override
    protected IERecipeSerializer<FermenterRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public FermenterRecipe setInputSize(int size) {
        this.input = this.input.withSize(size);
        return this;
    }

    public static FermenterRecipe findRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        for (FermenterRecipe recipe : recipeList.values()) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    public static SortedMap<String, Integer> getFluidValuesSorted(Fluid f, boolean inverse) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>(inverse ? Comparator.reverseOrder() : Comparator.reverseOrder());
        for (FermenterRecipe recipe : recipeList.values()) {
            if (recipe.fluidOutput == null || recipe.fluidOutput.getFluid() != f || recipe.input.hasNoMatchingItems()) continue;
            ItemStack is = recipe.input.getMatchingStacks()[0];
            map.put(is.func_200301_q().func_150254_d(), recipe.fluidOutput.getAmount());
        }
        return map;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

