/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class DieselHandler {
    static final List<Pair<Tag<Fluid>, Integer>> dieselGenBurnTime = new ArrayList<Pair<Tag<Fluid>, Integer>>();
    static final Set<Tag<Fluid>> drillFuel = new HashSet<Tag<Fluid>>();

    public static void registerFuel(Tag<Fluid> fuel, int time) {
        if (fuel != null) {
            dieselGenBurnTime.add((Pair<Tag<Fluid>, Integer>)Pair.of(fuel, (Object)time));
        }
    }

    public static int getBurnTime(Fluid fuel) {
        if (fuel != null) {
            ResourceLocation s = fuel.getRegistryName();
            for (Map.Entry entry : dieselGenBurnTime) {
                if (!((Tag)entry.getKey()).func_199685_a_((Object)fuel)) continue;
                return (Integer)entry.getValue();
            }
        }
        return 0;
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return dieselGenBurnTime.stream().anyMatch(pair -> ((Tag)pair.getLeft()).func_199685_a_((Object)fuel));
        }
        return false;
    }

    public static List<Pair<Tag<Fluid>, Integer>> getFuelValues() {
        return dieselGenBurnTime;
    }

    public static void registerDrillFuel(Tag<Fluid> fuel) {
        if (fuel != null) {
            drillFuel.add(fuel);
        }
    }

    public static boolean isValidDrillFuel(Fluid fuel) {
        return fuel != null && drillFuel.stream().anyMatch(fluidTag -> fluidTag.func_199685_a_((Object)fuel));
    }
}

