/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;

public class ThermoelectricHandler {
    public static List<ThermoelectricSource> temperatureMap = new ArrayList<ThermoelectricSource>();

    public static void registerSourceInKelvin(ThermoelectricSource source) {
        temperatureMap.add(source);
    }

    public static void registerSourceInKelvin(Block b, int value) {
        temperatureMap.add(new ThermoelectricSource(b, value, TemperatureScale.KELVIN));
    }

    public static void registerSourceInKelvin(Tag<Block> tag, int value) {
        temperatureMap.add(new ThermoelectricSource(tag, value, TemperatureScale.KELVIN));
    }

    public static void registerSourceInCelsius(Tag<Block> tag, int value) {
        temperatureMap.add(new ThermoelectricSource(tag, value, TemperatureScale.CELSIUS));
    }

    public static int getTemperature(Block block) {
        for (ThermoelectricSource entry : temperatureMap) {
            if (!entry.matches.test(block)) continue;
            return entry.temperature;
        }
        return -1;
    }

    public static SortedMap<String, Integer> getThermalValuesSorted(boolean inverse) {
        TreeMap<String, Integer> existingMap = new TreeMap<String, Integer>(inverse ? Comparator.reverseOrder() : Comparator.reverseOrder());
        for (ThermoelectricSource ingr : temperatureMap) {
            Optional<Block> exampleOpt = ingr.getExample.get();
            exampleOpt.ifPresent(example -> existingMap.put(new ItemStack((IItemProvider)example).func_200301_q().func_150254_d(), ingr.temperature));
        }
        return existingMap;
    }

    public static enum TemperatureScale {
        KELVIN(s -> s),
        CELSIUS(s -> s + 273),
        FAHRENHEIT(value -> (int)Math.round((double)(value - 32) / 1.8 + 273.0));

        public final Int2IntFunction convertToKelvin;

        private TemperatureScale(Int2IntFunction convertToKelvin) {
            this.convertToKelvin = convertToKelvin;
        }
    }

    public static class ThermoelectricSource {
        public final Predicate<Block> matches;
        public final int temperature;
        public final Supplier<Optional<Block>> getExample;

        public ThermoelectricSource(Block b, int temperature, TemperatureScale s) {
            this(b2 -> b2 == b, temperature, () -> Optional.of(b), s);
        }

        public ThermoelectricSource(Tag<Block> tag, int temperature, TemperatureScale scale) {
            this(b -> b.func_203417_a(tag), temperature, () -> {
                Collection allMatching = tag.func_199885_a();
                return allMatching.stream().findAny();
            }, scale);
        }

        public ThermoelectricSource(Predicate<Block> matches, int temperature, Supplier<Optional<Block>> getExample, TemperatureScale s) {
            this.matches = matches;
            this.temperature = s.convertToKelvin.applyAsInt(temperature);
            this.getExample = getExample;
        }
    }
}

