/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AssemblerHandler {
    private static final HashMap<Class<? extends IRecipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends IRecipe>, IRecipeAdapter>();
    private static final List<Function<Object, RecipeQuery>> specialQueryConverters = new ArrayList<Function<Object, RecipeQuery>>();
    private static final List<Function<Ingredient, RecipeQuery>> specialIngredientConverters = new ArrayList<Function<Ingredient, RecipeQuery>>();
    private static final List<Function<ItemStack, RecipeQuery>> specialItemStackConverters = new ArrayList<Function<ItemStack, RecipeQuery>>();
    public static final IRecipeAdapter<IRecipe<CraftingInventory>> defaultAdapter = new IRecipeAdapter<IRecipe<CraftingInventory>>(){

        @Override
        public RecipeQuery[] getQueriedInputs(IRecipe<CraftingInventory> recipe, NonNullList<ItemStack> input, World world) {
            NonNullList ingred = recipe.func_192400_c();
            NonNullList ingredientsForMatching = NonNullList.func_191196_a();
            List inputList = input.subList(0, input.size() - 1);
            for (Ingredient i : ingred) {
                if (i.func_203189_d()) continue;
                ingredientsForMatching.add((Object)i);
            }
            int numNonEmpty = ingredientsForMatching.size();
            while (ingredientsForMatching.size() < inputList.size()) {
                ingredientsForMatching.add(ItemStack::func_190926_b);
            }
            ForgeHooks.setCraftingPlayer((PlayerEntity)FakePlayerUtil.getFakePlayer(world));
            int[] ingredientAssignment = RecipeMatcher.findMatches((List)inputList, (List)ingredientsForMatching);
            ForgeHooks.setCraftingPlayer(null);
            RecipeQuery[] query = new RecipeQuery[input.size() - 1];
            if (ingredientAssignment != null) {
                for (int stackIndex = 0; stackIndex < ingredientAssignment.length; ++stackIndex) {
                    int ingredIndex = ingredientAssignment[stackIndex];
                    if (ingredIndex >= numNonEmpty) continue;
                    query[stackIndex] = AssemblerHandler.createQueryFromIngredient((Ingredient)ingredientsForMatching.get(ingredIndex));
                }
            } else {
                for (int i = 0; i < query.length; ++i) {
                    if (((ItemStack)input.get(i)).func_190926_b()) continue;
                    query[i] = AssemblerHandler.createQueryFromItemStack((ItemStack)input.get(i));
                }
            }
            return query;
        }
    };

    public static void registerRecipeAdapter(Class<? extends IRecipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    @Nonnull
    public static IRecipeAdapter<?> findAdapterForClass(Class<? extends IRecipe> recipeClass) {
        IRecipeAdapter<Object> adapter = registry.get(recipeClass);
        boolean isSuperIRecipe = IRecipe.class.isAssignableFrom(recipeClass.getSuperclass());
        adapter = adapter == null && recipeClass != IRecipe.class && isSuperIRecipe ? AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass()) : defaultAdapter;
        registry.put(recipeClass, adapter);
        return adapter;
    }

    @Nonnull
    public static IRecipeAdapter<?> findAdapter(IRecipe recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    @Deprecated
    public static void registerSpecialQueryConverters(Function<Object, RecipeQuery> func) {
        specialQueryConverters.add(func);
    }

    public static void registerSpecialIngredientConverter(Function<Ingredient, RecipeQuery> func) {
        specialIngredientConverters.add(func);
    }

    public static void registerSpecialItemStackConverter(Function<ItemStack, RecipeQuery> func) {
        specialItemStackConverters.add(func);
    }

    @Deprecated
    @Nullable
    public static RecipeQuery createQuery(Object o) {
        if (o == null) {
            return null;
        }
        RecipeQuery special = AssemblerHandler.fromFunctions(o, specialQueryConverters);
        if (special != null) {
            return special;
        }
        if (o instanceof ItemStack) {
            return AssemblerHandler.createQueryFromItemStack((ItemStack)o);
        }
        if (o instanceof Ingredient) {
            AssemblerHandler.createQueryFromIngredient((Ingredient)o);
        }
        return RecipeQuery.create(o, 1);
    }

    private static <T> RecipeQuery fromFunctions(T in, List<Function<T, RecipeQuery>> converters) {
        for (Function<T, RecipeQuery> func : converters) {
            RecipeQuery q = func.apply(in);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    @Nullable
    public static RecipeQuery createQueryFromIngredient(Ingredient ingr) {
        RecipeQuery special = AssemblerHandler.fromFunctions(ingr, specialIngredientConverters);
        if (special == null) {
            special = AssemblerHandler.fromFunctions(ingr, specialQueryConverters);
        }
        if (special != null) {
            return special;
        }
        if (ingr.func_203189_d()) {
            return null;
        }
        return RecipeQuery.create(ingr, 1);
    }

    @Nullable
    public static RecipeQuery createQueryFromItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        RecipeQuery special = AssemblerHandler.fromFunctions(stack, specialItemStackConverters);
        if (special == null) {
            special = AssemblerHandler.fromFunctions(stack, specialQueryConverters);
        }
        if (special != null) {
            return special;
        }
        FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            return RecipeQuery.create(fluidStack, stack.func_190916_E());
        }
        return RecipeQuery.create(stack, stack.func_190916_E());
    }

    static {
        AssemblerHandler.registerRecipeAdapter(IRecipe.class, defaultAdapter);
    }

    public static class RecipeQuery {
        @Deprecated
        @Nonnull
        public Object query;
        public int querySize;

        @Deprecated
        public RecipeQuery(@Nonnull Object query, int querySize) {
            Preconditions.checkArgument((query instanceof ItemStack || query instanceof ItemStack[] || query instanceof List || query instanceof IngredientWithSize || query instanceof Ingredient || query instanceof ResourceLocation || query instanceof FluidStack || query instanceof FluidTagInput ? 1 : 0) != 0, (Object)(query + " is not a valid ingredient!"));
            this.query = query;
            this.querySize = querySize;
        }

        public static RecipeQuery create(@Nonnull Object query, int size) {
            return new RecipeQuery(query, size);
        }

        public boolean matchesIgnoringSize(ItemStack stack) {
            return ItemUtils.stackMatchesObject(stack, this.query, true);
        }

        public boolean matchesFluid(FluidStack fluid) {
            if (this.query instanceof FluidStack) {
                return fluid.containsFluid((FluidStack)this.query);
            }
            if (this.query instanceof FluidTagInput) {
                return ((FluidTagInput)this.query).test(fluid);
            }
            return false;
        }

        public int getFluidSize() {
            if (this.query instanceof FluidStack) {
                return ((FluidStack)this.query).getAmount();
            }
            if (this.query instanceof FluidTagInput) {
                return ((FluidTagInput)this.query).getAmount();
            }
            throw new UnsupportedOperationException("Query " + this.query + " (class " + this.query.getClass() + ") is not a fluid query");
        }

        public boolean isFluid() {
            return this.query instanceof FluidStack || this.query instanceof FluidTagInput;
        }
    }

    public static interface IRecipeAdapter<R extends IRecipe<CraftingInventory>> {
        @Nullable
        @Deprecated
        default public RecipeQuery[] getQueriedInputs(R recipe, World world) {
            return this.getQueriedInputs(recipe, (NonNullList<ItemStack>)NonNullList.func_191196_a(), world);
        }

        @Nullable
        default public RecipeQuery[] getQueriedInputs(R recipe, NonNullList<ItemStack> input, World world) {
            return this.getQueriedInputs(recipe, world);
        }
    }
}

