/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class WireCollisionData {
    private final Multimap<BlockPos, CollisionInfo> blockToWires = HashMultimap.create();
    private final GlobalWireNetwork net;
    private final boolean isRemote;

    WireCollisionData(GlobalWireNetwork net, boolean isRemote) {
        this.net = net;
        this.isRemote = isRemote;
    }

    public void addConnection(Connection conn) {
        if (!this.isRemote && !conn.isInternal()) {
            WireLogger.logger.info("Adding block data for {}", (Object)conn);
            if (!conn.blockDataGenerated) {
                WireLogger.logger.info("Raytracing for addition of {}", (Object)conn);
                if (this.net.getLocalNet(conn.getEndA()) != this.net.getLocalNet(conn.getEndB())) {
                    throw new AssertionError();
                }
                ApiUtils.raytraceAlongCatenary(conn, this.net.getLocalNet(conn.getEndA()), p -> this.blockToWires.put(p.getLeft(), (Object)new CollisionInfo((Vec3d)p.getMiddle(), (Vec3d)p.getRight(), conn, true)), p -> this.blockToWires.put(p.getLeft(), (Object)new CollisionInfo((Vec3d)p.getMiddle(), (Vec3d)p.getRight(), conn, false)));
                conn.blockDataGenerated = true;
            }
        }
    }

    public void removeConnection(Connection conn) {
        WireLogger.logger.info("Removing block data for {}", (Object)conn);
        if (!this.isRemote && conn.blockDataGenerated) {
            WireLogger.logger.info("Raytracing for removal of {}", (Object)conn);
            ApiUtils.raytraceAlongCatenary(conn.getCatenaryData(), conn.getEndA().getPosition(), p -> this.blockToWires.get(p.getLeft()).removeIf(filter -> filter.conn == conn), p -> this.blockToWires.get(p.getLeft()).removeIf(filter -> filter.conn == conn));
            conn.blockDataGenerated = false;
        }
    }

    @Nonnull
    public Collection<CollisionInfo> getCollisionInfo(BlockPos pos) {
        Collection ret = (Collection)this.blockToWires.asMap().get(pos);
        if (ret == null) {
            ret = ImmutableList.of();
        }
        return ret;
    }

    public class CollisionInfo {
        @Nonnull
        public final Vec3d intersectA;
        @Nonnull
        public final Vec3d intersectB;
        @Nonnull
        public final Connection conn;
        public final boolean isInBlock;
        private LocalWireNetwork cachedLocalNet;

        public CollisionInfo(@Nonnull Vec3d intersectA, @Nonnull Vec3d intersectB, Connection conn, boolean isInBlock) {
            this.intersectA = intersectA;
            this.intersectB = intersectB;
            this.conn = conn;
            this.isInBlock = isInBlock;
        }

        public LocalWireNetwork getLocalNet() {
            if (this.cachedLocalNet == null || !this.cachedLocalNet.isValid(this.conn.getEndA())) {
                this.cachedLocalNet = WireCollisionData.this.net.getLocalNet(this.conn.getEndA());
            }
            return this.cachedLocalNet;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollisionInfo that = (CollisionInfo)o;
            if (this.isInBlock != that.isInBlock) {
                return false;
            }
            if (!this.intersectA.equals((Object)that.intersectA)) {
                return false;
            }
            if (!this.intersectB.equals((Object)that.intersectB)) {
                return false;
            }
            return this.conn.equals(that.conn);
        }

        public int hashCode() {
            int result = this.intersectA.hashCode();
            result = 31 * result + this.intersectB.hashCode();
            result = 31 * result + this.conn.hashCode();
            result = 31 * result + (this.isInBlock ? 1 : 0);
            return result;
        }
    }
}

