/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.DrawHighlightEvent;

public class BlockOverlayUtils {
    private static final float[][] quarterRotationArrowCoords = new float[][]{{0.375f, 0.0f}, {0.5f, -0.125f}, {0.4375f, -0.125f}, {0.4375f, -0.25f}, {0.25f, -0.4375f}, {0.0f, -0.4375f}, {0.0f, -0.3125f}, {0.1875f, -0.3125f}, {0.3125f, -0.1875f}, {0.3125f, -0.125f}, {0.25f, -0.125f}};
    private static final float[][] quarterRotationArrowQuads = new float[][]{quarterRotationArrowCoords[5], quarterRotationArrowCoords[6], quarterRotationArrowCoords[4], quarterRotationArrowCoords[7], quarterRotationArrowCoords[3], quarterRotationArrowCoords[8], quarterRotationArrowCoords[2], quarterRotationArrowCoords[9], quarterRotationArrowCoords[1], quarterRotationArrowCoords[10], quarterRotationArrowCoords[0], quarterRotationArrowCoords[0]};
    private static final float[][] halfRotationArrowCoords = new float[][]{{0.375f, 0.0f}, {0.5f, -0.125f}, {0.4375f, -0.125f}, {0.4375f, -0.25f}, {0.25f, -0.4375f}, {-0.25f, -0.4375f}, {-0.4375f, -0.25f}, {-0.4375f, -0.0625f}, {-0.3125f, -0.0625f}, {-0.3125f, -0.1875f}, {-0.1875f, -0.3125f}, {0.1875f, -0.3125f}, {0.3125f, -0.1875f}, {0.3125f, -0.125f}, {0.25f, -0.125f}};
    private static final float[][] halfRotationArrowQuads = new float[][]{halfRotationArrowCoords[7], halfRotationArrowCoords[8], halfRotationArrowCoords[6], halfRotationArrowCoords[9], halfRotationArrowCoords[5], halfRotationArrowCoords[10], halfRotationArrowCoords[4], halfRotationArrowCoords[11], halfRotationArrowCoords[3], halfRotationArrowCoords[12], halfRotationArrowCoords[2], halfRotationArrowCoords[13], halfRotationArrowCoords[1], halfRotationArrowCoords[14], halfRotationArrowCoords[0], halfRotationArrowCoords[0]};
    private static final float[][] arrowCoords = new float[][]{{0.0f, 0.375f}, {0.3125f, 0.0625f}, {0.125f, 0.0625f}, {0.125f, -0.375f}, {-0.125f, -0.375f}, {-0.125f, 0.0625f}, {-0.3125f, 0.0625f}};

    public static void drawBlockOverlayText(MatrixStack transform, String[] text, int scaledWidth, int scaledHeight) {
        if (text != null && text.length > 0) {
            int i = 0;
            IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            for (String s : text) {
                if (s == null) continue;
                FontRenderer fontRenderer = ClientUtils.font();
                float f = scaledWidth / 2 + 8;
                int n = scaledHeight / 2 + 8;
                int n2 = i++;
                ClientUtils.font().getClass();
                fontRenderer.func_228079_a_(s, f, (float)(n + n2 * 9), -1, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
            }
            buffer.func_228461_a_();
        }
    }

    public static void drawCircularRotationArrows(IRenderTypeBuffer buffer, MatrixStack transform, float rotation, boolean flip, boolean halfCircle) {
        int i;
        Matrix4f mat;
        int arrowId;
        int[] vertexOrder;
        float[][] rotationArrowQuads;
        float[][] rotationArrowCoords;
        transform.func_227860_a_();
        transform.func_227861_a_(0.0, 0.502, 0.0);
        if (halfCircle) {
            rotationArrowCoords = halfRotationArrowCoords;
            rotationArrowQuads = halfRotationArrowQuads;
        } else {
            rotationArrowCoords = quarterRotationArrowCoords;
            rotationArrowQuads = quarterRotationArrowQuads;
        }
        if (flip) {
            transform.func_227863_a_(new Quaternion(0.0f, -rotation, 0.0f, false));
            transform.func_227862_a_(1.0f, 1.0f, -1.0f);
            vertexOrder = new int[]{2, 3, 1, 0};
        } else {
            transform.func_227863_a_(new Quaternion(0.0f, rotation, 0.0f, false));
            vertexOrder = new int[]{0, 1, 3, 2};
        }
        transform.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(IERenderTypes.LINES);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.func_227866_c_().func_227870_a_();
            for (i = 0; i <= rotationArrowCoords.length; ++i) {
                float[] p = rotationArrowCoords[i % rotationArrowCoords.length];
                if (i > 0) {
                    builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                }
                if (i == rotationArrowCoords.length) continue;
                builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
            }
            transform.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        }
        transform.func_227865_b_();
        transform.func_227860_a_();
        builder = buffer.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        for (arrowId = 0; arrowId < 2; ++arrowId) {
            mat = transform.func_227866_c_().func_227870_a_();
            i = 0;
            while (i + 3 < rotationArrowQuads.length) {
                for (int offset : vertexOrder) {
                    float[] p = rotationArrowQuads[i + offset];
                    builder.func_227888_a_(mat, p[0], 0.0f, p[1]).func_227885_a_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).func_181675_d();
                }
                i += 2;
            }
            transform.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        }
        transform.func_227865_b_();
        transform.func_227865_b_();
    }

    public static void drawBlockOverlayArrow(Matrix4f transform, IRenderTypeBuffer buffers, Vec3d directionVec, Direction side, AxisAlignedBB targetedBB) {
        Vec3d[] translatedPositions = new Vec3d[arrowCoords.length];
        Matrix4 mat = new Matrix4();
        Vec3d defaultDir = side.func_176740_k() == Direction.Axis.Y ? new Vec3d(0.0, 0.0, 1.0) : new Vec3d(0.0, 1.0, 0.0);
        directionVec = directionVec.func_72432_b();
        double angle = Math.acos(defaultDir.func_72430_b(directionVec));
        Vec3d axis = defaultDir.func_72431_c(directionVec);
        mat.rotate(angle, axis.field_72450_a, axis.field_72448_b, axis.field_72449_c);
        if (side.func_176740_k() == Direction.Axis.Z) {
            mat.rotate(1.5707963267948966, 1.0, 0.0, 0.0).rotate(Math.PI, 0.0, 1.0, 0.0);
        } else if (side.func_176740_k() == Direction.Axis.X) {
            mat.rotate(1.5707963267948966, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 0.0, 1.0, 0.0);
        }
        for (int i = 0; i < translatedPositions.length; ++i) {
            Vec3d vec = mat.apply(new Vec3d((double)arrowCoords[i][0], 0.0, (double)arrowCoords[i][1])).func_72441_c(0.5, 0.5, 0.5);
            if (targetedBB != null) {
                vec = new Vec3d(side == Direction.WEST ? targetedBB.field_72340_a - 0.002 : (side == Direction.EAST ? targetedBB.field_72336_d + 0.002 : vec.field_72450_a), side == Direction.DOWN ? targetedBB.field_72338_b - 0.002 : (side == Direction.UP ? targetedBB.field_72337_e + 0.002 : vec.field_72448_b), side == Direction.NORTH ? targetedBB.field_72339_c - 0.002 : (side == Direction.SOUTH ? targetedBB.field_72334_f + 0.002 : vec.field_72449_c));
            }
            translatedPositions[i] = vec;
        }
        IVertexBuilder triBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_TRIANGLES);
        Vec3d center = translatedPositions[0];
        for (int i = 2; i < translatedPositions.length; ++i) {
            Vec3d point = translatedPositions[i];
            Vec3d prevPoint = translatedPositions[i - 1];
            for (Vec3d p : new Vec3d[]{center, prevPoint, point}) {
                triBuilder.func_227888_a_(transform, (float)p.field_72450_a, (float)p.field_72448_b, (float)p.field_72449_c).func_227885_a_(Lib.COLOUR_F_ImmersiveOrange[0], Lib.COLOUR_F_ImmersiveOrange[1], Lib.COLOUR_F_ImmersiveOrange[2], 0.4f).func_181675_d();
            }
        }
        IVertexBuilder lineBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_LINES);
        for (int i = 0; i <= translatedPositions.length; ++i) {
            Vec3d point = translatedPositions[i % translatedPositions.length];
            int max = i == 0 || i == translatedPositions.length ? 1 : 2;
            for (int j = 0; j < max; ++j) {
                lineBuilder.func_227888_a_(transform, (float)point.field_72450_a, (float)point.field_72448_b, (float)point.field_72449_c).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
            }
        }
    }

    public static void drawAdditionalBlockbreak(DrawHighlightEvent ev, PlayerEntity player, float partialTicks, Collection<BlockPos> blocks) {
        Vec3d renderView = ev.getInfo().func_216785_c();
        for (BlockPos pos : blocks) {
            ev.getContext().func_228429_a_(ev.getMatrix(), ev.getBuffers().getBuffer(RenderType.func_228659_m_()), (Entity)player, renderView.field_72450_a, renderView.field_72448_b, renderView.field_72449_c, pos, ClientUtils.mc().field_71441_e.func_180495_p(pos));
        }
        MatrixStack transform = ev.getMatrix();
        transform.func_227860_a_();
        transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
        PlayerController controllerMP = ClientUtils.mc().field_71442_b;
        if (controllerMP.field_78778_j) {
            ClientUtils.drawBlockDamageTexture(transform, ev.getBuffers(), (Entity)player, partialTicks, player.field_70170_p, blocks);
        }
        transform.func_227865_b_();
    }

    public static void renderOreveinMapOverlays(ItemFrameEntity frameEntity, RayTraceResult rayTraceResult, int scaledWidth, int scaledHeight) {
        World world;
        MapData mapData;
        ItemStack frameItem;
        if (frameEntity != null && (frameItem = frameEntity.func_82335_i()).func_77973_b() == Items.field_151098_aY && ItemNBTHelper.hasKey(frameItem, "Decorations", 9) && (mapData = FilledMapItem.func_195950_a((ItemStack)frameItem, (World)(world = frameEntity.func_130014_f_()))) != null) {
            FontRenderer font = ClientUtils.font();
            mapData.func_176054_a((double)world.func_72912_H().func_76079_c(), (double)world.func_72912_H().func_76074_e(), (int)mapData.field_76197_d);
            int mapScale = 1 << mapData.field_76197_d;
            float mapRotation = (float)(frameEntity.func_82333_j() % 4) * 1.5708f;
            Vec3d hitVec = rayTraceResult.func_216347_e().func_178788_d(new Vec3d((Vec3i)frameEntity.func_174857_n()));
            Direction frameDir = frameEntity.func_174811_aO();
            double cursorH = 0.0;
            double cursorV = 0.0;
            switch (frameDir) {
                case DOWN: {
                    cursorH = hitVec.field_72450_a;
                    cursorV = 1.0 - hitVec.field_72449_c;
                    break;
                }
                case UP: {
                    cursorH = hitVec.field_72450_a;
                    cursorV = hitVec.field_72449_c;
                    break;
                }
                case NORTH: {
                    cursorH = 1.0 - hitVec.field_72450_a;
                    cursorV = 1.0 - hitVec.field_72448_b;
                    break;
                }
                case SOUTH: {
                    cursorH = hitVec.field_72450_a;
                    cursorV = 1.0 - hitVec.field_72448_b;
                    break;
                }
                case WEST: {
                    cursorH = hitVec.field_72449_c;
                    cursorV = 1.0 - hitVec.field_72448_b;
                    break;
                }
                case EAST: {
                    cursorH = 1.0 - hitVec.field_72449_c;
                    cursorV = 1.0 - hitVec.field_72448_b;
                }
            }
            cursorH *= 128.0;
            cursorV *= 128.0;
            ListNBT minerals = null;
            double lastDist = Double.MAX_VALUE;
            ListNBT nbttaglist = frameItem.func_77978_p().func_150295_c("Decorations", 10);
            for (INBT inbt : nbttaglist) {
                CompoundNBT tagCompound = (CompoundNBT)inbt;
                String id = tagCompound.func_74779_i("id");
                if (!id.startsWith("ie:coresample_") || !tagCompound.func_74764_b("minerals")) continue;
                double sampleX = tagCompound.func_74769_h("x");
                double sampleZ = tagCompound.func_74769_h("z");
                float f = (float)(sampleX - (double)mapData.field_76201_a) / (float)mapScale;
                float f1 = (float)(sampleZ - (double)mapData.field_76199_b) / (float)mapScale;
                byte b0 = (byte)((double)(f * 2.0f) + 0.5);
                byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
                Vec3d mapPos = new Vec3d(0.0, (double)b1, (double)b0);
                mapPos = mapPos.func_178789_a(mapRotation);
                double offsetH = mapPos.field_72449_c / 2.0 + 64.0;
                double dH = cursorH - offsetH;
                double offsetV = mapPos.field_72448_b / 2.0 + 64.0;
                double dV = cursorV - offsetV;
                double dist = dH * dH + dV * dV;
                if (!(dist < 10.0) || !(dist < lastDist)) continue;
                lastDist = dist;
                minerals = tagCompound.func_150295_c("minerals", 8);
            }
            if (minerals != null) {
                for (int i = 0; i < minerals.size(); ++i) {
                    MineralMix mix = MineralMix.mineralList.get(new ResourceLocation(minerals.func_150307_f(i)));
                    if (mix == null) continue;
                    String string = I18n.func_135052_a((String)mix.getTranslationKey(), (Object[])new Object[0]);
                    float f = scaledWidth / 2 + 8;
                    int n = scaledHeight / 2 + 8;
                    font.getClass();
                    font.func_175063_a(string, f, (float)(n + i * 9), 0xFFFFFF);
                }
            }
        }
    }
}

