/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.client.BlockOverlayUtils;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.ItemOverlayUtils;
import blusunrize.immersiveengineering.client.fx.FractalParticle;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.render.tile.AutoWorkbenchRenderer;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableTileEntity;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.RailgunItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledSound;
import blusunrize.immersiveengineering.common.util.sound.IEMuffledTickableSound;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.lang3.tuple.Pair;

public class ClientEventHandler
implements ISelectiveResourceReloadListener {
    private boolean shieldToggleButton = false;
    private int shieldToggleTimer = 0;
    private static final String[] BULLET_TOOLTIP = new String[]{"  IE ", "  AMMO ", "  HERE ", "  -- "};
    public static final Map<Connection, Pair<Collection<BlockPos>, AtomicInteger>> FAILED_CONNECTIONS = new HashMap<Connection, Pair<Collection<BlockPos>, AtomicInteger>>();

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            ImmersiveEngineering.proxy.clearRenderCaches();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.player != null && event.player == ClientUtils.mc().func_175606_aa() && event.phase == TickEvent.Phase.END) {
            ItemStack held;
            if (this.shieldToggleTimer > 0) {
                --this.shieldToggleTimer;
            }
            if (ClientProxy.keybind_magnetEquip.func_151470_d() && !this.shieldToggleButton) {
                if (this.shieldToggleTimer <= 0) {
                    this.shieldToggleTimer = 7;
                } else {
                    PlayerEntity player = event.player;
                    ItemStack held2 = player.func_184586_b(Hand.OFF_HAND);
                    if (!held2.func_190926_b() && held2.func_77973_b() instanceof IEShieldItem) {
                        if (((IEShieldItem)held2.func_77973_b()).getUpgrades(held2).func_74767_n("magnet") && ((IEShieldItem)held2.func_77973_b()).getUpgrades(held2).func_74764_b("prevSlot")) {
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageMagnetEquip(-1));
                        }
                    } else {
                        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack s = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                            if (s.func_190926_b() || !(s.func_77973_b() instanceof IEShieldItem) || !((IEShieldItem)s.func_77973_b()).getUpgrades(s).func_74767_n("magnet")) continue;
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageMagnetEquip(i));
                        }
                    }
                }
            }
            if (this.shieldToggleButton != ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d()) {
                this.shieldToggleButton = ClientUtils.mc().field_71474_y.field_74368_y.func_151470_d();
            }
            if (!ClientProxy.keybind_chemthrowerSwitch.func_197986_j() && ClientProxy.keybind_chemthrowerSwitch.func_151468_f() && (held = event.player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof IEItemInterfaces.IScrollwheel) {
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageScrollwheelItem(true));
            }
            if (!ClientProxy.keybind_railgunZoom.func_197986_j() && ClientProxy.keybind_railgunZoom.func_151468_f()) {
                for (Hand hand : Hand.values()) {
                    float[] steps;
                    ItemStack held3 = event.player.func_184586_b(hand);
                    if (!(held3.func_77973_b() instanceof ZoomHandler.IZoomTool) || !((ZoomHandler.IZoomTool)held3.func_77973_b()).canZoom(held3, event.player)) continue;
                    boolean bl = ZoomHandler.isZooming = !ZoomHandler.isZooming;
                    if (!ZoomHandler.isZooming || (steps = ((ZoomHandler.IZoomTool)held3.func_77973_b()).getZoomSteps(held3, event.player)) == null || steps.length <= 0) continue;
                    ZoomHandler.fovZoom = steps[ZoomHandler.getCurrentZoomStep(steps)];
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        FAILED_CONNECTIONS.entrySet().removeIf(entry -> ((AtomicInteger)((Pair)entry.getValue()).getValue()).decrementAndGet() <= 0);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack powerpack;
        ItemStack earmuffs;
        event.getItemStack();
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        event.getItemStack().getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
            ItemStack shader = wrapper.getShaderItem();
            if (!shader.func_190926_b()) {
                event.getToolTip().add(shader.func_200301_q().func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)));
            }
        });
        Style gray = new Style().func_150238_a(TextFormatting.GRAY);
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Earmuffs") && !(earmuffs = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Earmuffs")).func_190926_b()) {
            event.getToolTip().add(earmuffs.func_200301_q().func_150255_a(gray));
        }
        if (ItemNBTHelper.hasKey(event.getItemStack(), "IE:Powerpack") && !(powerpack = ItemNBTHelper.getItemStack(event.getItemStack(), "IE:Powerpack")).func_190926_b()) {
            event.getToolTip().add(powerpack.func_200301_q().func_150255_a(gray));
            event.getToolTip().add(new StringTextComponent(EnergyHelper.getEnergyStored((ICapabilityProvider)powerpack) + "/" + EnergyHelper.getMaxEnergyStored((ICapabilityProvider)powerpack) + " IF").func_150255_a(gray));
        }
        if (ClientUtils.mc().field_71462_r != null && ClientUtils.mc().field_71462_r instanceof BlastFurnaceScreen && BlastFurnaceFuel.isValidBlastFuel(event.getItemStack())) {
            event.getToolTip().add(new TranslationTextComponent("desc.immersiveengineering.info.blastFuelTime", new Object[]{BlastFurnaceFuel.getBlastFuelTime(event.getItemStack())}).func_150255_a(gray));
        }
        if (((Boolean)IEConfig.GENERAL.tagTooltips.get()).booleanValue() && event.getFlags().func_194127_a()) {
            for (ResourceLocation oid : ItemTags.func_199903_a().func_199913_a((Object)event.getItemStack().func_77973_b())) {
                event.getToolTip().add(new StringTextComponent(oid.toString()).func_150255_a(gray));
            }
        }
        if (event.getItemStack().func_77973_b() instanceof IEItemInterfaces.IBulletContainer) {
            for (String s : BULLET_TOOLTIP) {
                event.getToolTip().add(new StringTextComponent(s));
            }
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        NonNullList<ItemStack> bullets;
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof IEItemInterfaces.IBulletContainer && (bullets = ((IEItemInterfaces.IBulletContainer)stack.func_77973_b()).getBullets(stack, true)) != null) {
            int bulletAmount = ((IEItemInterfaces.IBulletContainer)stack.func_77973_b()).getBulletCount(stack);
            int line = event.getLines().size() - Utils.findSequenceInList(event.getLines(), BULLET_TOOLTIP, (a, b) -> b.endsWith((String)a));
            int currentX = event.getX();
            int currentY = line > 0 ? event.getY() + (event.getHeight() + 1 - line * 10) : event.getY() - 42;
            MatrixStack transform = new MatrixStack();
            transform.func_227860_a_();
            transform.func_227861_a_((double)currentX, (double)currentY, 700.0);
            transform.func_227862_a_(0.5f, 0.5f, 1.0f);
            RevolverScreen.drawExternalGUI(bullets, bulletAmount, transform);
        }
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        event.getSound().func_184365_d();
        if (!EarmuffsItem.affectedSoundCategories.contains(event.getSound().func_184365_d().func_187948_a())) {
            return;
        }
        if (ClientUtils.mc().field_71439_g != null && !ClientUtils.mc().field_71439_g.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            ItemStack earmuffs = ClientUtils.mc().field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
            if (ItemNBTHelper.hasKey(earmuffs, "IE:Earmuffs")) {
                earmuffs = ItemNBTHelper.getItemStack(earmuffs, "IE:Earmuffs");
            }
            if (!earmuffs.func_190926_b() && IEItems.Misc.earmuffs == earmuffs.func_77973_b() && !ItemNBTHelper.getBoolean(earmuffs, "IE:Earmuffs:Cat_" + event.getSound().func_184365_d().func_187948_a())) {
                BlockPos pos;
                for (String blacklist : (List)IEConfig.TOOLS.earDefenders_SoundBlacklist.get()) {
                    if (blacklist == null || !blacklist.equalsIgnoreCase(event.getSound().func_147650_b().toString())) continue;
                    return;
                }
                if (event.getSound() instanceof ITickableSound) {
                    event.setResultSound((ISound)new IEMuffledTickableSound((ITickableSound)event.getSound(), EarmuffsItem.getVolumeMod(earmuffs)));
                } else {
                    event.setResultSound((ISound)new IEMuffledSound(event.getSound(), EarmuffsItem.getVolumeMod(earmuffs)));
                }
                if (event.getSound().func_184365_d() == SoundCategory.RECORDS && ClientUtils.mc().field_71438_f.field_147593_P.containsKey(pos = new BlockPos((double)event.getSound().func_147649_g(), (double)event.getSound().func_147654_h(), (double)event.getSound().func_147651_i()))) {
                    ClientUtils.mc().field_71438_f.field_147593_P.put(pos, event.getResultSound());
                }
            }
        }
    }

    private void renderObstructingBlocks(MatrixStack transform, IRenderTypeBuffer buffers) {
        IVertexBuilder baseBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(baseBuilder);
        builder.setColor(1.0f, 0.0f, 0.0f, 0.5f);
        for (Map.Entry<Connection, Pair<Collection<BlockPos>, AtomicInteger>> entry : FAILED_CONNECTIONS.entrySet()) {
            for (BlockPos obstruction : (Collection)entry.getValue().getKey()) {
                transform.func_227860_a_();
                transform.func_227861_a_((double)obstruction.func_177958_n(), (double)obstruction.func_177956_o(), (double)obstruction.func_177952_p());
                float eps = 0.001f;
                ClientUtils.renderBox(builder, transform, -0.001f, -0.001f, -0.001f, 1.001f, 1.001f, 1.001f);
                transform.func_227865_b_();
            }
        }
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemInFrameEvent event) {
        BlueprintCraftingRecipe[] recipes;
        double playerDistanceSq;
        if (event.getItem().func_77973_b() instanceof EngineersBlueprintItem && (playerDistanceSq = ClientUtils.mc().field_71439_g.func_70068_e((Entity)event.getEntityItemFrame())) < 1000.0 && (recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(event.getItem(), "blueprint"))).length > 0) {
            AutoWorkbenchRenderer.BlueprintLines blueprint;
            int i = event.getEntityItemFrame().func_82333_j();
            BlueprintCraftingRecipe recipe = recipes[i % recipes.length];
            AutoWorkbenchRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : AutoWorkbenchRenderer.getBlueprintDrawable(recipe, event.getEntityItemFrame().func_130014_f_());
            if (blueprint != null) {
                MatrixStack transform = event.getMatrix();
                transform.func_227860_a_();
                IRenderTypeBuffer buffer = event.getBuffers();
                transform.func_227863_a_(new Quaternion(0.0f, 0.0f, (float)(-i * 45), true));
                transform.func_227861_a_(-0.5, 0.5, -0.001);
                IVertexBuilder builder = buffer.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/models/blueprint_frame.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.125f, -0.875f, 0.75f, 0.75f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                float lineWidth = playerDistanceSq < 3.0 ? 3.0f : (playerDistanceSq < 25.0 ? 2.0f : (playerDistanceSq < 40.0 ? 1.0f : 0.5f));
                transform.func_227861_a_(0.75, -0.25, -0.002);
                float scale = 0.0375f / ((float)blueprint.getTextureScale() / 16.0f);
                transform.func_227862_a_(-scale, -scale, scale);
                blueprint.draw(lineWidth, transform, buffer);
                transform.func_227865_b_();
                event.setCanceled(true);
            }
        }
    }

    private static void handleSubtitleOffset(boolean pre) {
        float offset = 0.0f;
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        for (Hand hand : Hand.values()) {
            if (player.func_184586_b(hand).func_190926_b()) continue;
            Item equipped = player.func_184586_b(hand).func_77973_b();
            if (equipped instanceof RevolverItem || equipped instanceof SpeedloaderItem) {
                offset = 50.0f;
                continue;
            }
            if (equipped instanceof DrillItem || equipped instanceof ChemthrowerItem || equipped instanceof BuzzsawItem) {
                offset = 50.0f;
                continue;
            }
            if (!(equipped instanceof RailgunItem) && !(equipped instanceof IEShieldItem)) continue;
            offset = 20.0f;
        }
        if (offset != 0.0f) {
            if (pre) {
                offset *= -1.0f;
            }
            GlStateManager.func_227688_c_((float)0.0f, (float)offset, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.SUBTITLES) {
            ClientEventHandler.handleSubtitleOffset(true);
        }
        if (ZoomHandler.isZooming && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                MatrixStack transform = new MatrixStack();
                transform.func_227860_a_();
                int width = ClientUtils.mc().func_228018_at_().func_198107_o();
                int height = ClientUtils.mc().func_228018_at_().func_198087_p();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientUtils.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216, (IRenderTypeBuffer)buffers, transform);
                    ClientUtils.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216, (IRenderTypeBuffer)buffers, transform);
                } else {
                    ClientUtils.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216, (IRenderTypeBuffer)buffers, transform);
                    ClientUtils.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216, (IRenderTypeBuffer)buffers, transform);
                }
                transform.func_227861_a_((double)offsetX, (double)offsetY, 0.0);
                IVertexBuilder builder = buffers.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/scope.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, resMin, resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
                builder = buffers.getBuffer(IERenderTypes.getGui(IEDataGenerator.rl("textures/gui/hud_elements.png")));
                ClientUtils.drawTexturedRect(builder, transform, 0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.25f, 0.34375f, 0.375f, 0.875f);
                ItemStack equipped = ClientUtils.mc().field_71439_g.func_184586_b(Hand.MAIN_HAND);
                if (!equipped.func_190926_b() && equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)equipped.func_77973_b()).getZoomSteps(equipped, (PlayerEntity)ClientUtils.mc().field_71439_g)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    transform.func_227861_a_((double)(0.87109375f * (float)resMin), (double)(0.25f * (float)resMin), 0.0);
                    transform.func_227861_a_(0.0, (double)((5.0f + stepOffset) / 256.0f * (float)resMin), 0.0);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.375f, 0.375f, 0.40234375f);
                        transform.func_227861_a_(0.0, (double)(stepLength / 256.0f * (float)resMin), 0.0);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    transform.func_227861_a_(0.0, (double)(-totalOffset / 256.0f * (float)resMin), 0.0);
                    if (curStep < steps.length) {
                        transform.func_227861_a_((double)(0.0234375f * (float)resMin), (double)((float)curStep * stepLength / 256.0f * (float)resMin), 0.0);
                        ClientUtils.drawTexturedRect(builder, transform, 0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 1.0f, 1.0f, 1.0f, 1.0f, 0.34375f, 0.3828125f, 0.40234375f, 0.4296875f);
                        ClientUtils.font().func_228079_a_(1.0f / steps[curStep] + "x", (float)((int)(0.0625f * (float)resMin)), 0.0f, 0xFFFFFF, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffers, false, 0, 0xF000F0);
                        transform.func_227861_a_((double)(-0.0234375f * (float)resMin), (double)((float)(-curStep) * stepLength / 256.0f * (float)resMin), 0.0);
                    }
                    transform.func_227861_a_(0.0, (double)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), 0.0);
                    transform.func_227861_a_((double)(-0.87109375f * (float)resMin), (double)(-0.25f * (float)resMin), 0.0);
                }
                transform.func_227861_a_((double)(-offsetX), (double)(-offsetY), 0.0);
                buffers.func_228461_a_();
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        int scaledWidth = ClientUtils.mc().func_228018_at_().func_198107_o();
        int scaledHeight = ClientUtils.mc().func_228018_at_().func_198087_p();
        if (event.getType() == RenderGameOverlayEvent.ElementType.SUBTITLES) {
            ClientEventHandler.handleSubtitleOffset(false);
        }
        if (ClientUtils.mc().field_71439_g != null && event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
            MatrixStack transform = new MatrixStack();
            for (Hand hand : Hand.values()) {
                if (player.func_184586_b(hand).func_190926_b()) continue;
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                ItemStack equipped = player.func_184586_b(hand);
                if (ItemStack.func_179545_c((ItemStack)new ItemStack((IItemProvider)IEItems.Tools.voltmeter), (ItemStack)equipped) || equipped.func_77973_b() instanceof IWireCoil) {
                    if (WirecoilUtils.hasWireLink(equipped)) {
                        int max;
                        RayTraceResult rtr;
                        double d;
                        WirecoilUtils.WireLink link = WirecoilUtils.WireLink.readFromItem(equipped);
                        BlockPos pos = link.cp.getPosition();
                        String s = I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedTo", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                        int col = WireType.ELECTRUM.getColour(null);
                        if (equipped.func_77973_b() instanceof IWireCoil && (d = (rtr = ClientUtils.mc().field_71476_x) instanceof BlockRayTraceResult ? ((BlockRayTraceResult)rtr).func_216350_a().func_218140_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true) : player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) > (double)((max = ((IWireCoil)equipped.func_77973_b()).getWireType(equipped).getMaxLength()) * max)) {
                            col = 0xDD3333;
                        }
                        ClientUtils.font().func_228079_a_(s, (float)(scaledWidth / 2 - ClientUtils.font().func_78256_a(s) / 2), (float)(scaledHeight - ForgeIngameGui.left_height - 20), col, true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                    }
                } else if (equipped.func_77973_b() == IEItems.Misc.fluorescentTube) {
                    String s = I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"#" + FluorescentTubeItem.hexColorString(equipped)});
                    ClientUtils.font().func_228079_a_(s, (float)(scaledWidth / 2 - ClientUtils.font().func_78256_a(s) / 2), (float)(scaledHeight - ForgeIngameGui.left_height - 20), FluorescentTubeItem.getRGBInt(equipped, 1.0f), true, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                } else if (equipped.func_77973_b() instanceof RevolverItem || equipped.func_77973_b() instanceof SpeedloaderItem) {
                    ItemOverlayUtils.renderRevolverOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                } else if (equipped.func_77973_b() instanceof RailgunItem) {
                    ItemOverlayUtils.renderRailgunOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                } else if (equipped.func_77973_b() instanceof DrillItem) {
                    ItemOverlayUtils.renderDrillOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                } else if (equipped.func_77973_b() instanceof BuzzsawItem) {
                    ItemOverlayUtils.renderBuzzsawOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                } else if (equipped.func_77973_b() instanceof ChemthrowerItem) {
                    ItemOverlayUtils.renderChemthrowerOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                } else if (equipped.func_77973_b() instanceof IEShieldItem) {
                    ItemOverlayUtils.renderShieldOverlay(buffer, transform, scaledWidth, scaledHeight, (PlayerEntity)player, hand, equipped);
                }
                if (equipped.func_77973_b() == IEItems.Tools.voltmeter) {
                    RayTraceResult rrt = ClientUtils.mc().field_71476_x;
                    IFluxReceiver receiver = null;
                    Direction side = null;
                    if (rrt instanceof BlockRayTraceResult) {
                        BlockRayTraceResult mop = (BlockRayTraceResult)rrt;
                        TileEntity tileEntity = player.field_70170_p.func_175625_s(mop.func_216350_a());
                        if (tileEntity instanceof IFluxReceiver) {
                            receiver = (IFluxReceiver)tileEntity;
                        }
                        side = mop.func_216354_b();
                        if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRequestBlockUpdate(mop.func_216350_a()));
                        }
                    } else if (rrt instanceof EntityRayTraceResult && ((EntityRayTraceResult)rrt).func_216348_a() instanceof IFluxReceiver) {
                        receiver = (IFluxReceiver)((EntityRayTraceResult)rrt).func_216348_a();
                    }
                    if (receiver != null) {
                        String[] text = new String[]{};
                        int maxStorage = receiver.getMaxEnergyStored(side);
                        int storage = receiver.getEnergyStored(side);
                        if (maxStorage > 0) {
                            text = I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                        }
                        int col = (Boolean)IEConfig.GENERAL.nixietubeFont.get() != false ? 0xFF9900 : 0xFFFFFF;
                        int i = 0;
                        RenderSystem.enableBlend();
                        for (String s : text) {
                            if (s == null) continue;
                            s = s.trim();
                            int w = ClientProxy.nixieFontOptional.func_78256_a(s);
                            ClientProxy.nixieFontOptional.func_228079_a_(s, scaledWidth / 2 - w / 2, scaledHeight / 2 - 4 - text.length * (ClientProxy.nixieFontOptional.getFontHeight() + 2) + i++ * (ClientProxy.nixieFontOptional.getFontHeight() + 2), col, false, transform.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                        }
                        RenderSystem.disableBlend();
                    }
                }
                buffer.func_228461_a_();
            }
            if (ClientUtils.mc().field_71476_x != null) {
                ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
                boolean hammer = !held.func_190926_b() && Utils.isHammer(held);
                RayTraceResult mop = ClientUtils.mc().field_71476_x;
                if (mop instanceof EntityRayTraceResult) {
                    Object containedTile;
                    Entity entity2 = ((EntityRayTraceResult)mop).func_216348_a();
                    if (entity2 instanceof ItemFrameEntity) {
                        BlockOverlayUtils.renderOreveinMapOverlays((ItemFrameEntity)entity2, mop, scaledWidth, scaledHeight);
                    } else if (entity2 instanceof IEMinecartEntity && (containedTile = ((IEMinecartEntity)entity2).getContainedTileEntity()) instanceof IEBlockInterfaces.IBlockOverlayText) {
                        String[] text = ((IEBlockInterfaces.IBlockOverlayText)containedTile).getOverlayText((PlayerEntity)player, mop, false);
                        BlockOverlayUtils.drawBlockOverlayText(transform, text, scaledWidth, scaledHeight);
                    }
                } else if (mop instanceof BlockRayTraceResult) {
                    BlockPos pos = ((BlockRayTraceResult)mop).func_216350_a();
                    Direction face = ((BlockRayTraceResult)mop).func_216354_b();
                    TileEntity tileEntity = player.field_70170_p.func_175625_s(pos);
                    if (tileEntity instanceof IEBlockInterfaces.IBlockOverlayText) {
                        IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                        String[] text = overlayBlock.getOverlayText((PlayerEntity)ClientUtils.mc().field_71439_g, mop, hammer);
                        BlockOverlayUtils.drawBlockOverlayText(transform, text, scaledWidth, scaledHeight);
                    } else {
                        List list = player.field_70170_p.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB(pos.func_177972_a(face)), entity -> entity != null && entity.func_174811_aO() == face);
                        if (list.size() == 1) {
                            BlockOverlayUtils.renderOreveinMapOverlays((ItemFrameEntity)list.get(0), mop, scaledWidth, scaledHeight);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFogUpdate(EntityViewRenderEvent.RenderFogEvent event) {
        Entity e = event.getInfo().func_216773_g();
        if (e instanceof LivingEntity && ((LivingEntity)e).func_70644_a(IEPotions.flashed)) {
            EffectInstance effect = ((LivingEntity)e).func_70660_b(IEPotions.flashed);
            int timeLeft = effect.func_76459_b();
            float saturation = Math.max(0.25f, 1.0f - (float)timeLeft / (float)(80 + 40 * effect.func_76458_c()));
            float f1 = -2.5f + 15.0f * saturation;
            if (timeLeft < 20) {
                f1 += event.getFarPlaneDistance() / 4.0f * (1.0f - (float)timeLeft / 20.0f);
            }
            RenderSystem.fogStart((float)(0.25f * f1));
            RenderSystem.fogEnd((float)f1);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            RenderSystem.setupNvFogDistance();
        }
    }

    @SubscribeEvent
    public void onFogColourUpdate(EntityViewRenderEvent.FogColors event) {
        Entity e = event.getInfo().func_216773_g();
        if (e instanceof LivingEntity && ((LivingEntity)e).func_70644_a(IEPotions.flashed)) {
            event.setRed(1.0f);
            event.setGreen(1.0f);
            event.setBlue(1.0f);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        boolean mayZoom;
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        ItemStack equipped = player.func_184586_b(Hand.MAIN_HAND);
        boolean bl = mayZoom = equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && ((ZoomHandler.IZoomTool)equipped.func_77973_b()).canZoom(equipped, (PlayerEntity)player);
        if (ZoomHandler.isZooming) {
            if (mayZoom) {
                event.setNewfov(ZoomHandler.fovZoom);
            } else {
                ZoomHandler.isZooming = false;
            }
        }
        if (player.func_70660_b(IEPotions.concreteFeet) != null) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = ClientUtils.mc().field_71439_g;
        if (event.getScrollDelta() != 0.0 && ClientUtils.mc().field_71462_r == null && player != null) {
            float[] steps;
            ItemStack equipped = player.func_184586_b(Hand.MAIN_HAND);
            if (equipped.func_77973_b() instanceof ZoomHandler.IZoomTool && ((ZoomHandler.IZoomTool)equipped.func_77973_b()).canZoom(equipped, (PlayerEntity)player) && ZoomHandler.isZooming && (steps = ((ZoomHandler.IZoomTool)equipped.func_77973_b()).getZoomSteps(equipped, (PlayerEntity)player)) != null && steps.length > 0) {
                int curStep = ZoomHandler.getCurrentZoomStep(steps);
                int newStep = curStep + (event.getScrollDelta() > 0.0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHandler.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
            if (player.func_225608_bj_()) {
                if (((Boolean)IEConfig.TOOLS.chemthrower_scroll.get()).booleanValue() && equipped.func_77973_b() instanceof IEItemInterfaces.IScrollwheel) {
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageScrollwheelItem(event.getScrollDelta() < 0.0));
                    event.setCanceled(true);
                }
                if (equipped.func_77973_b() instanceof RevolverItem) {
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRevolverRotate(event.getScrollDelta() < 0.0));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawHighlightEvent event) {
        if (event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK) {
            ItemStack head;
            Direction side;
            ItemStack stack;
            MatrixStack transform = event.getMatrix();
            IRenderTypeBuffer buffer = event.getBuffers();
            BlockRayTraceResult rtr = (BlockRayTraceResult)event.getTarget();
            BlockPos pos = rtr.func_216350_a();
            Vec3d renderView = event.getInfo().func_216785_c();
            transform.func_227860_a_();
            transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
            transform.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Entity player = event.getInfo().func_216773_g();
            float f1 = 0.002f;
            TileEntity tile = player.field_70170_p.func_175625_s(rtr.func_216350_a());
            ItemStack itemStack = stack = player instanceof LivingEntity ? ((LivingEntity)player).func_184586_b(Hand.MAIN_HAND) : ItemStack.field_190927_a;
            if (Utils.isHammer(stack) && tile instanceof TurntableTileEntity) {
                TurntableTileEntity turntableTile = (TurntableTileEntity)tile;
                side = rtr.func_216354_b();
                Direction facing = turntableTile.getFacing();
                if (side.func_176740_k() != facing.func_176740_k()) {
                    transform.func_227860_a_();
                    transform.func_227861_a_(0.5, 0.5, 0.5);
                    ClientUtils.toModelRotation(side).func_225615_b_().push(transform);
                    transform.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
                    Rotation rotation = turntableTile.getRotationFromSide(side);
                    boolean cw180 = rotation == Rotation.CLOCKWISE_180;
                    double angle = cw180 ? (double)(player.field_70173_aa % 40) / 20.0 : (double)(player.field_70173_aa % 80) / 40.0;
                    double stepDistance = (double)(cw180 ? 2 : 4) * Math.PI;
                    angle = -(angle - Math.sin(angle * stepDistance) / stepDistance) * Math.PI;
                    BlockOverlayUtils.drawCircularRotationArrows(buffer, transform, (float)angle, rotation == Rotation.COUNTERCLOCKWISE_90, cw180);
                    transform.func_227865_b_();
                    transform.func_227865_b_();
                }
            }
            World world = player.field_70170_p;
            if (!stack.func_190926_b() && ConveyorHandler.conveyorBlocks.containsValue(Block.func_149634_a((Item)stack.func_77973_b())) && rtr.func_216354_b().func_176740_k() == Direction.Axis.Y) {
                side = rtr.func_216354_b();
                VoxelShape shape = world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos);
                AxisAlignedBB targetedBB = null;
                if (!shape.func_197766_b()) {
                    targetedBB = shape.func_197752_a();
                }
                IRenderTypeBuffer buffers = event.getBuffers();
                float[][] points = new float[4][];
                if (side.func_176740_k() == Direction.Axis.Y) {
                    float y = (float)(targetedBB == null ? 0.0 : (side == Direction.DOWN ? targetedBB.field_72338_b - (double)f1 : targetedBB.field_72337_e + (double)f1));
                    points[0] = new float[]{0.0f - f1, y, 0.0f - f1};
                    points[1] = new float[]{1.0f + f1, y, 1.0f + f1};
                    points[2] = new float[]{0.0f - f1, y, 1.0f + f1};
                    points[3] = new float[]{1.0f + f1, y, 0.0f - f1};
                } else if (side.func_176740_k() == Direction.Axis.Z) {
                    float z = (float)(targetedBB == null ? 0.0 : (side == Direction.NORTH ? targetedBB.field_72339_c - (double)f1 : targetedBB.field_72334_f + (double)f1));
                    points[0] = new float[]{1.0f + f1, 1.0f + f1, z};
                    points[1] = new float[]{0.0f - f1, 0.0f - f1, z};
                    points[2] = new float[]{0.0f - f1, 1.0f + f1, z};
                    points[3] = new float[]{1.0f + f1, 0.0f - f1, z};
                } else {
                    float x = (float)(targetedBB == null ? 0.0 : (side == Direction.WEST ? targetedBB.field_72340_a - (double)f1 : targetedBB.field_72336_d + (double)f1));
                    points[0] = new float[]{x, 1.0f + f1, 1.0f + f1};
                    points[1] = new float[]{x, 0.0f - f1, 0.0f - f1};
                    points[2] = new float[]{x, 1.0f + f1, 0.0f - f1};
                    points[3] = new float[]{x, 0.0f - f1, 1.0f + f1};
                }
                Matrix4f mat = transform.func_227866_c_().func_227870_a_();
                IVertexBuilder lineBuilder = buffers.getBuffer(IERenderTypes.TRANSLUCENT_LINES);
                for (float[] point : points) {
                    lineBuilder.func_227888_a_(mat, point[0], point[1], point[2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                }
                lineBuilder.func_227888_a_(mat, points[0][0], points[0][1], points[0][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[2][0], points[2][1], points[2][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[1][0], points[1][1], points[1][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[3][0], points[3][1], points[3][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                lineBuilder.func_227888_a_(mat, points[0][0], points[0][1], points[0][2]).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                float xFromMid = side.func_176740_k() == Direction.Axis.X ? 0.0f : (float)rtr.func_216347_e().field_72450_a - (float)pos.func_177958_n() - 0.5f;
                float yFromMid = side.func_176740_k() == Direction.Axis.Y ? 0.0f : (float)rtr.func_216347_e().field_72448_b - (float)pos.func_177956_o() - 0.5f;
                float zFromMid = side.func_176740_k() == Direction.Axis.Z ? 0.0f : (float)rtr.func_216347_e().field_72449_c - (float)pos.func_177952_p() - 0.5f;
                float max = Math.max(Math.abs(yFromMid), Math.max(Math.abs(xFromMid), Math.abs(zFromMid)));
                Vec3d dir = new Vec3d(max == Math.abs(xFromMid) ? (double)Math.signum(xFromMid) : 0.0, max == Math.abs(yFromMid) ? (double)Math.signum(yFromMid) : 0.0, max == Math.abs(zFromMid) ? (double)Math.signum(zFromMid) : 0.0);
                BlockOverlayUtils.drawBlockOverlayArrow(mat, buffers, dir, side, targetedBB);
            }
            transform.func_227865_b_();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof DrillItem && ((DrillItem)stack.func_77973_b()).isEffective(world.func_180495_p(rtr.func_216350_a()).func_185904_a()) && !(head = ((DrillItem)stack.func_77973_b()).getHead(stack)).func_190926_b() && player instanceof PlayerEntity && !player.func_225608_bj_()) {
                ImmutableList<BlockPos> blocks = ((IDrillHead)head.func_77973_b()).getExtraBlocksDug(head, world, (PlayerEntity)player, event.getTarget());
                BlockOverlayUtils.drawAdditionalBlockbreak(event, (PlayerEntity)player, event.getPartialTicks(), blocks);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        float partial = event.getPartialTicks();
        MatrixStack transform = event.getMatrixStack();
        transform.func_227860_a_();
        Vec3d renderView = ClientUtils.mc().field_71460_t.func_215316_n().func_216785_c();
        transform.func_227861_a_(-renderView.field_72450_a, -renderView.field_72448_b, -renderView.field_72449_c);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        if (!FractalParticle.PARTICLE_FRACTAL_DEQUE.isEmpty()) {
            ArrayList<Pair> renders = new ArrayList<Pair>();
            for (FractalParticle fractalParticle : FractalParticle.PARTICLE_FRACTAL_DEQUE) {
                for (Map.Entry entry : fractalParticle.render(partial, transform)) {
                    boolean added = false;
                    for (Map.Entry entry2 : renders) {
                        if (!((RenderType)entry2.getKey()).equals(entry.getKey())) continue;
                        ((List)entry2.getValue()).add(entry.getValue());
                        added = true;
                        break;
                    }
                    if (added) continue;
                    renders.add(Pair.of(entry.getKey(), new ArrayList(ImmutableList.of(entry.getValue()))));
                }
            }
            for (Map.Entry entry : renders) {
                IVertexBuilder bb = buffers.getBuffer((RenderType)entry.getKey());
                for (Consumer render : (List)entry.getValue()) {
                    render.accept(bb);
                }
            }
            FractalParticle.PARTICLE_FRACTAL_DEQUE.clear();
        }
        if (!FAILED_CONNECTIONS.isEmpty()) {
            IVertexBuilder builder = buffers.getBuffer(IERenderTypes.CHUNK_MARKER);
            for (Map.Entry entry : FAILED_CONNECTIONS.entrySet()) {
                Connection conn = (Connection)entry.getKey();
                transform.func_227860_a_();
                transform.func_227861_a_((double)conn.getEndA().getX(), (double)conn.getEndA().getY(), (double)conn.getEndA().getZ());
                Matrix4f matrix4f = transform.func_227866_c_().func_227870_a_();
                int time = ((AtomicInteger)((Pair)entry.getValue()).getValue()).get();
                float alpha = (float)Math.min((2.0 + Math.sin((double)time * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
                Vec3d vec3d = conn.getPoint(0.0, conn.getEndA());
                for (int i = 0; i < 16; ++i) {
                    void var13_28;
                    builder.func_227888_a_(matrix4f, (float)var13_28.field_72450_a, (float)var13_28.field_72448_b, (float)var13_28.field_72449_c).func_227885_a_(1.0f, 0.0f, 0.0f, alpha).func_181675_d();
                    alpha = (float)Math.min((2.0 + Math.sin((double)(time + (i + 1) * 8) * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
                    Vec3d next = conn.getPoint((double)(i + 1) / 16.0, conn.getEndA());
                    builder.func_227888_a_(matrix4f, (float)next.field_72450_a, (float)next.field_72448_b, (float)next.field_72449_c).func_227885_a_(1.0f, 0.0f, 0.0f, alpha).func_181675_d();
                    Vec3d vec3d2 = next;
                }
                transform.func_227865_b_();
            }
            this.renderObstructingBlocks(transform, (IRenderTypeBuffer)buffers);
        }
        transform.func_227865_b_();
        buffers.func_228461_a_();
    }

    @SubscribeEvent
    public void onClientDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getEntity().getPersistentData().func_74764_b("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.getEntity().getPersistentData().func_74764_b("headshot")) {
            ClientEventHandler.enableHead(event.getRenderer(), true);
        }
    }

    private static void enableHead(LivingRenderer renderer, boolean shouldEnable) {
        EntityModel m = renderer.func_217764_d();
        if (m instanceof IHasHead) {
            ((IHasHead)m).func_205072_a().field_78806_j = shouldEnable;
        }
    }
}

