/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class GoVoteHandler {
    private static final String BRAND = "Immersive Engineering";
    private static final String MARKER_PATH = ".vote2020_marker";
    private static final LocalDate ELECTION_DAY = LocalDate.of(2020, Month.NOVEMBER, 3);
    private static final String LINK = "https://vote.gov/";
    private static boolean shownThisSession = false;
    private static volatile boolean markerAlreadyExists = false;
    private static volatile String countryCode = Locale.getDefault().getCountry();

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        if (GoVoteHandler.isAfterElectionDay()) {
            return;
        }
        try {
            Path path = Paths.get(MARKER_PATH, new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            if (Util.func_110647_a() == Util.OS.WINDOWS) {
                Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
            }
        }
        catch (IOException ex) {
            if (ex instanceof FileAlreadyExistsException) {
                IELogger.debug("Go vote handler: Marker already exists");
            }
            markerAlreadyExists = true;
            return;
        }
        MinecraftForge.EVENT_BUS.addListener(GoVoteHandler::guiOpen);
        new Thread(() -> {
            try {
                URL url = new URL("http://ip-api.com/json/");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(4000);
                conn.setReadTimeout(4000);
                try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                    Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
                    Map map = (Map)new Gson().fromJson((Reader)reader, typeToken);
                    countryCode = (String)map.get("countryCode");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "Go Vote Country Check").start();
    }

    private static boolean isAfterElectionDay() {
        return LocalDate.now().isAfter(ELECTION_DAY);
    }

    private static void guiOpen(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Screen curr = event.getGui();
        if ((curr instanceof WorldSelectionScreen || curr instanceof MultiplayerScreen) && GoVoteHandler.shouldShow(mc)) {
            event.setGui((Screen)new GoVoteScreen(curr));
            shownThisSession = true;
        }
    }

    private static boolean shouldShow(Minecraft mc) {
        if (!GoVoteHandler.isEnglish(mc) || shownThisSession || GoVoteHandler.isAfterElectionDay() || markerAlreadyExists) {
            return false;
        }
        return "US".equals(countryCode);
    }

    private static boolean isEnglish(Minecraft mc) {
        return mc.func_135016_M() != null && mc.func_135016_M().func_135041_c() != null && "English".equals(mc.func_135016_M().func_135041_c().getName());
    }

    private static class GoVoteScreen
    extends Screen {
        private static final int TICKS_PER_GROUP = 50;
        private final Screen parent;
        private int ticksElapsed = 0;
        private final List<List<ITextComponent>> message = new ArrayList<List<ITextComponent>>();

        protected GoVoteScreen(Screen parent) {
            super((ITextComponent)new StringTextComponent(""));
            this.parent = parent;
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("Please read the following message from Immersive Engineering.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("We are at a unique crossroads in the history of our country.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("In this time of heightened polarization,"), GoVoteScreen.s("breakdown of political decorum, and fear,")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("it is tempting to succumb to apathy,"), GoVoteScreen.s("to think that nothing you do will matter.")});
            this.addGroup(new ITextComponent[]{new StringTextComponent(""), GoVoteScreen.s("But power is still in the hands of We, the People.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("The Constitution and its amendments guarantee us the right to vote.")});
            this.addGroup(GoVoteScreen.s("And it is not only our right, but our ").func_150257_a(GoVoteScreen.s("responsibility").func_211709_a(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD})).func_150258_a(" to do so."));
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("Your vote matters. Always.")});
            this.addGroup(new ITextComponent[]{new StringTextComponent(""), GoVoteScreen.s("Click anywhere to check if you are registered to vote."), GoVoteScreen.s("The website is an official government site, unaffiliated with Immersive Engineering.")});
            this.addGroup(new ITextComponent[]{GoVoteScreen.s("Press ESC to exit. (This screen will not show up again.)")});
        }

        private void addGroup(ITextComponent ... lines) {
            this.message.add(Arrays.asList(lines));
        }

        private static StringTextComponent s(String txt) {
            return new StringTextComponent(txt);
        }

        public void tick() {
            super.tick();
            ++this.ticksElapsed;
        }

        public void render(int mx, int my, float pticks) {
            super.render(mx, my, pticks);
            GoVoteScreen.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-9868951);
            int middle = this.width / 2;
            int dist = 12;
            ITextComponent note1 = GoVoteScreen.s("Note: If you can't vote in the United States,").func_211708_a(TextFormatting.ITALIC);
            ITextComponent note2 = GoVoteScreen.s("Please press ESC and carry on.").func_211708_a(TextFormatting.ITALIC);
            this.drawCenteredString(this.font, note1.getString(), middle, 10, 0xFFFFFF);
            this.drawCenteredString(this.font, note2.getString(), middle, 22, 0xFFFFFF);
            int y = 46;
            for (int groupIdx = 0; groupIdx < this.message.size(); ++groupIdx) {
                List<ITextComponent> group = this.message.get(groupIdx);
                if (this.ticksElapsed - 20 <= groupIdx * 50) continue;
                for (ITextComponent line : group) {
                    this.drawCenteredString(this.font, line.getString(), middle, y, 0xFFFFFF);
                    y += dist;
                }
            }
        }

        @Nonnull
        public String getNarrationMessage() {
            StringBuilder builder = new StringBuilder();
            for (List<ITextComponent> group : this.message) {
                for (ITextComponent line : group) {
                    builder.append(line.getString());
                }
            }
            return builder.toString();
        }

        public boolean keyPressed(int keycode, int scanCode, int modifiers) {
            if (keycode == 256) {
                this.minecraft.func_147108_a(this.parent);
            }
            return super.keyPressed(keycode, scanCode, modifiers);
        }

        public boolean mouseClicked(double x, double y, int modifiers) {
            if (this.ticksElapsed < 80) {
                return false;
            }
            if (modifiers == 0) {
                this.minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(this::consume, GoVoteHandler.LINK, true));
                return true;
            }
            return super.mouseClicked(x, y, modifiers);
        }

        private void consume(boolean doIt) {
            this.minecraft.func_147108_a((Screen)this);
            if (doIt) {
                Util.func_110647_a().func_195640_a(GoVoteHandler.LINK);
            }
        }
    }
}

