/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.TileRenderUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.SawmillTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class SawmillRenderer
extends TileEntityRenderer<SawmillTileEntity> {
    public static DynamicModel<Direction> BLADE;

    public SawmillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SawmillTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean sawblade;
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.sawmill) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        bufferIn = TileRenderUtils.mirror(te, matrixStack, bufferIn);
        IVertexBuilder solidBuilder = bufferIn.getBuffer(RenderType.func_228639_c_());
        Direction facing = te.getFacing();
        float dir = facing == Direction.SOUTH ? 180.0f : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -90.0f : 90.0f));
        matrixStack.func_227863_a_(new Quaternion(0.0f, dir, 0.0f, true));
        boolean bl = sawblade = !te.sawblade.func_190926_b();
        if (sawblade) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(1.0, 0.125, -0.5);
            float spin = te.animation_bladeRotation;
            if (te.shouldRenderAsActive()) {
                spin += 36.0f * partialTicks;
            }
            matrixStack.func_227863_a_(new Quaternion(0.0f, 0.0f, spin, true));
            ClientUtils.renderModelTESRFast(BLADE.getNullQuads(Direction.NORTH, state), solidBuilder, matrixStack, combinedLightIn, combinedOverlayIn);
            matrixStack.func_227865_b_();
        }
        for (SawmillTileEntity.SawmillProcess process : te.sawmillProcessQueue) {
            float relative = process.getRelativeProcessStep();
            ItemStack rendered = process.getCurrentStack(sawblade);
            this.renderItem(rendered, relative, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        matrixStack.func_227865_b_();
    }

    private void renderItem(ItemStack stack, float progress, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float xOffset = -2.5f + progress * 5.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)xOffset, 0.375, 0.0);
        matrixStack.func_227863_a_(new Quaternion(0.0f, 0.0f, 90.0f, true));
        ClientUtils.mc().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn);
        matrixStack.func_227865_b_();
    }
}

