/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.IEShaderLayerCompositeTexture;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerTileEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class ShaderBannerRenderer
extends TileEntityRenderer<ShaderBannerTileEntity> {
    private final ModelRenderer clothModel = BannerTileEntityRenderer.func_228836_a_();
    private final ModelRenderer standingModel = new ModelRenderer(64, 64, 44, 0);
    private final ModelRenderer crossbar;
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("textures/entity/banner_base.png");
    private static final HashMap<ResourceLocation, ResourceLocation> CACHE = new HashMap();

    public ShaderBannerRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.standingModel.func_228301_a_(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f, 0.0f);
        this.crossbar = new ModelRenderer(64, 64, 0, 42);
        this.crossbar.func_228301_a_(-10.0f, -32.0f, -1.0f, 20.0f, 2.0f, 2.0f, 0.0f);
    }

    public void render(ShaderBannerTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long time = te.getWorldNonnull().func_82737_E();
        matrixStack.func_227860_a_();
        if (te.getState().func_177230_c() == IEBlocks.Cloth.shaderBanner) {
            int orientation = (Integer)te.getState().func_177229_b((IProperty)ShaderBannerStandingBlock.ROTATION);
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            float f1 = (float)(orientation * 360) / 16.0f;
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -f1, true));
            this.standingModel.field_78806_j = true;
        } else {
            assert (te.getState().func_177230_c() == IEBlocks.Cloth.shaderBannerWall);
            Direction facing = (Direction)te.getState().func_177229_b(ShaderBannerWallBlock.FACING);
            float rotation = facing.func_185119_l();
            matrixStack.func_227861_a_(0.5, -0.1666666716337204, 0.5);
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -rotation, true));
            matrixStack.func_227861_a_(0.0, -0.3125, -0.4375);
            this.standingModel.field_78806_j = false;
        }
        BlockPos blockpos = te.func_174877_v();
        float f3 = (float)(blockpos.func_177958_n() * 7 + blockpos.func_177956_o() * 9 + blockpos.func_177952_p() * 13) + (float)time + partialTicks;
        this.clothModel.field_78795_f = (-0.0125f + 0.01f * MathHelper.func_76134_b((float)(f3 * (float)Math.PI * 0.02f))) * (float)Math.PI;
        this.clothModel.field_78797_d = -32.0f;
        ResourceLocation resourcelocation = this.getBannerResourceLocation(te);
        if (resourcelocation != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
            IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)resourcelocation));
            this.clothModel.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            builder = ModelBakery.field_229315_f_.func_229311_a_(bufferIn, RenderType::func_228634_a_);
            this.crossbar.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            this.standingModel.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    @Nullable
    private ResourceLocation getBannerResourceLocation(ShaderBannerTileEntity bannerObj) {
        ResourceLocation name = null;
        ShaderCase sCase = null;
        ItemStack shader = bannerObj.shader.getShaderItem();
        if (!shader.func_190926_b() && shader.func_77973_b() instanceof IShaderItem) {
            IShaderItem iShaderItem = (IShaderItem)shader.func_77973_b();
            name = iShaderItem.getShaderName(shader);
            if (CACHE.containsKey(name)) {
                return CACHE.get(name);
            }
            sCase = iShaderItem.getShaderCase(shader, null, bannerObj.shader.getShaderType());
        }
        if (sCase != null) {
            ShaderLayer[] layers = sCase.getLayers();
            ResourceLocation textureLocation = new ResourceLocation(name.func_110624_b(), "bannershader/" + name.func_110623_a());
            ClientUtils.mc().func_110434_K().func_229263_a_(textureLocation, (Texture)new IEShaderLayerCompositeTexture(BASE_TEXTURE, layers));
            CACHE.put(name, textureLocation);
            return textureLocation;
        }
        return null;
    }
}

