/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullSupplier;

public class WatermillRenderer
extends TileEntityRenderer<WatermillTileEntity> {
    public static DynamicModel<Void> MODEL;
    private static final IVertexBufferHolder MODEL_BUFFER;

    public WatermillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(WatermillTileEntity tile, float partialTicks, MatrixStack transform, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isDummy() || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        transform.func_227860_a_();
        transform.func_227861_a_(0.5, 0.5, 0.5);
        float dir = (tile.getFacing().func_185119_l() + 180.0f) % 180.0f;
        float wheelRotation = 360.0f * (tile.rotation + (!tile.canTurn || tile.rotation == 0.0f ? 0.0f : partialTicks) * (float)tile.perTick);
        transform.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        transform.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), wheelRotation, true));
        transform.func_227861_a_(-0.5, -0.5, -0.5);
        MODEL_BUFFER.render(RenderType.func_228641_d_(), combinedLightIn, combinedOverlayIn, bufferIn, transform);
        transform.func_227865_b_();
    }

    public static void reset() {
        MODEL_BUFFER.reset();
    }

    static {
        MODEL_BUFFER = IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> {
            BlockState state = (BlockState)IEBlocks.WoodenDevices.watermill.func_176223_P().func_206870_a((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)Direction.NORTH);
            return MODEL.get(null).getQuads(state, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
        }));
    }
}

