/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IIEBlock;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BlockIESlab<T extends Block>
extends SlabBlock
implements IIEBlock {
    private final T base;

    public BlockIESlab(String name, Block.Properties props, Function<Block, Item> itemBlock, T base) {
        super(props);
        ResourceLocation registryName = new ResourceLocation("immersiveengineering", name);
        this.setRegistryName(registryName);
        IEContent.registeredIEBlocks.add((Block)this);
        try {
            IEContent.registeredIEItems.add(itemBlock.apply((Block)this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.base = base;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        double relativeEntityPosition = entity.func_180425_c().func_177956_o() - pos.func_177956_o();
        switch ((SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a)) {
            case TOP: {
                return 0.5 < relativeEntityPosition && relativeEntityPosition < 1.0;
            }
            case BOTTOM: {
                return 0.0 < relativeEntityPosition && relativeEntityPosition < 0.5;
            }
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasFlavour() {
        return ((IIEBlock)this.base).hasFlavour();
    }

    @Override
    public String getNameForFlavour() {
        return ((IIEBlock)this.base).getNameForFlavour();
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Math.min(this.base.func_200011_d(state, worldIn, pos), super.func_200011_d(state, worldIn, pos));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return super.func_200123_i(state, reader, pos) || this.base.func_200123_i(state, reader, pos);
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_229869_c_(state, worldIn, pos) && this.base.func_229869_c_(state, worldIn, pos);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_220081_d(state, worldIn, pos) && this.base.func_220081_d(state, worldIn, pos);
    }
}

