/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IETileProviderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightTileEntity;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FakeLightBlock
extends IETileProviderBlock {
    public FakeLightBlock() {
        super("fake_light", Block.Properties.func_200945_a((Material)Material.field_151579_a).func_226896_b_(), (b, p) -> null, new IProperty[0]);
    }

    public boolean isAir(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new FakeLightTileEntity();
    }

    public int func_149750_m(BlockState state) {
        return 15;
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public static class FakeLightTileEntity
    extends IEBaseTileEntity
    implements ITickableTileEntity,
    IEBlockInterfaces.ISpawnInterdiction {
        public BlockPos floodlightCoords = null;

        public FakeLightTileEntity() {
            super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.FAKE_LIGHT.get()));
        }

        public void func_73660_a() {
            if (this.field_145850_b.func_82737_E() % 256L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0xFF)) {
                if (this.floodlightCoords == null) {
                    this.field_145850_b.func_217377_a(this.func_174877_v(), false);
                    return;
                }
                TileEntity tile = Utils.getExistingTileEntity(this.field_145850_b, this.floodlightCoords);
                if (!(tile instanceof FloodlightTileEntity) || !((FloodlightTileEntity)tile).getIsActive()) {
                    this.field_145850_b.func_217377_a(this.func_174877_v(), false);
                    return;
                }
            }
        }

        @Override
        public double getInterdictionRangeSquared() {
            return 1024.0;
        }

        @Override
        public void func_145843_s() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.func_145843_s();
        }

        public void onChunkUnloaded() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.onChunkUnloaded();
        }

        public void onLoad() {
            super.onLoad();
            SpawnInterdictionHandler.addInterdictionTile(this);
        }

        @Override
        public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
            this.floodlightCoords = nbt.func_150297_b("floodlightCoords", 10) ? NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("floodlightCoords")) : null;
        }

        @Override
        public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
            if (this.floodlightCoords != null) {
                nbt.func_218657_a("floodlightCoords", (INBT)NBTUtil.func_186859_a((BlockPos)this.floodlightCoords));
            }
        }
    }
}

