/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.metal.TurretTileEntity;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TurretChemTileEntity
extends TurretTileEntity {
    public FluidTank tank = new FluidTank(4000);
    public boolean ignite = false;
    private LazyOptional<IFluidHandler> tankCap = this.registerConstantCap(this.tank);

    public TurretChemTileEntity() {
        super((TileEntityType<? extends TurretTileEntity>)((TileEntityType)IETileTypes.TURRET_CHEM.get()));
    }

    @Override
    protected double getRange() {
        return 8.0;
    }

    @Override
    protected boolean canActivate() {
        return this.tank.getFluidAmount() > 0 && this.energyStorage.getEnergyStored() >= (Integer)IEConfig.MACHINES.turret_chem_consumption.get();
    }

    @Override
    protected int getChargeupTicks() {
        return 10;
    }

    @Override
    protected int getActiveTicks() {
        return 1;
    }

    @Override
    protected boolean loopActivation() {
        return true;
    }

    @Override
    protected void activate() {
        FluidStack fs = this.tank.getFluid().copy();
        if (!fs.isEmpty()) {
            int consumed = (Integer)IEConfig.TOOLS.chemthrower_consumption.get();
            int energy = (Integer)IEConfig.MACHINES.turret_chem_consumption.get();
            if (consumed <= fs.getAmount() && this.energyStorage.extractEnergy(energy, true) >= energy) {
                this.tank.drain(consumed, IFluidHandler.FluidAction.EXECUTE);
                this.energyStorage.extractEnergy(energy, false);
                Vec3d v = this.getGunToTargetVec(this.target).func_72432_b();
                int split = 8;
                boolean isGas = fs.getFluid().getAttributes().isGaseous();
                float scatter = isGas ? 0.15f : 0.05f;
                float range = isGas ? 0.5f : 1.0f;
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && this.ignite;
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.func_72441_c(Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter, Utils.RAND.nextGaussian() * (double)scatter);
                    Vec3d throwerPos = this.getGunPosition();
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(this.field_145850_b, throwerPos.field_72450_a + v.field_72450_a * 0.875, throwerPos.field_72448_b + v.field_72448_b * 0.875, throwerPos.field_72449_c + v.field_72449_c * 0.875, 0.0, 0.0, 0.0, fs);
                    chem.func_213317_d(vecDir.func_186678_a((double)range));
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (this.field_145850_b.field_72995_K) continue;
                    this.field_145850_b.func_217376_c((Entity)chem);
                }
                if (this.tick % 4 == 0) {
                    if (ignite) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.sprayFire, SoundCategory.BLOCKS, 0.5f, 1.5f);
                    } else {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.spray, SoundCategory.BLOCKS, 0.5f, 0.75f);
                    }
                }
            }
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        super.receiveMessageFromClient(message);
        if (message.func_150297_b("ignite", 1)) {
            this.ignite = message.func_74767_n("ignite");
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.ignite = nbt.func_74767_n("ignite");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        nbt.func_74757_a("ignite", this.ignite);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!(this.isDummy() || capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || facing != null && facing != Direction.DOWN && facing != this.getFacing().func_176734_d())) {
            return this.tankCap.cast();
        }
        return super.getCapability(capability, facing);
    }
}

