/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TurretTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IEntityProof,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IHasObjProperty,
IModelOffsetProvider {
    public FluxStorage energyStorage = new FluxStorage(16000);
    public boolean redstoneControlInverted = false;
    public String owner;
    public List<String> targetList = new ArrayList<String>();
    public boolean whitelist = false;
    public boolean attackAnimals = false;
    public boolean attackPlayers = false;
    public boolean attackNeutrals = false;
    protected int tick = 0;
    protected LivingEntity target;
    public float rotationYaw;
    public float rotationPitch;
    private UUID targetId;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);
    static IEProperties.VisibilityList displayList = IEProperties.VisibilityList.show("base");

    public TurretTileEntity(TileEntityType<? extends TurretTileEntity> type) {
        super(type);
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.isDummy()) {
            return;
        }
        double range = this.getRange();
        if (this.targetId != null) {
            AxisAlignedBB validBox = VoxelShapes.func_197868_b().func_197752_a().func_186670_a(this.field_174879_c).func_186662_g(range);
            List entities = this.field_145850_b.func_217357_a(LivingEntity.class, validBox);
            for (LivingEntity entity : entities) {
                if (!entity.func_110124_au().equals(this.targetId) || !this.isValidTarget(entity, true)) continue;
                this.target = entity;
                break;
            }
            this.targetId = null;
        }
        if (this.target != null) {
            Vec3d delta = this.getGunToTargetVec(this.target);
            double dSq = delta.func_189985_c();
            if (dSq > range * range) {
                this.target = null;
            } else if (this.field_145850_b.field_72995_K) {
                float facingYaw = this.getFacing() == Direction.NORTH ? 180.0f : (this.getFacing() == Direction.WEST ? -90.0f : (this.getFacing() == Direction.EAST ? 90.0f : 0.0f));
                double yaw = MathHelper.func_181159_b((double)delta.field_72450_a, (double)delta.field_72449_c) * 57.29577951308232 - (double)facingYaw;
                this.rotationPitch = (float)(Math.atan2(Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c), delta.field_72448_b) * 57.29577951308232) - 90.0f;
                this.rotationYaw = this.rotationYaw == 0.0f ? (float)(yaw * 0.5) : (float)yaw;
            }
        } else if (this.field_145850_b.field_72995_K) {
            this.rotationYaw = (float)((double)this.rotationYaw * 0.75);
            if (Math.abs(this.rotationYaw) < 10.0f) {
                this.rotationYaw = 0.0f;
            }
            this.rotationPitch = (float)((double)this.rotationPitch * 0.75);
            if (Math.abs(this.rotationPitch) < 10.0f) {
                this.rotationPitch = 0.0f;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 64L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x3F)) {
            this.markContainingBlockForUpdate(null);
        }
        int energy = (Integer)IEConfig.MACHINES.turret_consumption.get();
        if (this.isRSPowered() ^ this.redstoneControlInverted) {
            if (this.energyStorage.extractEnergy(energy, true) == energy) {
                this.energyStorage.extractEnergy(energy, false);
                if (this.target == null || !this.target.func_70089_S() || this.field_145850_b.func_73045_a(this.target.func_145782_y()) == null || this.target.func_110143_aJ() <= 0.0f || !this.canShootEntity(this.target)) {
                    this.target = this.getTarget();
                    if (this.target != null) {
                        this.func_70296_d();
                        this.markContainingBlockForUpdate(null);
                    }
                }
                if (this.target != null && this.canActivate()) {
                    ++this.tick;
                    int chargeup = this.getChargeupTicks();
                    if (this.tick == chargeup) {
                        this.activate();
                    } else if (this.tick > chargeup) {
                        if (this.loopActivation()) {
                            this.activate();
                        } else if (this.tick == chargeup + this.getActiveTicks()) {
                            this.tick = 0;
                        }
                    }
                } else {
                    this.tick = 0;
                }
            }
        } else if (this.target != null) {
            this.target = null;
        }
    }

    private boolean canShootEntity(LivingEntity entity) {
        Vec3d end;
        Vec3d start = this.getGunPosition();
        if (Utils.rayTraceForFirst(start, end = this.getTargetVector(entity), this.field_145850_b, Collections.singleton(this.func_174877_v().func_177984_a())) != null) {
            return false;
        }
        AxisAlignedBB potentialCollateralArea = entity.func_174813_aQ().func_111270_a(new AxisAlignedBB(this.field_174879_c.func_177984_a()));
        List potentialCollateral = this.field_145850_b.func_217357_a(LivingEntity.class, potentialCollateralArea);
        for (LivingEntity coll : potentialCollateral) {
            AxisAlignedBB entityBB = coll.func_174813_aQ().func_186662_g(0.4625);
            if (this.isValidTarget(coll, false) || !entityBB.func_216365_b(start, end).isPresent()) continue;
            return false;
        }
        return true;
    }

    protected Vec3d getTargetVector(LivingEntity e) {
        return new Vec3d(e.func_226277_ct_(), e.func_226278_cu_() + 0.5 * (double)e.func_70047_e(), e.func_226281_cx_());
    }

    protected Vec3d getGunPosition() {
        return new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.375, (double)this.field_174879_c.func_177952_p() + 0.5);
    }

    protected Vec3d getGunToTargetVec(LivingEntity target) {
        return this.getGunPosition().func_72444_a(this.getTargetVector(target));
    }

    @Nullable
    private LivingEntity getTarget() {
        double range = this.getRange();
        List list = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - range, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - range, (double)this.func_174877_v().func_177958_n() + range, (double)(this.func_174877_v().func_177956_o() + 3), (double)this.func_174877_v().func_177952_p() + range));
        if (list.isEmpty()) {
            return null;
        }
        for (LivingEntity entity : list) {
            if (!this.isValidTarget(entity, true)) continue;
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(LivingEntity entity, boolean checkCanShoot) {
        LivingEntity entityOwner;
        if (entity == null || !entity.func_70089_S() || entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (this.whitelist ^ this.isListedName(this.targetList, entity.func_200200_C_().getString())) {
            return false;
        }
        if (entity instanceof TameableEntity && (entityOwner = ((TameableEntity)entity).func_70902_q()) != null && this.whitelist ^ this.isListedName(this.targetList, entityOwner.func_200200_C_().getString())) {
            return false;
        }
        if (entity instanceof AnimalEntity && !this.attackAnimals) {
            return false;
        }
        if (entity instanceof PlayerEntity && !this.attackPlayers) {
            return false;
        }
        if (!(entity instanceof PlayerEntity || entity instanceof AnimalEntity || entity instanceof IMob || this.attackNeutrals)) {
            return false;
        }
        if (this.target == null || this.func_174877_v().func_218138_a((IPosition)entity.func_213303_ch(), true) < this.func_174877_v().func_218138_a((IPosition)this.target.func_213303_ch(), true)) {
            return true;
        }
        return !checkCanShoot || this.canShootEntity(entity);
    }

    private boolean isListedName(List<String> list, String name) {
        for (String s : list) {
            if (!name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected abstract double getRange();

    protected abstract boolean canActivate();

    protected abstract int getChargeupTicks();

    protected abstract int getActiveTicks();

    protected abstract boolean loopActivation();

    protected abstract void activate();

    protected boolean hasOwnerRights(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d || this.owner == null || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.func_200200_C_().getString());
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
        if (message.func_150297_b("add", 8)) {
            this.targetList.add(message.func_74779_i("add"));
        }
        if (message.func_150297_b("remove", 3)) {
            this.targetList.remove(message.func_74762_e("remove"));
        }
        if (message.func_150297_b("whitelist", 1)) {
            this.whitelist = message.func_74767_n("whitelist");
        }
        if (message.func_150297_b("attackAnimals", 1)) {
            this.attackAnimals = message.func_74767_n("attackAnimals");
        }
        if (message.func_150297_b("attackPlayers", 1)) {
            this.attackPlayers = message.func_74767_n("attackPlayers");
        }
        if (message.func_150297_b("attackNeutrals", 1)) {
            this.attackNeutrals = message.func_74767_n("attackNeutrals");
        }
        this.target = null;
        this.func_70296_d();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
        this.energyStorage.readFromNBT(nbt);
        if (nbt.func_150297_b("owner", 8)) {
            this.owner = nbt.func_74779_i("owner");
        }
        ListNBT list = nbt.func_150295_c("targetList", 8);
        this.targetList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.targetList.add(list.func_150307_f(i));
        }
        this.whitelist = nbt.func_74767_n("whitelist");
        this.attackAnimals = nbt.func_74767_n("attackAnimals");
        this.attackPlayers = nbt.func_74767_n("attackPlayers");
        this.attackNeutrals = nbt.func_74767_n("attackNeutrals");
        this.target = null;
        if (nbt.func_150297_b("target", 8)) {
            this.targetId = UUID.fromString(nbt.func_74779_i("target"));
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74757_a("redstoneInverted", this.redstoneControlInverted);
        this.energyStorage.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner);
        }
        ListNBT list = new ListNBT();
        for (String s : this.targetList) {
            list.add((Object)StringNBT.func_229705_a_((String)s));
        }
        nbt.func_218657_a("targetList", (INBT)list);
        nbt.func_74757_a("whitelist", this.whitelist);
        nbt.func_74757_a("attackAnimals", this.attackAnimals);
        nbt.func_74757_a("attackPlayers", this.attackPlayers);
        nbt.func_74757_a("attackNeutrals", this.attackNeutrals);
        if (this.target != null) {
            nbt.func_74778_a("target", this.target.func_110124_au().toString());
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        if (!this.isDummy()) {
            return VoxelShapes.func_197868_b();
        }
        switch (this.getFacing()) {
            case NORTH: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.0625, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return VoxelShapes.func_197873_a((double)0.125, (double)0.0625, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return VoxelShapes.func_197873_a((double)0.0, (double)0.0625, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public ActionResultType screwdriverUseSide(Direction side, PlayerEntity player, Hand hand, Vec3d hitVec) {
        if (this.isDummy()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (te instanceof TurretTileEntity) {
                return ((TurretTileEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return ActionResultType.FAIL;
        }
        if (player.func_225608_bj_() && !this.field_145850_b.field_72995_K) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.notOwner", new Object[]{this.owner})});
        return false;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        if (!this.isDummy()) {
            return this;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (te instanceof TurretTileEntity) {
            return (IEBlockInterfaces.IInteractionObjectIE)te;
        }
        return null;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        TileEntity te;
        if (this.isDummy() && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof TurretTileEntity) {
            return ((TurretTileEntity)te).canEntityDestroy(entity);
        }
        if (entity instanceof PlayerEntity) {
            return this.hasOwnerRights((PlayerEntity)entity);
        }
        return true;
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterTE != null) {
            return this.tempMasterTE;
        }
        BlockPos masterPos = this.func_174877_v().func_177977_b();
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), state);
        ((TurretTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())).setDummy(true);
        ((TurretTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterTE = this.master();
        if (this.field_145850_b.func_175625_s(this.isDummy() ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a()) instanceof TurretTileEntity) {
            this.field_145850_b.func_217377_a(this.isDummy() ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a(), false);
        }
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        Entity player = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c(), 1);
        TurretTileEntity turret = this;
        if (this.isDummy()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (t instanceof TurretTileEntity) {
                turret = (TurretTileEntity)t;
            } else {
                return ImmutableList.of((Object)stack);
            }
        }
        CompoundNBT tag = new CompoundNBT();
        if (!(turret.owner == null || player != null && player.func_200200_C_().getString().equalsIgnoreCase(turret.owner))) {
            tag.func_74778_a("owner", turret.owner);
        }
        if (turret.targetList.size() != 1 || !this.isListedName(turret.targetList, turret.owner)) {
            ListNBT list = new ListNBT();
            for (String s : turret.targetList) {
                list.add((Object)StringNBT.func_229705_a_((String)s));
            }
            tag.func_218657_a("targetList", (INBT)list);
        }
        if (turret.whitelist) {
            tag.func_74757_a("whitelist", turret.whitelist);
        }
        if (turret.attackAnimals) {
            tag.func_74757_a("attackAnimals", turret.attackAnimals);
        }
        if (!turret.attackPlayers) {
            tag.func_74757_a("attackPlayers", turret.attackPlayers);
        }
        if (turret.attackNeutrals) {
            tag.func_74757_a("attackNeutrals", turret.attackNeutrals);
        }
        if (turret.redstoneControlInverted) {
            tag.func_74757_a("redstoneControlInverted", turret.redstoneControlInverted);
        }
        if (!tag.isEmpty()) {
            stack.func_77982_d(tag);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(@Nullable LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_196082_o();
            if (tag.func_150297_b("owner", 8)) {
                this.owner = tag.func_74779_i("owner");
            } else if (placer != null) {
                this.owner = placer.func_200200_C_().getString();
            }
            if (tag.func_150297_b("targetList", 9)) {
                ListNBT list = tag.func_150295_c("targetList", 8);
                this.targetList.clear();
                for (int i = 0; i < list.size(); ++i) {
                    this.targetList.add(list.func_150307_f(i));
                }
            } else if (this.owner != null) {
                this.targetList.add(this.owner);
            }
            if (tag.func_150297_b("whitelist", 1)) {
                this.whitelist = tag.func_74767_n("whitelist");
            }
            if (tag.func_150297_b("attackAnimals", 1)) {
                this.attackAnimals = tag.func_74767_n("attackAnimals");
            }
            if (tag.func_150297_b("attackPlayers", 1)) {
                this.attackPlayers = tag.func_74767_n("attackPlayers");
            }
            if (tag.func_150297_b("attackNeutrals", 1)) {
                this.attackNeutrals = tag.func_74767_n("attackNeutrals");
            }
            if (tag.func_150297_b("redstoneControlInverted", 1)) {
                this.redstoneControlInverted = tag.func_74767_n("redstoneControlInverted");
            }
        } else if (placer != null) {
            this.owner = placer.func_200200_C_().getString();
            this.targetList.add(this.owner);
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.isDummy() && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof TurretTileEntity) {
            return ((TurretTileEntity)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return !this.isDummy() ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (!this.isDummy()) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    @Override
    public IEProperties.VisibilityList compileDisplayList(BlockState state) {
        return displayList;
    }

    public void setDummy(boolean dummy) {
        BlockState old = this.func_195044_w();
        BlockState newState = (BlockState)old.func_206870_a((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(dummy));
        this.field_145850_b.func_175656_a(this.field_174879_c, newState);
    }

    @Override
    public BlockPos getModelOffset(BlockState state) {
        if (this.isDummy()) {
            return new BlockPos(0, 1, 0);
        }
        return BlockPos.field_177992_a;
    }
}

