/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class UnionMultiblock
implements MultiblockHandler.IMultiblock {
    private final ResourceLocation name;
    private final List<TransformedMultiblock> parts;

    public UnionMultiblock(ResourceLocation name, List<TransformedMultiblock> parts) {
        this.name = name;
        this.parts = parts;
    }

    @Override
    public ResourceLocation getUniqueName() {
        return this.name;
    }

    @Override
    public boolean isBlockTrigger(BlockState state, Direction d) {
        return false;
    }

    @Override
    public boolean createStructure(World world, BlockPos pos, Direction side, PlayerEntity player) {
        return false;
    }

    @Override
    public List<Template.BlockInfo> getStructure(@Nullable World world) {
        Vec3i min = this.getMin(world);
        ArrayList<Template.BlockInfo> ret = new ArrayList<Template.BlockInfo>();
        for (TransformedMultiblock part : this.parts) {
            for (Template.BlockInfo i : part.multiblock.getStructure(world)) {
                ret.add(new Template.BlockInfo(part.toUnionCoords((Vec3i)i.field_186242_a).func_177973_b(min), i.field_186243_b, i.field_186244_c));
            }
        }
        return ret;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (TransformedMultiblock part : this.parts) {
            for (ItemStack stack : part.multiblock.getTotalMaterials()) {
                boolean added = false;
                for (ItemStack ex : ret) {
                    if (!ex.equals(stack)) continue;
                    ex.func_190917_f(stack.func_190916_E());
                    added = true;
                    break;
                }
                if (added) continue;
                ret.add(stack.func_77946_l());
            }
        }
        return ret.toArray(new ItemStack[0]);
    }

    @Override
    public boolean overwriteBlockRender(BlockState state, int iterator) {
        return false;
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public boolean canRenderFormedStructure() {
        return false;
    }

    @Override
    public void renderFormedStructure(MatrixStack transform, IRenderTypeBuffer buffer) {
    }

    @Override
    public Vec3i getSize(@Nullable World world) {
        Vec3i max = Vec3i.field_177959_e;
        for (TransformedMultiblock part : this.parts) {
            max = this.max(max, (Vec3i)part.toUnionCoords(part.multiblock.getSize(world)));
        }
        Vec3i min = this.getMin(world);
        return new Vec3i(max.func_177958_n() - min.func_177958_n(), max.func_177956_o() - min.func_177956_o(), max.func_177952_p() - min.func_177952_p());
    }

    private Vec3i getMin(@Nullable World world) {
        Vec3i min = Vec3i.field_177959_e;
        for (TransformedMultiblock part : this.parts) {
            Vec3i size = part.multiblock.getSize(world);
            for (int factorX = 0; factorX < 2; ++factorX) {
                for (int factorY = 0; factorY < 2; ++factorY) {
                    for (int factorZ = 0; factorZ < 2; ++factorZ) {
                        min = this.min(min, (Vec3i)part.toUnionCoords(new Vec3i(size.func_177958_n() * factorX, size.func_177956_o() * factorY, size.func_177952_p() * factorZ)));
                    }
                }
            }
        }
        return min;
    }

    private Vec3i min(Vec3i a, Vec3i b) {
        return new Vec3i(Math.min(a.func_177958_n(), b.func_177958_n()), Math.min(a.func_177956_o(), b.func_177956_o()), Math.min(a.func_177952_p(), b.func_177952_p()));
    }

    private Vec3i max(Vec3i a, Vec3i b) {
        return new Vec3i(Math.max(a.func_177958_n(), b.func_177958_n()), Math.max(a.func_177956_o(), b.func_177956_o()), Math.max(a.func_177952_p(), b.func_177952_p()));
    }

    @Override
    public void disassemble(World world, BlockPos startPos, boolean mirrored, Direction clickDirectionAtCreation) {
    }

    @Override
    public BlockPos getTriggerOffset() {
        return BlockPos.field_177992_a;
    }

    public static class TransformedMultiblock {
        private final MultiblockHandler.IMultiblock multiblock;
        private final Vec3i offset;
        private final Rotation rotation;

        public TransformedMultiblock(MultiblockHandler.IMultiblock multiblock, Vec3i offset, Rotation rotation) {
            this.multiblock = multiblock;
            this.offset = offset;
            this.rotation = rotation;
        }

        public BlockPos toUnionCoords(Vec3i inMultiblockCoords) {
            return Template.func_186266_a((PlacementSettings)new PlacementSettings().func_186220_a(this.rotation), (BlockPos)new BlockPos(inMultiblockCoords)).func_177971_a(this.offset);
        }
    }
}

