/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.wooden.CrateBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WoodenCrateTileEntity
extends IEBaseTileEntity
implements IIEInventory,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public ResourceLocation lootTable;
    public String name;
    private ListNBT enchantments;
    private LazyOptional<IItemHandler> insertionCap = this.registerConstantCap(new IEInventoryHandler(27, this));

    public WoodenCrateTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.WOODEN_CRATE.get()));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (nbt.func_150297_b("name", 8)) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_150297_b("enchantments", 9)) {
            this.enchantments = nbt.func_150295_c("enchantments", 10);
        }
        if (!descPacket) {
            if (nbt.func_150297_b("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.func_74779_i("lootTable"));
            } else {
                this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 27);
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            nbt.func_218657_a("enchantments", (INBT)this.enchantments);
        }
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.func_74778_a("lootTable", this.lootTable.toString());
            } else {
                this.writeInv(nbt, false);
            }
        }
    }

    public void writeInv(CompoundNBT nbt, boolean toItem) {
        boolean write = false;
        ListNBT invList = new ListNBT();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            if (toItem) {
                write = true;
            }
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(itemTag);
            invList.add((Object)itemTag);
        }
        if (!toItem || write) {
            nbt.func_218657_a("inventory", (INBT)invList);
        }
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        if (this.name != null) {
            return new StringTextComponent(this.name);
        }
        Block b = this.func_195044_w().func_177230_c();
        if (b instanceof CrateBlock && ((CrateBlock)b).isReinforced()) {
            return new TranslationTextComponent("block.immersiveengineering.reinforced_crate", new Object[0]);
        }
        return new TranslationTextComponent("block.immersiveengineering.crate", new Object[0]);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return true;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return this;
    }

    @Override
    @Nonnull
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)this.field_145850_b);
            contextBuilder.func_216015_a(LootParameters.field_216286_f, (Object)this.field_174879_c);
            if (player != null) {
                contextBuilder.func_186469_a(player.func_184817_da());
            }
            LootContext context = contextBuilder.func_216022_a(LootParameterSets.field_216261_b);
            Random rand = new Random();
            List list = loottable.func_216113_a(context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (!listSlots.isEmpty()) {
                Utils.shuffleLootItems(list, listSlots.size(), rand);
                for (ItemStack itemstack : list) {
                    int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                    this.inventory.set(slot, (Object)itemstack);
                }
                this.func_70296_d();
            }
        }
        return IEBlockInterfaces.IInteractionObjectIE.super.createMenu(id, playerInventory, player);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c(), 1);
        CompoundNBT tag = new CompoundNBT();
        this.writeInv(tag, true);
        if (!tag.isEmpty()) {
            stack.func_77982_d(tag);
        }
        if (this.name != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(this.name));
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            stack.func_196082_o().func_218657_a("ench", (INBT)this.enchantments);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_196082_o(), false);
            if (stack.func_82837_s()) {
                this.name = stack.func_200301_q().getString();
            }
            this.enchantments = stack.func_77986_q();
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionCap.cast();
        }
        return super.getCapability(capability, facing);
    }
}

