/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class ArcRecyclingThreadHandler
extends Thread {
    private static ArcRecyclingThreadHandler runningHandler;
    private ArrayList<RecyclingCalculation> validated;
    private ArrayListMultimap<ItemStack, RecyclingCalculation> nonValidated;
    private final List<IRecipe<?>> recipeList;

    public ArcRecyclingThreadHandler(Collection<IRecipe<?>> allRecipes) {
        this.recipeList = allRecipes.stream().filter(ArcFurnaceRecipe.assembleRecyclingFilter()).collect(Collectors.toList());
        runningHandler = this;
    }

    @Override
    public void run() {
        int threadAmount = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        RegistryIterationThread[] threads = new RegistryIterationThread[threadAmount];
        long timestamp = System.currentTimeMillis();
        boolean divisable = this.recipeList.size() % threadAmount == 0;
        int limit = divisable ? this.recipeList.size() / threadAmount : this.recipeList.size() / (threadAmount - 1);
        int leftOver = divisable ? limit : this.recipeList.size() - (threadAmount - 1) * limit;
        for (int i = 0; i < threadAmount; ++i) {
            threads[i] = new RegistryIterationThread(this.recipeList, limit * i, i == threadAmount - 1 ? leftOver : limit);
        }
        this.validated = new ArrayList();
        this.nonValidated = ArrayListMultimap.create();
        int invalidCount = 0;
        for (RegistryIterationThread thread : threads) {
            try {
                thread.join();
                for (RecyclingCalculation calc : thread.calculatedOutputs) {
                    if (calc.isValid()) {
                        this.validated.add(calc);
                        continue;
                    }
                    for (ItemStack s : calc.queriedSubcomponents.keySet()) {
                        this.nonValidated.put((Object)s, (Object)calc);
                    }
                    ++invalidCount;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int timeout = 0;
        while (!this.nonValidated.isEmpty() && timeout++ < invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : this.validated) {
                for (ItemStack key : this.nonValidated.keySet()) {
                    if (!ItemStack.func_179545_c((ItemStack)key, (ItemStack)valid.stack)) continue;
                    for (RecyclingCalculation nonValid : this.nonValidated.get((Object)key)) {
                        if (!nonValid.validateSubcomponent(valid)) continue;
                        newlyValid.add(nonValid);
                    }
                }
            }
            if (newlyValid.isEmpty()) break;
            this.nonValidated.values().removeAll(newlyValid);
            this.validated.addAll(newlyValid);
        }
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - timestamp) + " milliseconds");
    }

    private ArcRecyclingRecipe makeRecipe(RecyclingCalculation calculation) {
        ResourceLocation id = new ResourceLocation("immersiveengineering", "recycling/" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)calculation.stack.func_77973_b()).func_110623_a());
        return new ArcRecyclingRecipe(id, calculation.outputs, IngredientWithSize.of(calculation.stack), 100, 51200);
    }

    public static List<ArcFurnaceRecipe> getRecipesFromRunningThreads() {
        ArcRecyclingThreadHandler handler = (ArcRecyclingThreadHandler)Preconditions.checkNotNull((Object)runningHandler);
        try {
            handler.join();
            HashSet<String> finishedRecycles = new HashSet<String>();
            ArrayList<ArcFurnaceRecipe> generatedRecipes = new ArrayList<ArcFurnaceRecipe>();
            for (RecyclingCalculation valid : handler.validated) {
                if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
                generatedRecipes.add(handler.makeRecipe(valid));
            }
            for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)handler.nonValidated.values())) {
                if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
                IELogger.info("Couldn't fully analyze " + invalid.stack + ", missing knowledge for " + invalid.queriedSubcomponents);
                generatedRecipes.add(handler.makeRecipe(invalid));
            }
            return generatedRecipes;
        }
        catch (InterruptedException x) {
            return ImmutableList.of();
        }
    }

    public static RecyclingCalculation getRecycleCalculation(ItemStack stack, IRecipe<?> recipe) {
        Pair<ItemStack, Double> brokenDown = ApiUtils.breakStackIntoPreciseIngots(stack);
        if (brokenDown != null && ArcFurnaceRecipe.isValidRecyclingOutput((ItemStack)brokenDown.getLeft()) && (Double)brokenDown.getRight() > 0.0) {
            return new RecyclingCalculation(recipe, Utils.copyStackWithAmount(stack, 1), (Map<ItemStack, Double>)ImmutableMap.of((Object)brokenDown.getLeft(), (Object)brokenDown.getRight()));
        }
        NonNullList inputs = recipe.func_192400_c();
        if (!inputs.isEmpty()) {
            int resultCount = stack.func_190916_E();
            HashMap<ItemStack, Integer> missingSub = new HashMap<ItemStack, Integer>();
            IdentityHashMap<ItemStack, Object> outputs = new IdentityHashMap<ItemStack, Object>();
            for (Object in : inputs) {
                boolean invalidOutput;
                if (in == null || in == Ingredient.field_193370_a) continue;
                ItemStack itemStack = IEApi.getPreferredStackbyMod(in.func_193365_a());
                if (itemStack.func_190926_b()) {
                    IELogger.warn("Recipe has invalid inputs and will be ignored: " + recipe + " (" + recipe.func_199560_c() + ")");
                    return null;
                }
                brokenDown = ApiUtils.breakStackIntoPreciseIngots(itemStack);
                if (brokenDown == null) {
                    if (!ArcFurnaceRecipe.canRecycle(itemStack) || !ArcFurnaceRecipe.isValidRecyclingOutput(itemStack)) continue;
                    boolean b = false;
                    for (ItemStack storedMiss : missingSub.keySet()) {
                        if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)storedMiss)) continue;
                        missingSub.put(storedMiss, (Integer)missingSub.get(storedMiss) + itemStack.func_190916_E());
                        b = true;
                    }
                    if (b) continue;
                    missingSub.put(Utils.copyStackWithAmount(itemStack, 1), itemStack.func_190916_E());
                    continue;
                }
                if (((ItemStack)brokenDown.getLeft()).func_190926_b() || !((Double)brokenDown.getRight() > 0.0) || (invalidOutput = !ArcFurnaceRecipe.isValidRecyclingOutput((ItemStack)brokenDown.getLeft()))) continue;
                boolean b = false;
                for (ItemStack storedOut : outputs.keySet()) {
                    if (!ItemStack.func_179545_c((ItemStack)((ItemStack)brokenDown.getLeft()), (ItemStack)storedOut)) continue;
                    outputs.put(storedOut, (Double)outputs.get(storedOut) + (Double)brokenDown.getRight());
                    b = true;
                }
                if (b) continue;
                outputs.put(Utils.copyStackWithAmount((ItemStack)brokenDown.getLeft(), 1), brokenDown.getRight());
            }
            IdentityHashMap<ItemStack, Double> outputScaled = new IdentityHashMap<ItemStack, Double>(outputs.size());
            for (Map.Entry entry : outputs.entrySet()) {
                outputScaled.put((ItemStack)entry.getKey(), (Double)entry.getValue() / (double)resultCount);
            }
            if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                Object in;
                in = Utils.copyStackWithAmount(stack, 1);
                RecyclingCalculation recyclingCalculation = new RecyclingCalculation(recipe, (ItemStack)in, outputScaled);
                if (!missingSub.isEmpty()) {
                    for (ItemStack s : missingSub.keySet()) {
                        recyclingCalculation.queriedSubcomponents.put(s, (double)((Integer)missingSub.get(s)).intValue() / (double)resultCount);
                    }
                }
                return recyclingCalculation;
            }
        }
        return null;
    }

    public static class RecyclingCalculation {
        IRecipe<?> recipe;
        ItemStack stack;
        Map<ItemStack, Double> outputs;
        Map<ItemStack, Double> queriedSubcomponents = new HashMap<ItemStack, Double>();

        public RecyclingCalculation(IRecipe<?> recipe, ItemStack stack, Map<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.keySet().iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!ItemStack.func_179545_c((ItemStack)next, (ItemStack)calc.stack)) continue;
                double queriedAmount = this.queriedSubcomponents.get(next);
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    double scaledVal = e.getValue() * queriedAmount;
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!ItemStack.func_179545_c((ItemStack)key, (ItemStack)e.getKey())) continue;
                        this.outputs.put(key, this.outputs.get(key) + scaledVal);
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), scaledVal);
                }
                it.remove();
            }
            return this.isValid();
        }
    }

    public static class RegistryIterationThread
    extends Thread {
        final List<IRecipe<?>> recipeList;
        final int baseOffset;
        final int passes;
        ArrayList<RecyclingCalculation> calculatedOutputs = new ArrayList();

        public RegistryIterationThread(List<IRecipe<?>> recipeList, int baseOffset, int passes) {
            this.setName("Immersive Engineering Registry Iteration Thread");
            this.setDaemon(true);
            this.start();
            this.recipeList = recipeList;
            this.baseOffset = baseOffset;
            this.passes = passes;
        }

        @Override
        public void run() {
            for (int pass = 0; pass < this.passes; ++pass) {
                IRecipe<?> recipe = this.recipeList.get(this.baseOffset + pass);
                RecyclingCalculation calc = ArcRecyclingThreadHandler.getRecycleCalculation(recipe.func_77571_b(), recipe);
                if (calc == null) continue;
                this.calculatedOutputs.add(calc);
            }
        }
    }
}

