/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShaderBagRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;

    public ShaderBagRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (stack.func_190926_b()) {
                if (IEItems.Misc.shaderBag.containsValue(stackInSlot.func_77973_b())) {
                    stack = stackInSlot;
                    continue;
                }
                return false;
            }
            return false;
        }
        return !stack.func_190926_b();
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            Rarity next = ShaderRegistry.getLowerRarity(stackInSlot.func_77953_t());
            ItemStack output = new ItemStack((IItemProvider)IEItems.Misc.shaderBag.get(next), next != stackInSlot.func_77953_t() ? 2 : 1);
            if (next == null) continue;
            ItemNBTHelper.putString(output, "rarity", next.toString());
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)IEItems.Misc.shaderBag.get(Rarity.COMMON), 2);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.SHADER_BAG_SERIALIZER.get();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

