/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CrusherRecipeSerializer
extends IERecipeSerializer<CrusherRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.crusher);
    }

    @Override
    public CrusherRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack output = this.readOutput(json.get("result"));
        Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        JsonArray array = json.getAsJsonArray("secondaries");
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        CrusherRecipe recipe = IEConfig.MACHINES.crusherConfig.apply(new CrusherRecipe(recipeId, output, input, energy));
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions")) continue;
            float chance = JSONUtils.func_151217_k((JsonObject)element, (String)"chance");
            ItemStack stack = this.readOutput(element.get("output"));
            recipe.addToSecondaryOutput(new StackWithChance(stack, chance));
        }
        return recipe;
    }

    @Nullable
    public CrusherRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack output = buffer.func_150791_c();
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        int energy = buffer.readInt();
        int secondaryCount = buffer.readInt();
        CrusherRecipe recipe = new CrusherRecipe(recipeId, output, input, energy);
        for (int i = 0; i < secondaryCount; ++i) {
            recipe.addToSecondaryOutput(StackWithChance.read(buffer));
        }
        return recipe;
    }

    public void write(PacketBuffer buffer, CrusherRecipe recipe) {
        buffer.func_150788_a(recipe.output);
        recipe.input.func_199564_a(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeInt(recipe.secondaryOutputs.size());
        for (StackWithChance secondaryOutput : recipe.secondaryOutputs) {
            secondaryOutput.write(buffer);
        }
    }
}

