/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.data.BlockStates;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.data.models.LoadedModelBuilder;
import blusunrize.immersiveengineering.common.data.models.LoadedModelProvider;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;

public class ItemModels
extends LoadedModelProvider {
    BlockStates blockStates;

    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper, BlockStates blockStates) {
        super(generator, "immersiveengineering", "item", existingFileHelper);
        this.blockStates = blockStates;
    }

    private ResourceLocation forgeLoc(String s) {
        return new ResourceLocation("forge", s);
    }

    protected void registerModels() {
        for (Map.Entry<Block, ModelFile> model : this.blockStates.itemModels.entrySet()) {
            this.getBuilder((IItemProvider)model.getKey()).parent(model.getValue());
        }
        for (EnumMetals m : EnumMetals.values()) {
            this.createMetalModels(m);
        }
        this.createItemModels();
        this.createMetalModels();
        this.createWoodenModels();
        this.createStoneModels();
        this.createClothModels();
        this.createConnectorModels();
    }

    private void createMetalModels() {
        this.cubeBottomTop(this.name((IItemProvider)IEBlocks.MetalDevices.barrel), IEDataGenerator.rl("block/metal_device/barrel_side"), IEDataGenerator.rl("block/metal_device/barrel_up_none"), IEDataGenerator.rl("block/metal_device/barrel_up_none"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.MetalDecoration.steelPost, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/metal_decoration/steel_post"))).transforms(this.modLoc("item/post"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.MetalDecoration.aluPost, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/metal_decoration/aluminum_post"))).transforms(this.modLoc("item/post"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.cloche, IEDataGenerator.rl("block/metal_device/cloche.obj.ie")).transforms(IEDataGenerator.rl("item/cloche"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.teslaCoil, IEDataGenerator.rl("block/metal_device/teslacoil.obj")).transforms(IEDataGenerator.rl("item/teslacoil"));
        for (Map.Entry<EnumMetals, Block> chute : IEBlocks.MetalDevices.chutes.entrySet()) {
            ((LoadedModelBuilder)this.obj((IItemProvider)chute.getValue(), IEDataGenerator.rl("block/metal_device/chute_inv.obj")).texture("texture", this.modLoc("block/metal/sheetmetal_" + chute.getKey().tagName()))).transforms(IEDataGenerator.rl("item/block"));
        }
        this.obj((IItemProvider)IEBlocks.MetalDevices.turretChem, IEDataGenerator.rl("block/metal_device/chem_turret_inv.obj")).transforms(IEDataGenerator.rl("item/turret"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.turretGun, IEDataGenerator.rl("block/metal_device/gun_turret_inv.obj")).transforms(IEDataGenerator.rl("item/turret"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.fluidPipe, IEDataGenerator.rl("block/metal_device/fluid_pipe.obj.ie")).transforms(IEDataGenerator.rl("item/block"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.fluidPump, IEDataGenerator.rl("block/metal_device/fluid_pump_inv.obj")).transforms(IEDataGenerator.rl("item/fluid_pump"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.blastFurnacePreheater, IEDataGenerator.rl("block/metal_device/blastfurnace_preheater.obj")).transforms(IEDataGenerator.rl("item/blastfurnace_preheater"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.sampleDrill, IEDataGenerator.rl("block/metal_device/core_drill.obj")).transforms(IEDataGenerator.rl("item/sampledrill"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.metalPress, IEDataGenerator.rl("block/metal_multiblock/metal_press.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.crusher, IEDataGenerator.rl("block/metal_multiblock/crusher.obj")).transforms(IEDataGenerator.rl("item/crusher"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.sawmill, IEDataGenerator.rl("block/metal_multiblock/sawmill.obj")).transforms(IEDataGenerator.rl("item/crusher"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.tank, IEDataGenerator.rl("block/metal_multiblock/tank.obj")).transforms(IEDataGenerator.rl("item/tank"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.silo, IEDataGenerator.rl("block/metal_multiblock/silo.obj")).transforms(IEDataGenerator.rl("item/silo"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.assembler, IEDataGenerator.rl("block/metal_multiblock/assembler.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.autoWorkbench, IEDataGenerator.rl("block/metal_multiblock/auto_workbench.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.bottlingMachine, IEDataGenerator.rl("block/metal_multiblock/bottling_machine.obj.ie")).transforms(IEDataGenerator.rl("item/bottling_machine"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.squeezer, IEDataGenerator.rl("block/metal_multiblock/squeezer.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.fermenter, IEDataGenerator.rl("block/metal_multiblock/fermenter.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.refinery, IEDataGenerator.rl("block/metal_multiblock/refinery.obj")).transforms(IEDataGenerator.rl("item/refinery"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.dieselGenerator, IEDataGenerator.rl("block/metal_multiblock/diesel_generator.obj")).transforms(IEDataGenerator.rl("item/crusher"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.excavator, IEDataGenerator.rl("block/metal_multiblock/excavator.obj")).transforms(IEDataGenerator.rl("item/excavator"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.bucketWheel, IEDataGenerator.rl("block/metal_multiblock/bucket_wheel.obj.ie")).transforms(IEDataGenerator.rl("item/bucket_wheel"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.arcFurnace, IEDataGenerator.rl("block/metal_multiblock/arc_furnace.obj")).transforms(IEDataGenerator.rl("item/arc_furnace"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.lightningrod, IEDataGenerator.rl("block/metal_multiblock/lightningrod.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.mixer, IEDataGenerator.rl("block/metal_multiblock/mixer.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.MetalDecoration.aluWallmount, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/metal_decoration/aluminum_wallmount"))).transforms(this.modLoc("item/wallmount"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.MetalDecoration.steelWallmount, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/metal_decoration/steel_wallmount"))).transforms(this.modLoc("item/wallmount"));
        for (Block b : IEBlocks.MetalDevices.CONVEYORS.values()) {
            this.getBuilder((IItemProvider)b).loader(ModelConveyor.ConveyorLoader.LOCATION);
        }
        this.obj((IItemProvider)IEBlocks.MetalDecoration.lantern, this.modLoc("block/lantern_inventory.obj")).transforms(this.modLoc("item/block"));
        this.addLayeredItemModel(IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE).func_199767_j(), IEDataGenerator.rl("block/metal_decoration/metal_ladder"));
    }

    private void createWoodenModels() {
        this.obj((IItemProvider)IEBlocks.WoodenDevices.craftingTable, IEDataGenerator.rl("block/wooden_device/craftingtable.obj")).transforms(IEDataGenerator.rl("item/block"));
        this.cubeBottomTop(this.name((IItemProvider)IEBlocks.WoodenDevices.woodenBarrel), IEDataGenerator.rl("block/wooden_device/barrel_side"), IEDataGenerator.rl("block/wooden_device/barrel_up_none"), IEDataGenerator.rl("block/wooden_device/barrel_up_none"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.WoodenDecoration.treatedPost, this.modLoc("block/wooden_device/wooden_post_inv.obj")).texture("post", this.modLoc("block/wooden_decoration/post"))).transforms(this.modLoc("item/post"));
        this.obj((IItemProvider)IEBlocks.WoodenDevices.workbench, IEDataGenerator.rl("block/wooden_device/workbench.obj.ie")).transforms(IEDataGenerator.rl("item/workbench"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.WoodenDevices.treatedWallmount, this.modLoc("block/wooden_device/wallmount.obj")).texture("texture", this.modLoc("block/wooden_device/wallmount"))).transforms(this.modLoc("item/wallmount"));
        this.obj((IItemProvider)IEBlocks.WoodenDevices.watermill, this.modLoc("block/wooden_device/watermill.obj.ie")).transforms(this.modLoc("item/watermill"));
        this.obj((IItemProvider)IEBlocks.WoodenDevices.windmill, this.modLoc("block/wooden_device/windmill.obj.ie")).transforms(this.modLoc("item/windmill"));
    }

    private void createClothModels() {
        this.withExistingParent(this.name((IItemProvider)IEBlocks.Cloth.curtain), IEDataGenerator.rl("block/stripcurtain")).transforms(IEDataGenerator.rl("item/stripcurtain"));
        this.obj((IItemProvider)IEBlocks.Cloth.balloon, IEDataGenerator.rl("block/balloon.obj.ie")).transforms(IEDataGenerator.rl("item/block"));
    }

    private void createItemModels() {
        this.addItemModels("metal_", (Item[])IEItems.Metals.ingots.values().stream().filter(i -> "immersiveengineering".equals(i.getRegistryName().func_110624_b())).toArray(Item[]::new));
        this.addItemModels("metal_", (Item[])IEItems.Metals.nuggets.values().stream().filter(i -> "immersiveengineering".equals(i.getRegistryName().func_110624_b())).toArray(Item[]::new));
        this.addItemModels("metal_", IEItems.Metals.dusts.values().toArray(new Item[IEItems.Metals.ingots.size()]));
        this.addItemModels("metal_", IEItems.Metals.plates.values().toArray(new Item[IEItems.Metals.ingots.size()]));
        for (Item item : IEItems.Misc.shaderBag.values()) {
            this.addItemModel("shader_bag", item);
        }
        this.addItemModels("material_", IEItems.Ingredients.stickTreated, IEItems.Ingredients.stickIron, IEItems.Ingredients.stickSteel, IEItems.Ingredients.stickAluminum, IEItems.Ingredients.hempFiber, IEItems.Ingredients.hempFabric, IEItems.Ingredients.coalCoke, IEItems.Ingredients.slag, IEItems.Ingredients.componentIron, IEItems.Ingredients.componentSteel, IEItems.Ingredients.waterwheelSegment, IEItems.Ingredients.windmillBlade, IEItems.Ingredients.windmillSail, IEItems.Ingredients.woodenGrip, IEItems.Ingredients.gunpartBarrel, IEItems.Ingredients.gunpartDrum, IEItems.Ingredients.gunpartHammer, IEItems.Ingredients.dustCoke, IEItems.Ingredients.dustHopGraphite, IEItems.Ingredients.ingotHopGraphite, IEItems.Ingredients.wireCopper, IEItems.Ingredients.wireElectrum, IEItems.Ingredients.wireAluminum, IEItems.Ingredients.wireSteel, IEItems.Ingredients.dustSaltpeter, IEItems.Ingredients.dustSulfur, IEItems.Ingredients.dustWood, IEItems.Ingredients.electronTube, IEItems.Ingredients.circuitBoard);
        this.addItemModels("tool_", this.mcLoc("item/handheld"), IEItems.Tools.hammer, IEItems.Tools.wirecutter, IEItems.Tools.screwdriver, IEItems.Tools.manual, IEItems.Tools.steelPick, IEItems.Tools.steelShovel, IEItems.Tools.steelAxe, IEItems.Tools.steelHoe, IEItems.Tools.steelSword);
        this.addItemModels("", IEItems.Tools.surveyTools);
        this.addItemModels("", IEItems.Misc.wireCoils.values().toArray(new Item[0]));
        this.addItemModels("", IEItems.Misc.graphiteElectrode);
        this.addItemModels("", IEItems.Misc.toolUpgrades.values().toArray(new Item[0]));
        this.addItemModels("", IEItems.Molds.moldPlate, IEItems.Molds.moldGear, IEItems.Molds.moldRod, IEItems.Molds.moldBulletCasing, IEItems.Molds.moldWire, IEItems.Molds.moldPacking4, IEItems.Molds.moldPacking9, IEItems.Molds.moldUnpacking);
        this.addItemModels("bullet_", IEItems.Ingredients.emptyCasing, IEItems.Ingredients.emptyShell);
        for (Map.Entry entry : IEItems.Weapons.bullets.entrySet()) {
            this.addLayeredItemModel((Item)entry.getValue(), ((BulletHandler.IBullet)entry.getKey()).getTextures());
        }
        this.addItemModels("", IEItems.Misc.faradaySuit.values());
        this.addItemModels("", IEItems.Tools.steelArmor.values());
        this.addItemModel("blueprint", IEItems.Misc.blueprint);
        this.addItemModel("seed_hemp", IEItems.Misc.hempSeeds);
        this.addItemModel("drillhead_iron", IEItems.Tools.drillheadIron);
        this.addItemModel("drillhead_steel", IEItems.Tools.drillheadSteel);
        this.addItemModels("", IEItems.Tools.sawblade, IEItems.Tools.rockcutter);
        this.addItemModels("", IEItems.Misc.maintenanceKit);
        this.addItemModels("", IEItems.Misc.cartWoodenCrate, IEItems.Misc.cartReinforcedCrate, IEItems.Misc.cartWoodenBarrel, IEItems.Misc.cartMetalBarrel);
        this.addItemModels("", IEItems.Misc.iconBirthday, IEItems.Misc.iconLucky, IEItems.Misc.iconDrillbreak, IEItems.Misc.iconRavenholm);
        this.obj((IItemProvider)IEItems.Tools.voltmeter, IEDataGenerator.rl("item/voltmeter.obj")).transforms(IEDataGenerator.rl("item/voltmeter"));
        this.obj((IItemProvider)IEItems.Tools.toolbox, IEDataGenerator.rl("item/toolbox.obj")).transforms(IEDataGenerator.rl("item/toolbox"));
        this.ieObj((IItemProvider)IEItems.Misc.shield, IEDataGenerator.rl("item/shield.obj.ie")).transforms(IEDataGenerator.rl("item/shield"));
        this.ieObj((IItemProvider)IEItems.Weapons.revolver, this.modLoc("item/revolver.obj.ie")).transforms(this.modLoc("item/revolver")).additional("dynamic", true);
        this.ieObj((IItemProvider)IEItems.Tools.drill, this.modLoc("item/drill/drill_diesel.obj.ie")).transforms(this.modLoc("item/drill")).additional("dynamic", true);
        this.ieObj((IItemProvider)IEItems.Tools.buzzsaw, this.modLoc("item/buzzsaw_diesel.obj.ie")).transforms(this.modLoc("item/buzzsaw")).additional("dynamic", true);
        this.ieObj((IItemProvider)IEItems.Weapons.railgun, this.modLoc("item/railgun.obj.ie")).transforms(this.modLoc("item/railgun"));
        this.ieObj((IItemProvider)IEItems.Weapons.chemthrower, this.modLoc("item/chemthrower.obj.ie")).transforms(this.modLoc("item/chemthrower"));
        for (IEFluid iEFluid : IEFluid.IE_FLUIDS) {
            this.createBucket((Fluid)iEFluid);
        }
        this.ieObj((IItemProvider)IEItems.Misc.fluorescentTube, IEDataGenerator.rl("item/fluorescent_tube.obj.ie")).transforms(this.modLoc("item/fluorescent_tube"));
        this.getBuilder((IItemProvider)IEItems.Misc.coresample).loader(ModelCoresample.CoresampleLoader.LOCATION);
    }

    private void createBucket(Fluid f) {
        this.getBuilder((IItemProvider)f.func_204524_b()).loader(this.forgeLoc("bucket")).additional("fluid", f.getRegistryName()).parent((ModelFile)new ModelFile.UncheckedModelFile(this.forgeLoc("item/bucket")));
    }

    private void createStoneModels() {
        this.obj((IItemProvider)IEBlocks.StoneDecoration.concreteSprayed, IEDataGenerator.rl("block/sprayed_concrete.obj")).transforms(IEDataGenerator.rl("item/block"));
        ((LoadedModelBuilder)this.getBuilder((IItemProvider)IEBlocks.Multiblocks.alloySmelter).parent(this.blockStates.alloySmelterOn)).transforms(IEDataGenerator.rl("item/alloysmelter"));
        ((LoadedModelBuilder)this.getBuilder((IItemProvider)IEBlocks.Multiblocks.blastFurnace).parent(this.blockStates.blastFurnaceOn)).transforms(IEDataGenerator.rl("item/blastfurnace"));
        ((LoadedModelBuilder)this.getBuilder((IItemProvider)IEBlocks.Multiblocks.cokeOven).parent(this.blockStates.cokeOvenOn)).transforms(IEDataGenerator.rl("item/blastfurnace"));
        this.obj((IItemProvider)IEBlocks.Multiblocks.blastFurnaceAdv, IEDataGenerator.rl("block/blastfurnace_advanced.obj")).transforms(IEDataGenerator.rl("item/multiblock"));
    }

    private void createConnectorModels() {
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", false), IEDataGenerator.rl("block/connector/connector_lv.obj")).texture("texture", this.modLoc("block/connector/connector_lv"))).transforms(IEDataGenerator.rl("item/connector"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("LV", true), IEDataGenerator.rl("block/connector/connector_lv.obj")).texture("texture", this.modLoc("block/connector/relay_lv"))).transforms(IEDataGenerator.rl("item/connector"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", false), IEDataGenerator.rl("block/connector/connector_mv.obj")).texture("texture", this.modLoc("block/connector/connector_mv"))).transforms(IEDataGenerator.rl("item/connector"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("MV", true), IEDataGenerator.rl("block/connector/connector_mv.obj")).texture("texture", this.modLoc("block/connector/relay_mv"))).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", false), IEDataGenerator.rl("block/connector/connector_hv.obj")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.getEnergyConnector("HV", true), IEDataGenerator.rl("block/connector/relay_hv.obj")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.connectorRedstone, IEDataGenerator.rl("block/connector/connector_redstone.obj.ie")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.connectorProbe, IEDataGenerator.rl("block/connector/connector_probe.obj.ie")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.connectorBundled, IEDataGenerator.rl("block/connector/connector_bundled.obj")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.connectorStructural, IEDataGenerator.rl("block/connector/connector_structural.obj.ie")).transforms(IEDataGenerator.rl("item/connector"));
        this.obj((IItemProvider)IEBlocks.Connectors.transformer, IEDataGenerator.rl("block/connector/transformer_mv_left.obj")).transforms(IEDataGenerator.rl("item/transformer"));
        this.obj((IItemProvider)IEBlocks.Connectors.transformerHV, IEDataGenerator.rl("block/connector/transformer_hv_left.obj")).transforms(IEDataGenerator.rl("item/transformer"));
        this.obj((IItemProvider)IEBlocks.Connectors.redstoneBreaker, IEDataGenerator.rl("block/connector/redstone_breaker.obj.ie")).transforms(IEDataGenerator.rl("item/redstone_breaker"));
        this.obj((IItemProvider)IEBlocks.Connectors.currentTransformer, IEDataGenerator.rl("block/connector/e_meter.obj")).transforms(IEDataGenerator.rl("item/current_transformer"));
        this.obj((IItemProvider)IEBlocks.Connectors.breakerswitch, IEDataGenerator.rl("block/connector/breaker_switch_off.obj.ie")).transforms(IEDataGenerator.rl("item/breaker_switch"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.razorWire, IEDataGenerator.rl("block/razor_wire.obj.ie")).transforms(IEDataGenerator.rl("item/block"));
        ((LoadedModelBuilder)this.obj((IItemProvider)IEBlocks.MetalDevices.electricLantern, IEDataGenerator.rl("block/metal_device/e_lantern.obj")).texture("texture", this.modLoc("block/metal_device/electric_lantern"))).transforms(IEDataGenerator.rl("item/block"));
        this.obj((IItemProvider)IEBlocks.MetalDevices.floodlight, IEDataGenerator.rl("block/metal_device/floodlight.obj.ie")).transforms(IEDataGenerator.rl("item/floodlight"));
        this.getBuilder((IItemProvider)IEBlocks.Connectors.feedthrough).loader(FeedthroughLoader.LOCATION);
    }

    private LoadedModelBuilder obj(IItemProvider item, ResourceLocation model) {
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(model, ResourcePackType.CLIENT_RESOURCES, "", "models"));
        return this.getBuilder(item).loader(this.forgeLoc("obj")).additional("model", new ResourceLocation(model.func_110624_b(), "models/" + model.func_110623_a())).additional("flip-v", true);
    }

    private LoadedModelBuilder ieObj(IItemProvider item, ResourceLocation model) {
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(model, ResourcePackType.CLIENT_RESOURCES, "", "models"));
        return this.getBuilder(item).loader(this.modLoc("ie_obj")).additional("model", new ResourceLocation(model.func_110624_b(), "models/" + model.func_110623_a())).additional("flip-v", true);
    }

    private LoadedModelBuilder getBuilder(IItemProvider item) {
        return this.getBuilder(this.name(item));
    }

    private String name(IItemProvider item) {
        return item.func_199767_j().getRegistryName().func_110623_a();
    }

    @Nonnull
    public String func_200397_b() {
        return "Item models";
    }

    private void createMetalModels(EnumMetals metal) {
        String name = metal.tagName();
        if (metal.shouldAddOre()) {
            this.cubeAll(this.name((IItemProvider)IEBlocks.Metals.ores.get((Object)metal)), IEDataGenerator.rl("block/metal/ore_" + name));
        }
        if (!metal.isVanillaMetal()) {
            ResourceLocation defaultName = IEDataGenerator.rl("block/metal/storage_" + name);
            if (metal == EnumMetals.URANIUM) {
                ResourceLocation side = IEDataGenerator.rl("block/metal/storage_" + name + "_side");
                ResourceLocation top = IEDataGenerator.rl("block/metal/storage_" + name + "_top");
                this.cubeBottomTop(this.name((IItemProvider)IEBlocks.Metals.storage.get((Object)metal)), side, top, top);
            } else {
                this.cubeAll(this.name((IItemProvider)IEBlocks.Metals.storage.get((Object)metal)), defaultName);
            }
        }
        ResourceLocation sheetmetalName = IEDataGenerator.rl("block/metal/sheetmetal_" + name);
        this.cubeAll(this.name((IItemProvider)IEBlocks.Metals.sheetmetal.get((Object)metal)), sheetmetalName);
    }

    private void addItemModels(String texturePrefix, Item ... items) {
        this.addItemModels(texturePrefix, Arrays.asList(items));
    }

    private void addItemModels(String texturePrefix, ResourceLocation parent, Item ... items) {
        this.addItemModels(texturePrefix, parent, Arrays.asList(items));
    }

    private void addItemModels(String texturePrefix, Collection<Item> items) {
        this.addItemModels(texturePrefix, this.mcLoc("item/generated"), items);
    }

    private void addItemModels(String texturePrefix, ResourceLocation parent, Collection<Item> items) {
        for (Item item : items) {
            this.addItemModel(texturePrefix == null ? null : texturePrefix + item.getRegistryName().func_110623_a(), item, parent);
        }
    }

    private void addItemModel(String texture, Item item) {
        this.addItemModel(texture, item, this.mcLoc("item/generated"));
    }

    private void addItemModel(String texture, Item item, ResourceLocation parent) {
        String path = this.name((IItemProvider)item);
        String textureLoc = texture == null ? path : "item/" + texture;
        this.withExistingParent(path, parent).texture("layer0", this.modLoc(textureLoc));
    }

    private void addLayeredItemModel(Item item, ResourceLocation ... layers) {
        String path = this.name((IItemProvider)item);
        LoadedModelBuilder modelBuilder = this.withExistingParent(path, this.mcLoc("item/generated"));
        int layerIdx = 0;
        for (ResourceLocation layer : layers) {
            modelBuilder.texture("layer" + layerIdx++, layer);
        }
    }
}

