/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class WirecutterItem
extends IEBaseItem
implements ITool {
    public static final ToolType CUTTER_TOOL = ToolType.get((String)"immersiveengineering_cutter");

    public WirecutterItem() {
        super("wirecutter", new Item.Properties().func_200915_b(((Integer)IEConfig.TOOLS.cutterDurabiliy.get()).intValue()));
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        if (container.func_96631_a(1, Utils.RAND, null)) {
            return ItemStack.field_190927_a;
        }
        return container;
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        BlockState state = player.field_70170_p.func_180495_p(pos);
        boolean effective = false;
        for (ToolType tool : this.getToolTypes(itemstack)) {
            if (!state.func_177230_c().isToolEffective(state, tool)) continue;
            effective = true;
            break;
        }
        itemstack.func_96631_a(1, Utils.RAND, null);
        return effective;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        TargetingInfo target = new TargetingInfo(context.func_196000_l(), (float)context.func_221532_j().field_72450_a, (float)context.func_221532_j().field_72448_b, (float)context.func_221532_j().field_72449_c);
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (player != null && tileEntity instanceof IImmersiveConnectable) {
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
            if (!((tileEntity = world.func_175625_s(masterPos)) instanceof IImmersiveConnectable)) {
                return ActionResultType.PASS;
            }
            if (!world.field_72995_K) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                AtomicBoolean cut = new AtomicBoolean(false);
                net.removeAllConnectionsAt(nodeHere, conn -> {
                    ItemStack coil = conn.type.getWireCoil((Connection)conn);
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), coil));
                    cut.set(true);
                });
                if (cut.get()) {
                    this.damageStack(stack, player, context.func_221531_n());
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void damageStack(ItemStack stack, PlayerEntity player, Hand hand) {
        int nbtDamage = ItemNBTHelper.getInt(stack, "Damage") + 1;
        if (nbtDamage < (Integer)IEConfig.TOOLS.cutterDurabiliy.get()) {
            ItemNBTHelper.putInt(stack, "Damage", nbtDamage);
        } else {
            player.func_70669_a(stack);
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        double reachDistance;
        Connection target;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (target = WireUtils.getTargetConnection(world, player, null, reachDistance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e())) != null) {
            GlobalWireNetwork.getNetwork(world).removeAndDropConnection(target, player.func_180425_c(), world);
            this.damageStack(stack, player, hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (this.getToolTypes(stack).contains(tool)) {
            return 2;
        }
        return -1;
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)CUTTER_TOOL);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        for (ToolType type : this.getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return 6.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (state.func_177230_c() instanceof IEBaseBlock) {
            return ((IEBaseBlock)state.func_177230_c()).allowWirecutterHarvest(state);
        }
        return state.func_177230_c().isToolEffective(state, CUTTER_TOOL);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

