/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnInterdictionHandler {
    private static final Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set<IEBlockInterfaces.ISpawnInterdiction> dimSet = interdictionTiles.get(event.getEntity().field_70170_p.func_201675_m().func_186058_p());
                if (dimSet != null) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = dimSet.iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (interdictor instanceof TileEntity) {
                            if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                                it.remove();
                                continue;
                            }
                            if (!(((TileEntity)interdictor).func_145835_a(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_()) <= interdictor.getInterdictionRangeSquared())) continue;
                            event.setCanceled(true);
                            continue;
                        }
                        if (!(interdictor instanceof Entity)) continue;
                        if (!((Entity)interdictor).func_70089_S() || ((Entity)interdictor).field_70170_p == null) {
                            it.remove();
                            continue;
                        }
                        if (!(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                    }
                }
            }
        }
        if (event.getEntityLiving().func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.isSpawner()) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                DimensionType dimension = event.getEntity().field_70170_p.func_201675_m().func_186058_p();
                if (interdictionTiles.containsKey(dimension)) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (!(interdictor instanceof TileEntity)) continue;
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (!(((TileEntity)interdictor).func_145835_a(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void removeFromInterdictionTiles(T tile) {
        Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            Set<IEBlockInterfaces.ISpawnInterdiction> inDimension = interdictionTiles.get(tile.func_145831_w().func_201675_m().func_186058_p());
            if (inDimension != null) {
                inDimension.remove(tile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void addInterdictionTile(T tile) {
        World world = tile.func_145831_w();
        if (world != null && ((Boolean)IEConfig.MACHINES.floodlight_spawnPrevent.get()).booleanValue()) {
            Map<DimensionType, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set forDim = interdictionTiles.computeIfAbsent(world.func_201675_m().func_186058_p(), x -> new HashSet());
                forDim.add(tile);
            }
        }
    }
}

