/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.lib.manual.ManualElementCrafting;
import blusunrize.lib.manual.ManualElementImage;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ManualInstance
implements ISelectiveResourceReloadListener {
    public ResourceLocation texture;
    private Map<ResourceLocation, Function<JsonObject, SpecialManualElement>> specialElements = new HashMap<ResourceLocation, Function<JsonObject, SpecialManualElement>>();
    private final Tree<ResourceLocation, ManualEntry> contentTree;
    private final List<Pair<List<ResourceLocation>, ManualEntry>> autoloadedEntries = new ArrayList<Pair<List<ResourceLocation>, ManualEntry>>();
    private final List<List<ResourceLocation>> autoloadedSections = new ArrayList<List<ResourceLocation>>();
    public Map<ResourceLocation, ManualEntry> contentsByName = new HashMap<ResourceLocation, ManualEntry>();
    public final int pageWidth;
    public final int pageHeight;
    private boolean initialized = false;
    public HashMap<Integer, ManualLink> itemLinks = Maps.newHashMap();

    public ManualInstance(ResourceLocation texture, int pageWidth, int pageHeight, ResourceLocation name) {
        this.texture = texture;
        this.pageHeight = pageHeight;
        this.pageWidth = pageWidth;
        this.contentTree = new Tree(name);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)this);
        this.registerSpecialElement(new ResourceLocation(name.func_110624_b(), "crafting"), s -> {
            Object[] stacksAndRecipes;
            if (JSONUtils.func_151202_d((JsonObject)s, (String)"recipes")) {
                JsonArray data = JSONUtils.func_151214_t((JsonObject)s, (String)"recipes");
                stacksAndRecipes = new Object[data.size()];
                for (int i = 0; i < data.size(); ++i) {
                    JsonElement el = data.get(i);
                    if (el.isJsonArray()) {
                        JsonArray inner = el.getAsJsonArray();
                        Object[] innerSaR = new Object[inner.size()];
                        for (int j = 0; j < inner.size(); ++j) {
                            innerSaR[j] = ManualUtils.getRecipeObjFromJson(this, inner.get(j));
                        }
                        stacksAndRecipes[i] = innerSaR;
                        continue;
                    }
                    stacksAndRecipes[i] = ManualUtils.getRecipeObjFromJson(this, el);
                }
            } else {
                stacksAndRecipes = new Object[]{ManualUtils.getRecipeObjFromJson(this, (JsonElement)s)};
            }
            return new ManualElementCrafting(this, stacksAndRecipes);
        });
        this.registerSpecialElement(new ResourceLocation(name.func_110624_b(), "image"), s -> {
            JsonArray data = JSONUtils.func_151214_t((JsonObject)s, (String)"images");
            ManualElementImage.ManualImage[] images = new ManualElementImage.ManualImage[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                JsonObject img = data.get(i).getAsJsonObject();
                ResourceLocation loc = ManualUtils.getLocationForManual(JSONUtils.func_151200_h((JsonObject)img, (String)"location"), this);
                int uMin = JSONUtils.func_151203_m((JsonObject)img, (String)"uMin");
                int vMin = JSONUtils.func_151203_m((JsonObject)img, (String)"vMin");
                int uSize = JSONUtils.func_151203_m((JsonObject)img, (String)"uSize");
                int vSize = JSONUtils.func_151203_m((JsonObject)img, (String)"vSize");
                images[i] = new ManualElementImage.ManualImage(loc, uMin, uSize, vMin, vSize);
            }
            return new ManualElementImage(this, images);
        });
        this.registerSpecialElement(new ResourceLocation(name.func_110624_b(), "item_display"), s -> {
            NonNullList stacks;
            if (s.has("item")) {
                stacks = NonNullList.func_191197_a((int)1, (Object)ManualUtils.getItemStackFromJson(this, s.get("item")));
            } else {
                JsonElement items = s.get("items");
                JsonArray arr = items.getAsJsonArray();
                stacks = NonNullList.func_191197_a((int)arr.size(), (Object)ItemStack.field_190927_a);
                for (int i = 0; i < arr.size(); ++i) {
                    stacks.set(i, (Object)ManualUtils.getItemStackFromJson(this, arr.get(i)));
                }
            }
            return new ManualElementItem(this, (NonNullList<ItemStack>)stacks);
        });
        this.registerSpecialElement(new ResourceLocation(name.func_110624_b(), "table"), s -> {
            JsonArray arr = JSONUtils.func_151214_t((JsonObject)s, (String)"table");
            ITextComponent[][] table = new ITextComponent[arr.size()][];
            for (int i = 0; i < table.length; ++i) {
                JsonArray row = arr.get(i).getAsJsonArray();
                table[i] = new ITextComponent[row.size()];
                for (int j = 0; j < row.size(); ++j) {
                    table[i][j] = new StringTextComponent(row.get(j).getAsString());
                }
            }
            return new ManualElementTable(this, table, JSONUtils.func_151209_a((JsonObject)s, (String)"horizontal_bars", (boolean)false));
        });
    }

    public void registerSpecialElement(ResourceLocation resLoc, Function<JsonObject, SpecialManualElement> factory) {
        if (this.specialElements.containsKey(resLoc)) {
            throw new IllegalArgumentException("Tried adding manual element type " + resLoc + " twice!");
        }
        this.specialElements.put(resLoc, factory);
    }

    public Tree.InnerNode<ResourceLocation, ManualEntry> getRoot() {
        return this.contentTree.getRoot();
    }

    public Stream<Tree.AbstractNode<ResourceLocation, ManualEntry>> getAllEntriesAndCategories() {
        return this.contentTree.fullStream();
    }

    public Function<JsonObject, SpecialManualElement> getElementFactory(ResourceLocation loc) {
        Function<JsonObject, SpecialManualElement> ret = this.specialElements.get(loc);
        if (ret == null) {
            throw new IllegalArgumentException("No element type found for " + loc);
        }
        return ret;
    }

    public abstract String getDefaultResourceDomain();

    public abstract String getManualName();

    public abstract String formatCategoryName(ResourceLocation var1);

    public abstract String formatEntryName(String var1);

    public abstract String formatEntrySubtext(String var1);

    public abstract String formatLink(ManualLink var1);

    public abstract String formatText(String var1);

    public abstract boolean showCategoryInList(String var1);

    public abstract boolean showNodeInList(Tree.AbstractNode<ResourceLocation, ManualEntry> var1);

    public abstract int getTitleColour();

    public abstract int getSubTitleColour();

    public abstract int getTextColour();

    public abstract int getHighlightColour();

    public abstract int getPagenumberColour();

    public abstract boolean allowGuiRescale();

    public abstract boolean improveReadability();

    public void openManual() {
    }

    public void closeManual() {
    }

    public void openEntry(ManualEntry entry) {
    }

    public void titleRenderPre() {
    }

    public void titleRenderPost() {
    }

    public void entryRenderPre() {
    }

    public void entryRenderPost() {
    }

    public void tooltipRenderPre() {
    }

    public void tooltipRenderPost() {
    }

    public ManualScreen getGui() {
        return this.getGui(true);
    }

    public ManualScreen getGui(boolean useLastActive) {
        if (useLastActive && ManualScreen.lastActiveManual != null && ManualScreen.lastActiveManual.getManual() == this) {
            return ManualScreen.lastActiveManual;
        }
        if (!this.initialized) {
            long start = System.currentTimeMillis();
            this.reload();
            IELogger.logger.info("Manual reload took {} ms", (Object)(System.currentTimeMillis() - start));
        }
        return new ManualScreen(this, this.texture, useLastActive);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry) {
        int nextPrio = node.getChildren().size();
        this.addEntry(node, entry, nextPrio);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry, int priority) {
        this.addEntry(node, entry, () -> priority);
    }

    public void addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ManualEntry entry, DoubleSupplier priority) {
        node.addNewLeaf(entry, priority);
        this.reset();
    }

    public void reset() {
        this.initialized = false;
        ManualScreen.lastActiveManual = null;
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source) {
        int nextPrio = node.getChildren().size();
        return this.addEntry(node, source, nextPrio);
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source, int priority) {
        return this.addEntry(node, source, () -> priority);
    }

    public ManualEntry addEntry(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation source, DoubleSupplier priority) {
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(source);
        ManualEntry entry = builder.create();
        this.addEntry(node, entry, priority);
        return entry;
    }

    public DoubleSupplier atOffsetFrom(Tree.InnerNode<ResourceLocation, ManualEntry> node, String baseEntry, double offset) {
        return this.atOffsetFrom(node, ManualUtils.getLocationForManual(baseEntry, this), offset);
    }

    public DoubleSupplier atOffsetFrom(Tree.InnerNode<ResourceLocation, ManualEntry> node, ResourceLocation baseEntry, double offset) {
        return () -> {
            double baseWeight = this.findEntry(baseEntry, node).getWeight();
            return baseWeight + offset;
        };
    }

    @Nullable
    public ManualEntry getEntry(ResourceLocation loc) {
        return this.contentsByName.get(loc);
    }

    public void indexRecipes() {
        this.itemLinks.clear();
        this.getAllEntries().forEach(entry -> {
            Int2ObjectMap<SpecialManualElement> specials = entry.getSpecials();
            IntIterator intIterator = specials.keySet().iterator();
            while (intIterator.hasNext()) {
                int page = (Integer)intIterator.next();
                SpecialManualElement p = (SpecialManualElement)specials.get(page);
                p.recalculateCraftingRecipes();
                for (ItemStack s : p.getProvidedRecipes()) {
                    this.itemLinks.put(this.getItemHash(s), new ManualLink((ManualEntry)entry, "start", page));
                }
            }
        });
    }

    public ManualLink getManualLink(ItemStack stack) {
        int hash = this.getItemHash(stack);
        return this.itemLinks.get(hash);
    }

    int getItemHash(ItemStack stack) {
        CompoundNBT nbt;
        if (stack.func_190926_b()) {
            return 0;
        }
        int ret = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).hashCode();
        if (stack.func_77942_o() && !(nbt = stack.func_77978_p()).isEmpty()) {
            ret = ret * 31 + nbt.hashCode();
        }
        return ret;
    }

    public Stream<ManualEntry> getAllEntries() {
        return this.contentTree.leafStream();
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        this.reset();
    }

    public void reload() {
        this.cleanupOldAutoloadedEntries();
        MutableInt numErrors = new MutableInt();
        this.getAllEntries().forEach(manualEntry -> {
            try {
                manualEntry.refreshPages();
            }
            catch (Exception x) {
                x.printStackTrace();
                numErrors.incrementAndGet();
            }
        });
        numErrors.add(this.loadAutoEntries());
        if (numErrors.intValue() != 0) {
            throw new RuntimeException(numErrors.intValue() + " manual entries failed to load, see log for details!");
        }
        this.contentTree.sortAll();
        this.contentsByName.clear();
        this.contentTree.leafStream().forEach(e -> this.contentsByName.put(e.getLocation(), (ManualEntry)e));
        this.indexRecipes();
        this.initialized = true;
    }

    private void cleanupOldAutoloadedEntries() {
        for (Pair<List<ResourceLocation>, ManualEntry> pair : this.autoloadedEntries) {
            this.getOrCreatePath((List)pair.getLeft(), p -> {}, 0.0).removeLeaf((ManualEntry)((Comparable)pair.getRight()));
        }
        for (List list : this.autoloadedSections) {
            List<ResourceLocation> parent = list.subList(0, list.size() - 1);
            this.getOrCreatePath(parent, p -> {
                throw new RuntimeException(p.toString());
            }, 0.0).removeSubnode((ResourceLocation)((Comparable)list.get(parent.size())));
        }
        this.autoloadedEntries.clear();
        this.autoloadedSections.clear();
    }

    private int loadAutoEntries() {
        ResourceLocation autoLoc = ManualUtils.getLocationForManual("manual/autoload.json", this);
        try {
            List autoload = Minecraft.func_71410_x().func_195551_G().func_199004_b(autoLoc);
            TreeSet<Pair> autoloadSources = new TreeSet<Pair>(Comparator.comparingDouble(Pair::getLeft));
            for (IResource r : autoload) {
                JsonObject autoloadJson = JSONUtils.func_212743_a((Reader)new InputStreamReader(r.func_199027_b()));
                double priority = 0.0;
                JsonElement priorityElement = autoloadJson.remove("autoload_priority");
                if (priorityElement != null) {
                    priority = priorityElement.getAsDouble();
                }
                autoloadSources.add(Pair.of((Object)priority, (Object)autoloadJson));
            }
            int failed = 0;
            for (Pair p : autoloadSources.descendingSet()) {
                failed += this.autoloadEntriesFromJson((JsonObject)p.getRight(), new ArrayList<ResourceLocation>());
            }
            return failed;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int autoloadEntriesFromJson(JsonObject obj, List<ResourceLocation> backtrace) {
        String entryListKey = "entry_list";
        String weightKey = "category_weight";
        double catWeight = obj.has("category_weight") ? obj.remove("category_weight").getAsDouble() : 0.0;
        Tree.InnerNode<ResourceLocation, ManualEntry> node = this.getOrCreatePath(backtrace, path -> {
            boolean parentIsAutoloaded = false;
            for (int i = 1; i <= path.size(); ++i) {
                if (!this.autoloadedSections.contains(path.subList(0, i))) continue;
                parentIsAutoloaded = true;
                break;
            }
            if (!parentIsAutoloaded) {
                this.autoloadedSections.add((List<ResourceLocation>)path);
            }
        }, catWeight);
        int failCount = obj.has("entry_list") ? this.loadEntriesInArray(obj.remove("entry_list").getAsJsonArray(), backtrace, node) : 0;
        for (Map.Entry otherEntry : obj.entrySet()) {
            Preconditions.checkState((boolean)((JsonElement)otherEntry.getValue()).isJsonObject(), (String)"At backtrace %s, key %s", backtrace, otherEntry.getKey());
            backtrace.add(ManualUtils.getLocationForManual((String)otherEntry.getKey(), this));
            failCount += this.autoloadEntriesFromJson(((JsonElement)otherEntry.getValue()).getAsJsonObject(), new ArrayList<ResourceLocation>(backtrace));
            backtrace.remove(backtrace.size() - 1);
        }
        return failCount;
    }

    private int loadEntriesInArray(JsonArray entriesOnLevel, List<ResourceLocation> backtrace, Tree.InnerNode<ResourceLocation, ManualEntry> mainNode) {
        int failCount = 0;
        for (JsonElement e : entriesOnLevel) {
            double weight;
            String source;
            if (e.isJsonObject()) {
                source = e.getAsJsonObject().get("source").getAsString();
                weight = e.getAsJsonObject().get("weight").getAsDouble();
            } else {
                source = e.getAsString();
                weight = mainNode.getChildren().size();
            }
            try {
                ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(this);
                builder.readFromFile(ManualUtils.getLocationForManual(source, this));
                ManualEntry entry = builder.create();
                mainNode.addNewLeaf(entry, () -> weight);
                entry.refreshPages();
                this.autoloadedEntries.add((Pair<List<ResourceLocation>, ManualEntry>)Pair.of(backtrace, (Object)entry));
            }
            catch (Exception x) {
                x.printStackTrace();
                ++failCount;
            }
        }
        return failCount;
    }

    private Tree.InnerNode<ResourceLocation, ManualEntry> getOrCreatePath(List<ResourceLocation> path, Consumer<List<ResourceLocation>> onCreated, double newCatWeight) {
        Tree.InnerNode currentNode = this.getRoot();
        ArrayList<ResourceLocation> currentPath = new ArrayList<ResourceLocation>();
        for (ResourceLocation inner : path) {
            currentPath.add(inner);
            Tree.InnerNode lastNode = currentNode;
            currentNode = currentNode.getSubnode((ResourceLocation)inner).orElseGet(() -> {
                onCreated.accept(new ArrayList(currentPath));
                return lastNode.getOrCreateSubnode(inner, () -> newCatWeight);
            });
            Preconditions.checkNotNull((Object)currentNode);
        }
        return currentNode;
    }

    public Tree.Leaf<ResourceLocation, ManualEntry> findEntry(ResourceLocation name, Tree.InnerNode<ResourceLocation, ManualEntry> parent) {
        for (Tree.AbstractNode<ResourceLocation, ManualEntry> child : parent.getChildren()) {
            ResourceLocation loc = child.getLeafData().getLocation();
            if (!child.isLeaf() || !loc.equals((Object)name)) continue;
            return (Tree.Leaf)child;
        }
        throw new NoSuchElementException("Did not find a child with name " + name);
    }

    public abstract FontRenderer fontRenderer();

    public static class ManualLink {
        @Nonnull
        private final ManualEntry key;
        private final String anchor;
        private final int offset;

        public ManualLink(@Nonnull ManualEntry key, String anchor, int offset) {
            this.key = key;
            this.anchor = anchor;
            this.offset = offset;
        }

        @Nonnull
        public ManualEntry getKey() {
            return this.key;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public int getOffset() {
            return this.offset;
        }

        public void changePage(ManualScreen manualScreen, boolean addCurrentToStack) {
            if (addCurrentToStack) {
                manualScreen.previousSelectedEntry.push(new ManualLink(manualScreen.getCurrentPage(), "start", manualScreen.page));
            }
            manualScreen.setCurrentNode(this.key.getTreeNode());
            manualScreen.page = this.getPage();
            manualScreen.fullInit();
        }

        public int getPage() {
            return this.getKey().getPageForAnchor(this.getAnchor()) + this.getOffset();
        }
    }
}

