/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.structure;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;

public interface PlaceableStructure
extends Structure {
    default public Map<BlockPos, BlockState> placeInWorld(IWorld world, BlockPos center, Predicate<BlockPos> posFilter) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, ? extends MatchableState> entry : this.getContents().entrySet()) {
            MatchableTile<? extends TileEntity> matchTile;
            TileEntity placed;
            MatchableState match = entry.getValue();
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (!posFilter.test(at)) continue;
            BlockState state = match.getDescriptiveState(0L);
            BlockState existing = world.func_180495_p(at);
            if (!existing.func_204520_s().func_206888_e() && existing.func_204520_s().func_206884_a(FluidTags.field_206959_a) && state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
                state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            if (!world.func_180501_a(at, state, 3)) continue;
            result.put(at, state);
            if (!state.func_204520_s().func_206888_e()) {
                Fluid f = state.func_204520_s().func_206886_c();
                world.func_205219_F_().func_205362_a(at, (Object)f, f.func_205569_a((IWorldReader)world), TickPriority.HIGH);
            }
            if ((placed = world.func_175625_s(at)) == null || !this.hasTileAt(entry.getKey()) || (matchTile = this.getTileEntityAt(entry.getKey())) == null) continue;
            matchTile.postPlacement((TileEntity)placed, (IBlockReader)world, entry.getKey());
        }
        return result;
    }

    default public Map<BlockPos, BlockState> placeInWorld(IWorld world, BlockPos center, Predicate<BlockPos> posFilter, PastPlaceProcessor processor) {
        Map<BlockPos, BlockState> result = this.placeInWorld(world, center, posFilter);
        if (processor != null) {
            for (Map.Entry<BlockPos, BlockState> entry : result.entrySet()) {
                if (!posFilter.test(entry.getKey())) continue;
                processor.process(world, entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static interface PastPlaceProcessor {
        public void process(IWorld var1, BlockPos var2, BlockState var3);
    }
}

