/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.api.util;

import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.block.SimpleMatchableBlock;
import hellfirepvp.observerlib.api.block.SimpleMatchableBlockState;
import hellfirepvp.observerlib.api.structure.Structure;
import hellfirepvp.observerlib.api.tile.MatchableTile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.logging.log4j.util.TriConsumer;

public class BlockArray
implements Structure {
    private final Map<BlockPos, MatchableState> blocks = new HashMap<BlockPos, MatchableState>();
    private final Map<BlockPos, MatchableTile<? extends TileEntity>> tiles = new HashMap<BlockPos, MatchableTile<? extends TileEntity>>();
    private Vec3i min = new Vec3i(0, 0, 0);
    private Vec3i max = new Vec3i(0, 0, 0);

    @Nonnull
    public Map<BlockPos, MatchableState> getContents() {
        return Collections.unmodifiableMap(this.blocks);
    }

    @Override
    @Nonnull
    public Map<BlockPos, ? extends MatchableTile<? extends TileEntity>> getTileEntities() {
        return Collections.unmodifiableMap(this.tiles);
    }

    @Override
    public Vec3i getMaximumOffset() {
        return this.max;
    }

    @Override
    public Vec3i getMinimumOffset() {
        return this.min;
    }

    public void addTileEntity(MatchableTile<?> tile, int x, int y, int z) {
        this.addTileEntity(tile, new BlockPos(x, y, z));
    }

    public void addTileEntity(MatchableTile<?> tile, BlockPos pos) {
        this.tiles.put(pos, tile);
        this.updateSize(pos);
    }

    public void addBlock(BlockState state, int x, int y, int z) {
        this.addBlock(state, new BlockPos(x, y, z));
    }

    public void addBlock(Block block, int x, int y, int z) {
        this.addBlock(block, new BlockPos(x, y, z));
    }

    public void addBlock(MatchableState state, int x, int y, int z) {
        this.addBlock(state, new BlockPos(x, y, z));
    }

    public void addBlock(BlockState state, BlockPos pos) {
        MatchableState match = new SimpleMatchableBlockState(state);
        if (state == Blocks.field_150350_a.func_176223_P()) {
            match = MatchableState.IS_AIR;
        }
        this.addBlock(match, pos);
    }

    public void addBlock(Block block, BlockPos pos) {
        MatchableState match = new SimpleMatchableBlock(block);
        if (block == Blocks.field_150350_a) {
            match = MatchableState.IS_AIR;
        }
        this.addBlock(match, pos);
    }

    public void addBlock(MatchableState state, BlockPos pos) {
        this.blocks.put(pos, state);
        this.updateSize(pos);
    }

    public void addAll(BlockArray other) {
        other.getContents().forEach((pos, matchState) -> this.addBlock((MatchableState)matchState, (BlockPos)pos));
        other.getTileEntities().forEach((pos, tile) -> this.addTileEntity((MatchableTile<?>)tile, (BlockPos)pos));
    }

    public void addBlockCube(BlockState state, int ox, int oy, int oz, int tx, int ty, int tz) {
        this.forAllInCube(ox, oy, oz, tx, ty, tz, (TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, z) -> this.addBlock(state, (int)x, (int)y, (int)z)));
    }

    public void addBlockCube(MatchableState state, int ox, int oy, int oz, int tx, int ty, int tz) {
        this.forAllInCube(ox, oy, oz, tx, ty, tz, (TriConsumer<Integer, Integer, Integer>)((TriConsumer)(x, y, z) -> this.addBlock(state, (int)x, (int)y, (int)z)));
    }

    public void forAllInCube(int ox, int oy, int oz, int tx, int ty, int tz, TriConsumer<Integer, Integer, Integer> posFunction) {
        int hz;
        int lz;
        int hy;
        int ly;
        int hx;
        int lx;
        if (ox < tx) {
            lx = ox;
            hx = tx;
        } else {
            lx = tx;
            hx = ox;
        }
        if (oy < ty) {
            ly = oy;
            hy = ty;
        } else {
            ly = ty;
            hy = oy;
        }
        if (oz < tz) {
            lz = oz;
            hz = tz;
        } else {
            lz = tz;
            hz = oz;
        }
        for (int xx = lx; xx <= hx; ++xx) {
            for (int zz = lz; zz <= hz; ++zz) {
                for (int yy = ly; yy <= hy; ++yy) {
                    posFunction.accept((Object)xx, (Object)yy, (Object)zz);
                }
            }
        }
    }

    private void updateSize(BlockPos addedPos) {
        if (addedPos.func_177958_n() < this.min.func_177958_n()) {
            this.min = new Vec3i(addedPos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177958_n() > this.max.func_177958_n()) {
            this.max = new Vec3i(addedPos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177956_o() < this.min.func_177956_o()) {
            this.min = new Vec3i(this.min.func_177958_n(), addedPos.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177956_o() > this.max.func_177956_o()) {
            this.max = new Vec3i(this.max.func_177958_n(), addedPos.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177952_p() < this.min.func_177952_p()) {
            this.min = new Vec3i(this.min.func_177958_n(), this.min.func_177956_o(), addedPos.func_177952_p());
        }
        if (addedPos.func_177952_p() > this.max.func_177952_p()) {
            this.max = new Vec3i(this.max.func_177958_n(), this.max.func_177956_o(), addedPos.func_177952_p());
        }
    }
}

