/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.client.preview;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.observerlib.api.block.MatchableState;
import hellfirepvp.observerlib.api.client.StructureRenderWorld;
import hellfirepvp.observerlib.api.structure.MatchableStructure;
import hellfirepvp.observerlib.api.util.StructureUtil;
import hellfirepvp.observerlib.client.preview.StructurePreviewHandler;
import hellfirepvp.observerlib.client.preview.StructureSnapshot;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import hellfirepvp.observerlib.client.util.ClientTickHelper;
import hellfirepvp.observerlib.client.util.RenderTypeDecorator;
import hellfirepvp.observerlib.client.util.SimpleBossInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class StructurePreview {
    private static final Random rand = new Random();
    private DimensionType dimType;
    private BlockPos origin;
    private final StructureSnapshot snapshot;
    private double minimumDisplayDistanceSq = 64.0;
    private double displayDistanceMultiplier = 1.75;
    private BiPredicate<World, BlockPos> persistenceTest = (world, pos) -> true;
    private ITextComponent barText = null;
    private SimpleBossInfo bossInfo = null;

    private StructurePreview(DimensionType dimType, BlockPos origin, StructureSnapshot snapshot) {
        this.dimType = dimType;
        this.origin = origin;
        this.snapshot = snapshot;
    }

    public static Builder newBuilder(DimensionType sourceWorld, BlockPos source, MatchableStructure structure) {
        return StructurePreview.newBuilder(sourceWorld, source, structure, ClientTickHelper.getClientTick());
    }

    public static Builder newBuilder(DimensionType sourceWorld, BlockPos source, MatchableStructure structure, long tick) {
        return new Builder(sourceWorld, source, structure, tick);
    }

    private boolean isInRenderDistance(BlockPos position) {
        double distanceSq = Math.max(this.minimumDisplayDistanceSq, this.snapshot.getStructure().getMaximumOffset().func_177951_i(this.snapshot.getStructure().getMinimumOffset()));
        return this.origin.func_177951_i((Vec3i)position) <= (distanceSq *= Math.max(1.0, this.displayDistanceMultiplier));
    }

    boolean canRender(World renderWorld, BlockPos renderPosition) {
        if (!this.dimType.equals(renderWorld.func_201675_m().func_186058_p())) {
            return false;
        }
        return this.isInRenderDistance(renderPosition);
    }

    boolean canPersist(World renderWorld, BlockPos position) {
        return this.persistenceTest.test(renderWorld, position);
    }

    public void tick(World renderWorld, BlockPos position) {
        if (this.barText != null) {
            if (this.dimType.equals(renderWorld.func_201675_m().func_186058_p()) && this.isInRenderDistance(position)) {
                if (this.bossInfo == null) {
                    this.bossInfo = SimpleBossInfo.newBuilder(this.barText, BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS).build();
                    this.bossInfo.displayInfo();
                }
                float percFinished = (float)StructureUtil.getMismatches(this.snapshot.getStructure(), (IBlockReader)renderWorld, this.origin).size() / (float)this.snapshot.getStructure().getContents().size();
                this.bossInfo.func_186735_a(1.0f - percFinished);
            } else if (this.bossInfo != null) {
                this.bossInfo.removeInfo();
                this.bossInfo = null;
            }
        }
    }

    void onRemove() {
        if (this.bossInfo != null) {
            this.bossInfo.removeInfo();
        }
    }

    void render(World renderWorld, MatrixStack renderStack, Vec3d playerPos) {
        Optional<Integer> displaySlice = StructureUtil.getLowestMismatchingSlice(this.snapshot.getStructure(), (IBlockReader)renderWorld, this.origin);
        if (!displaySlice.isPresent()) {
            return;
        }
        StructureRenderWorld drawWorld = new StructureRenderWorld(this.snapshot.getStructure(), Biomes.field_76772_c);
        drawWorld.pushContentFilter(pos -> pos.func_177956_o() == ((Integer)displaySlice.get()).intValue());
        int[] fullBright = new int[]{15, 15};
        BlockMismatchColorDecorator colorDecorator = new BlockMismatchColorDecorator();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        BufferDecoratorBuilder decorator = new BufferDecoratorBuilder().setLightmapDecorator((skyLight, blockLight) -> fullBright).setColorDecorator(colorDecorator);
        Runnable transparentSetup = () -> {
            RenderSystem.disableAlphaTest();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        };
        Runnable transparentClean = () -> {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
        };
        Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
        if (Minecraft.func_71410_x().field_71460_t != null) {
            vec = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        }
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(-vec.func_82615_a(), -vec.func_82617_b(), -vec.func_82616_c());
        List structureSlice = this.snapshot.getStructure().getStructureSlice(displaySlice.get());
        structureSlice.sort(Comparator.comparingDouble(tpl -> ((BlockPos)tpl.func_76341_a()).func_218140_a(playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c, false)));
        Collections.reverse(structureSlice);
        for (Tuple expectedBlock : structureSlice) {
            RenderTypeDecorator decorated;
            BlockPos at = ((BlockPos)expectedBlock.func_76341_a()).func_177971_a((Vec3i)this.origin);
            TileEntity renderTile = ((MatchableState)expectedBlock.func_76340_b()).createTileEntity((IBlockReader)drawWorld, this.snapshot.getSnapshotTick());
            BlockState actual = renderWorld.func_180495_p(at);
            if (this.snapshot.getStructure().matchesSingleBlock((IBlockReader)renderWorld, this.origin, (BlockPos)expectedBlock.func_76341_a(), actual, renderWorld.func_175625_s(at))) continue;
            BlockState renderState = expectedBlock.func_76340_b() == MatchableState.REQUIRES_AIR ? Blocks.field_196556_aL.func_176223_P() : ((MatchableState)expectedBlock.func_76340_b()).getDescriptiveState(this.snapshot.getSnapshotTick());
            EmptyModelData data = renderTile != null ? renderTile.getModelData() : EmptyModelData.INSTANCE;
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)((float)at.func_177958_n() + 0.2f), (double)((float)at.func_177956_o() + 0.2f), (double)((float)at.func_177952_p() + 0.2f));
            renderStack.func_227862_a_(0.6f, 0.6f, 0.6f);
            if (!actual.isAir((IBlockReader)renderWorld, at)) {
                colorDecorator.isMismatch = true;
            }
            drawWorld.pushContentFilter(pos -> pos.equals(expectedBlock.func_76341_a()));
            if (!renderState.func_204520_s().func_206888_e()) {
                decorated = RenderTypeDecorator.wrapSetup(RenderType.func_228645_f_(), transparentSetup, transparentClean);
                decorator.decorate(buffers.getBuffer((RenderType)decorated), buf -> brd.func_228794_a_(BlockPos.field_177992_a, (ILightReader)drawWorld, buf, renderState.func_204520_s()));
            }
            decorated = RenderTypeDecorator.wrapSetup(RenderTypeLookup.func_228394_b_((BlockState)renderState), transparentSetup, transparentClean);
            decorator.decorate(buffers.getBuffer((RenderType)decorated), arg_0 -> StructurePreview.lambda$render$8(brd, renderState, drawWorld, renderStack, (IModelData)data, arg_0));
            buffers.func_228461_a_();
            drawWorld.popContentFilter();
            colorDecorator.isMismatch = false;
            renderStack.func_227865_b_();
        }
        drawWorld.popContentFilter();
        renderStack.func_227865_b_();
    }

    private static /* synthetic */ void lambda$render$8(BlockRendererDispatcher brd, BlockState renderState, StructureRenderWorld drawWorld, MatrixStack renderStack, IModelData data, IVertexBuilder buf) {
        brd.renderModel(renderState, BlockPos.field_177992_a, (ILightReader)drawWorld, renderStack, buf, true, rand, data);
    }

    private static class BlockMismatchColorDecorator
    implements BufferDecoratorBuilder.ColorDecorator {
        private static final int[] errorColor = new int[]{255, 0, 0, 128};
        private boolean isMismatch = false;

        private BlockMismatchColorDecorator() {
        }

        @Override
        public int[] decorate(int r, int g, int b, int a) {
            if (this.isMismatch) {
                return errorColor;
            }
            return new int[]{r, g, b, 128};
        }
    }

    public static class Builder {
        private final StructurePreview preview;

        private Builder(DimensionType dimType, BlockPos origin, MatchableStructure structure, long tick) {
            this.preview = new StructurePreview(dimType, origin, new StructureSnapshot(structure, tick));
        }

        public Builder setMinimumDisplayDistance(double minimumDisplayDistance) {
            this.preview.minimumDisplayDistanceSq = minimumDisplayDistance * minimumDisplayDistance;
            return this;
        }

        public Builder setDisplayDistanceMultiplier(double displayDistanceMultiplier) {
            this.preview.displayDistanceMultiplier = displayDistanceMultiplier;
            return this;
        }

        public Builder removeIfOutOfRenderDistance() {
            this.preview.persistenceTest = this.preview.persistenceTest.and((world, pos) -> this.preview.isInRenderDistance(pos));
            return this;
        }

        public Builder removeIfOutInDifferentWorld() {
            this.preview.persistenceTest = this.preview.persistenceTest.and((world, pos) -> this.preview.dimType.equals(world.func_201675_m().func_186058_p()));
            return this;
        }

        public Builder andPersistOnlyIf(BiPredicate<World, BlockPos> test) {
            this.preview.persistenceTest = this.preview.persistenceTest.and(test);
            return this;
        }

        public Builder showBar(ITextComponent headline) {
            this.preview.barText = headline;
            return this;
        }

        public StructurePreview buildAndSet() {
            StructurePreviewHandler.getInstance().setStructurePreview(this.preview);
            return this.preview;
        }
    }
}

