/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data.base;

import com.google.common.io.Files;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.common.data.CachedWorldData;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.WorldSection;
import hellfirepvp.observerlib.common.util.AlternatingSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.Vec3i;

public abstract class SectionWorldData<T extends WorldSection>
extends CachedWorldData {
    public static final int PRECISION_REGION = 9;
    public static final int PRECISION_AREA = 6;
    public static final int PRECISION_SECTION = 5;
    public static final int PRECISION_CHUNK = 4;
    private Map<SectionKey, T> sections = new HashMap<SectionKey, T>();
    private final int precision;
    private AlternatingSet<SectionKey> dirtySections = new AlternatingSet();
    private Set<SectionKey> removedSections = new HashSet<SectionKey>();

    protected SectionWorldData(WorldCacheDomain.SaveKey<?> key, int sectionPrecision) {
        super(key);
        this.precision = sectionPrecision;
    }

    public void markDirty(Vec3i absolute) {
        SectionKey key = SectionKey.resolve(absolute, this.precision);
        T section = this.getSection(key);
        if (section != null) {
            this.dirtySections.add(key);
        }
    }

    public void markDirty(T section) {
        this.dirtySections.add(SectionKey.from(section));
    }

    protected abstract T createNewSection(int var1, int var2);

    @Nonnull
    public Collection<T> getSections(Vec3i absoluteMin, Vec3i absoluteMax) {
        return this.resolveSections(absoluteMin, absoluteMax, this::getSection);
    }

    @Nonnull
    public Collection<T> getOrCreateSections(Vec3i absoluteMin, Vec3i absoluteMax) {
        return this.resolveSections(absoluteMin, absoluteMax, this::getOrCreateSection);
    }

    @Nonnull
    private Collection<T> resolveSections(Vec3i absoluteMin, Vec3i absoluteMax, Function<SectionKey, T> sectionFct) {
        SectionKey lower = SectionKey.resolve(absoluteMin, this.precision);
        SectionKey higher = SectionKey.resolve(absoluteMax, this.precision);
        HashSet<WorldSection> out = new HashSet<WorldSection>();
        for (int xx = lower.x; xx <= higher.x; ++xx) {
            for (int zz = lower.z; zz <= higher.z; ++zz) {
                WorldSection section = (WorldSection)sectionFct.apply(new SectionKey(xx, zz));
                if (section == null) continue;
                out.add(section);
            }
        }
        return out;
    }

    @Nonnull
    public T getOrCreateSection(Vec3i absolute) {
        return this.getOrCreateSection(SectionKey.resolve(absolute, this.precision));
    }

    @Nonnull
    private T getOrCreateSection(SectionKey key) {
        return (T)this.sections.computeIfAbsent(key, sectionKey -> this.createNewSection(((SectionKey)sectionKey).x, ((SectionKey)sectionKey).z));
    }

    @Nullable
    public T getSection(Vec3i absolute) {
        return this.getSection(SectionKey.resolve(absolute, this.precision));
    }

    @Nullable
    private T getSection(SectionKey key) {
        return (T)((WorldSection)this.sections.get(key));
    }

    public boolean removeSection(T section) {
        SectionKey key = SectionKey.from(section);
        return this.sections.remove(key) == section && this.removedSections.add(key);
    }

    public boolean removeSection(Vec3i absolute) {
        SectionKey key = SectionKey.resolve(absolute, this.precision);
        return this.sections.remove(key) != null && this.removedSections.add(key);
    }

    @Nonnull
    public Collection<T> getSections() {
        return this.sections.values();
    }

    @Override
    public boolean needsSaving() {
        return !this.dirtySections.isEmpty();
    }

    @Override
    public void markSaved() {
        this.dirtySections.clear();
    }

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);

    private File getSaveFile(File directory, T section) {
        String name = String.format("%s_%s_%s.dat", this.getSaveKey().getIdentifier(), ((WorldSection)section).getSectionX(), ((WorldSection)section).getSectionZ());
        return directory.toPath().resolve(name).toFile();
    }

    @Override
    public final void writeData(File baseDirectory, File backupDirectory) throws IOException {
        File generalSaveFile;
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        }
        if (!backupDirectory.exists()) {
            backupDirectory.mkdirs();
        }
        if ((generalSaveFile = new File(baseDirectory, "general.dat")).exists()) {
            try {
                Files.copy((File)generalSaveFile, (File)new File(backupDirectory, "general.dat"));
            }
            catch (Exception exc) {
                ObserverLib.log.info("Copying '" + this.getSaveKey().getIdentifier() + "' general actual file to its backup file failed!");
                exc.printStackTrace();
            }
        } else {
            generalSaveFile.createNewFile();
        }
        CompoundNBT generalData = new CompoundNBT();
        this.writeToNBT(generalData);
        CompressedStreamTools.func_74795_b((CompoundNBT)generalData, (File)generalSaveFile);
        this.dirtySections.forEach(key -> {
            T section = this.getSection((SectionKey)key);
            if (section != null) {
                File saveFile = this.getSaveFile(baseDirectory, section);
                if (saveFile.exists()) {
                    try {
                        Files.copy((File)saveFile, (File)this.getSaveFile(backupDirectory, section));
                    }
                    catch (Exception exc) {
                        ObserverLib.log.info("Copying '" + this.getSaveKey().getIdentifier() + "' actual file to its backup file failed!");
                        exc.printStackTrace();
                    }
                } else {
                    saveFile.createNewFile();
                }
                CompoundNBT data = new CompoundNBT();
                ((WorldSection)section).writeToNBT(data);
                CompressedStreamTools.func_74795_b((CompoundNBT)data, (File)saveFile);
            }
            return false;
        });
    }

    @Override
    public final void readData(File baseDirectory) throws IOException {
        String identifier = this.getSaveKey().getIdentifier();
        File generalSaveFile = new File(baseDirectory, "general.dat");
        if (generalSaveFile.exists()) {
            CompoundNBT tag = CompressedStreamTools.func_74797_a((File)generalSaveFile);
            this.readFromNBT(tag);
        } else {
            this.readFromNBT(new CompoundNBT());
        }
        for (File subFile : baseDirectory.listFiles()) {
            int sZ;
            int sX;
            String[] ptrn;
            String fileName = subFile.getName();
            if (!fileName.endsWith(".dat") || (ptrn = (fileName = fileName.substring(0, fileName.length() - 4)).split("_")).length != 3 || !ptrn[0].equalsIgnoreCase(identifier)) continue;
            try {
                sX = Integer.parseInt(ptrn[1]);
                sZ = Integer.parseInt(ptrn[2]);
            }
            catch (NumberFormatException exc) {
                continue;
            }
            T section = this.createNewSection(sX, sZ);
            ((WorldSection)section).readFromNBT(CompressedStreamTools.func_74797_a((File)subFile));
            this.sections.put(new SectionKey(sX, sZ), section);
        }
    }

    private static class SectionKey {
        private final int x;
        private final int z;

        private SectionKey(int x, int z) {
            this.x = x;
            this.z = z;
        }

        private static SectionKey from(WorldSection section) {
            return new SectionKey(section.getSectionX(), section.getSectionZ());
        }

        private static SectionKey resolve(Vec3i absolute, int shift) {
            return new SectionKey(absolute.func_177958_n() >> shift, absolute.func_177952_p() >> shift);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SectionKey that = (SectionKey)o;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }
    }
}

