/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.util.Tuple;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModSoundEvents {
    public static Map<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>> SOUND_EVENTS = new HashMap<String, Map<EventType, Tuple<SoundEvent, SoundEvent>>>();

    private ModSoundEvents() {
    }

    public static void registerSounds(IForgeRegistry<SoundEvent> registry) {
        for (EventType[] job : IJobRegistry.getInstance().getValues()) {
            if (!job.getRegistryName().func_110624_b().equals("minecolonies") || job.getRegistryName().func_110623_a().equals("placeholder")) continue;
            HashMap<EventType, Tuple<SoundEvent, SoundEvent>> map = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
            for (EventType soundEvents : EventType.values()) {
                SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob." + job.getRegistryName().func_110623_a() + ".male." + soundEvents.name().toLowerCase(Locale.US));
                SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob." + job.getRegistryName().func_110623_a() + ".female." + soundEvents.name().toLowerCase(Locale.US));
                registry.register((IForgeRegistryEntry)maleSoundEvent);
                registry.register((IForgeRegistryEntry)femaleSoundEvent);
                map.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
            }
            SOUND_EVENTS.put(job.getRegistryName().func_110623_a(), map);
        }
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> citizenMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType soundEvents : EventType.values()) {
            SoundEvent soundEvent = ModSoundEvents.getSoundID("mob.citizen.male." + soundEvents.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.citizen.female." + soundEvents.name().toLowerCase(Locale.US));
            registry.register((IForgeRegistryEntry)soundEvent);
            registry.register((IForgeRegistryEntry)femaleSoundEvent);
            citizenMap.put(soundEvents, new Tuple<SoundEvent, SoundEvent>(soundEvent, femaleSoundEvent));
        }
        SOUND_EVENTS.put("citizen", citizenMap);
        HashMap<EventType, Tuple<SoundEvent, SoundEvent>> childMap = new HashMap<EventType, Tuple<SoundEvent, SoundEvent>>();
        for (EventType eventType : EventType.values()) {
            SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("mob.child.male." + eventType.name().toLowerCase(Locale.US));
            SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("mob.child.female." + eventType.name().toLowerCase(Locale.US));
            registry.register((IForgeRegistryEntry)maleSoundEvent);
            registry.register((IForgeRegistryEntry)femaleSoundEvent);
            childMap.put(eventType, new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
        }
        SOUND_EVENTS.put("child", childMap);
        registry.register((IForgeRegistryEntry)TavernSounds.tavernTheme);
        for (Enum enum_ : RaiderType.values()) {
            SoundEvent raiderHurt = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".hurt");
            SoundEvent raiderDeath = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".death");
            SoundEvent raiderSay = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".say");
            registry.register((IForgeRegistryEntry)raiderHurt);
            registry.register((IForgeRegistryEntry)raiderDeath);
            registry.register((IForgeRegistryEntry)raiderSay);
            HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent> sounds = new HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent>();
            sounds.put(RaiderSounds.RaiderSoundTypes.HURT, raiderHurt);
            sounds.put(RaiderSounds.RaiderSoundTypes.DEATH, raiderDeath);
            sounds.put(RaiderSounds.RaiderSoundTypes.SAY, raiderSay);
            RaiderSounds.raiderSounds.put((RaiderType)enum_, sounds);
        }
        registry.register((IForgeRegistryEntry)RaidSounds.AMAZON_RAID);
        registry.register((IForgeRegistryEntry)RaidSounds.DESERT_RAID);
        registry.register((IForgeRegistryEntry)RaidSounds.DESERT_RAID_VICTORY);
        registry.register((IForgeRegistryEntry)RaidSounds.DESERT_RAID_WARNING);
    }

    public static SoundEvent getSoundID(String soundName) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("minecolonies", soundName)).setRegistryName(soundName);
    }
}

