/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.TickedWorldOperation;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreativeBuildingStructureHandler
extends CreativeStructureHandler {
    private IBuilding building;

    public CreativeBuildingStructureHandler(World world, BlockPos pos, String structureName, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, structureName, settings, fancyPlacement);
        this.setupBuilding();
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        super.triggerSuccess(pos, list, placement);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        if (this.building != null) {
            this.building.registerBlockPosition(this.getBluePrint().getBlockState(pos), worldPos, this.getWorld());
        }
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        if (block1 == Blocks.field_150457_bL || block2 == Blocks.field_150457_bL) {
            return block1 == block2;
        }
        if (block1 == Blocks.field_196658_i && block2 == Blocks.field_150346_d || block2 == Blocks.field_196658_i && block1 == Blocks.field_150346_d) {
            return true;
        }
        return super.shouldBlocksBeConsideredEqual(state1, state2);
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.func_190926_b() || itemStack.func_77973_b().func_206844_a(ItemTags.field_206963_E) || itemStack.func_77973_b() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).func_77973_b();
    }

    public static Blueprint loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean fancyPlacement, @Nullable ServerPlayerEntity player) {
        try {
            CreativeBuildingStructureHandler structure = new CreativeBuildingStructureHandler(worldObj, pos, name, new PlacementSettings(mirror, rotation), fancyPlacement);
            if (structure.hasBluePrint()) {
                structure.getBluePrint().rotateWithMirror(rotation, mirror, worldObj);
                StructurePlacer instantPlacer = new StructurePlacer((IStructureHandler)structure);
                Manager.addToQueue((TickedWorldOperation)new TickedWorldOperation(instantPlacer, (PlayerEntity)player));
            }
            return structure.getBluePrint();
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return null;
        }
    }
}

