/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;

public class WorldUtil {
    public static boolean isBlockLoaded(IWorld world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static boolean isChunkLoaded(IWorld world, int x, int z) {
        return world.func_217353_a(x, z, ChunkStatus.field_222617_m, false) != null;
    }

    public static void markChunkDirty(World world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_76630_e();
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(IWorld world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isEntityBlockLoaded(IWorld world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static boolean isEntityChunkLoaded(IWorld world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(IWorld world, ChunkPos pos) {
        return world.func_72863_F().func_222865_a(pos);
    }

    public static boolean isAABBLoaded(World world, AxisAlignedBB box) {
        return WorldUtil.isChunkLoaded((IWorld)world, (int)box.field_72340_a >> 4, (int)box.field_72339_c >> 4) && WorldUtil.isChunkLoaded((IWorld)world, (int)box.field_72336_d >> 4, (int)box.field_72334_f >> 4);
    }

    public static boolean isDayTime(World world) {
        return world.func_72820_D() % 24000L <= 12600L;
    }

    public static boolean isPastTime(World world, int pastTime) {
        return world.func_72820_D() % 24000L <= (long)pastTime;
    }
}

