/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.requests.AbstractRequest;
import com.minecolonies.coremod.network.messages.server.colony.UpdateRequestStateMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowRequestTree
extends AbstractWindowSkeleton {
    protected final IColonyView colony;
    protected ScrollingList resourceList;
    private final PlayerInventory inventory;
    private final boolean isCreative;
    private int lifeCount;
    private final IBuildingView building;

    public AbstractWindowRequestTree(BlockPos building, String pane, IColonyView colony) {
        super(pane);
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.func_184812_l_();
        this.lifeCount = 0;
        this.colony = colony;
        this.building = colony.getBuilding(building);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("requests", ScrollingList.class);
        this.registerButton("detail", this::detailedClicked);
        this.registerButton("cancel", this::cancel);
        if (this.canFulFill()) {
            this.registerButton("fulfill", this::fulfill);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
    }

    public void onOpened() {
        super.onOpened();
        if (this.building != null) {
            this.updateRequests();
        }
        if (this.colony == null) {
            Log.getLogger().warn("Colony and/or building null, closing window.");
            this.close();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getOpenRequestTreeOfBuilding().size() > row && row >= 0) {
            IRequest<?> request = ((RequestWrapper)this.getOpenRequestTreeOfBuilding().get(row)).getRequest();
            this.building.onRequestedRequestCancelled(this.colony.getRequestManager(), request);
            Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.CANCELLED, null));
        }
        this.updateRequests();
    }

    public void cancel(@NotNull IRequest<?> request) {
        this.building.onRequestedRequestCancelled(this.colony.getRequestManager(), request);
        Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.CANCELLED, null));
        this.updateRequests();
    }

    protected ImmutableList<RequestWrapper> getOpenRequestTreeOfBuilding() {
        if (this.colony == null) {
            return ImmutableList.of();
        }
        ArrayList treeElements = new ArrayList();
        if (this.building != null) {
            this.getOpenRequestsFromBuilding(this.building).forEach(r -> this.constructTreeFromRequest(this.building, this.colony.getRequestManager(), (IRequest<?>)r, treeElements, 0));
        }
        return ImmutableList.copyOf(treeElements);
    }

    private void constructTreeFromRequest(@NotNull IBuildingView buildingView, @NotNull IRequestManager manager, @NotNull IRequest<?> request, @NotNull List<RequestWrapper> list, int currentDepth) {
        list.add(new RequestWrapper(request, currentDepth, buildingView));
        if (request.hasChildren()) {
            for (Object o : request.getChildren()) {
                IToken iToken;
                IRequest<?> childRequest;
                if (!(o instanceof IToken) || (childRequest = manager.getRequestForToken(iToken = (IToken)o)) == null) continue;
                this.constructTreeFromRequest(buildingView, manager, childRequest, list, currentDepth + 1);
            }
        }
    }

    public ImmutableList<IRequest<?>> getOpenRequestsFromBuilding(IBuildingView building) {
        return building.getOpenRequestsOfBuilding();
    }

    public void fulfill(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getOpenRequestTreeOfBuilding().size() > row && row >= 0) {
            IRequest<?> request = ((RequestWrapper)this.getOpenRequestTreeOfBuilding().get(row)).getRequest();
            this.fulfill(request);
        }
        button.disable();
        this.updateRequests();
    }

    public void fulfill(@NotNull IRequest<?> request) {
    }

    public boolean canFulFill() {
        return false;
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (this.getOpenRequestTreeOfBuilding().size() > row) {
            WindowRequestDetail window = new WindowRequestDetail(this, ((RequestWrapper)this.getOpenRequestTreeOfBuilding().get(row)).getRequest(), this.colony.getID());
            window.open();
        }
    }

    protected void updateRequests() {
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){
            private List<RequestWrapper> requestWrappers = null;

            public int getElementCount() {
                this.requestWrappers = AbstractWindowRequestTree.this.getOpenRequestTreeOfBuilding();
                return this.requestWrappers.size();
            }

            public void updateElement(int index, Pane rowPane) {
                if (index < 0 || index >= this.requestWrappers.size()) {
                    return;
                }
                RequestWrapper wrapper = this.requestWrappers.get(index);
                Box wrapperBox = (Box)rowPane.findPaneOfTypeByID("requestx", Box.class);
                wrapperBox.setPosition(wrapperBox.getX() + 2 * wrapper.getDepth(), wrapperBox.getY());
                wrapperBox.setSize(wrapperBox.getParent().getWidth() - 2 * wrapper.getDepth(), wrapperBox.getHeight());
                rowPane.findPaneByID("fulfill").enable();
                IRequest<?> request = wrapper.getRequest();
                ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID("requestStack", ItemIcon.class);
                List<ItemStack> displayStacks = request.getDisplayStacks();
                Image logo = (Image)rowPane.findPaneOfTypeByID("deliveryImage", Image.class);
                if (!displayStacks.isEmpty()) {
                    logo.setVisible(false);
                    exampleStackDisplay.setVisible(true);
                    exampleStackDisplay.setItem(displayStacks.get(AbstractWindowRequestTree.this.lifeCount / 30 % displayStacks.size()));
                    ((Label)rowPane.findPaneOfTypeByID("requester", Label.class)).setLabelText(request.getRequester().getRequesterDisplayName(AbstractWindowRequestTree.this.colony.getRequestManager(), request).func_150254_d());
                } else {
                    exampleStackDisplay.setVisible(false);
                    if (!request.getDisplayIcon().equals((Object)AbstractRequest.MISSING)) {
                        logo.setVisible(true);
                        logo.setImage(request.getDisplayIcon());
                        logo.setHoverToolTip(request.getResolverToolTip(AbstractWindowRequestTree.this.colony));
                    }
                }
                ((Label)rowPane.findPaneOfTypeByID("shortDetail", Label.class)).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
                if (!AbstractWindowRequestTree.this.cancellable(request)) {
                    ((ButtonImage)rowPane.findPaneOfTypeByID("cancel", ButtonImage.class)).hide();
                }
                if (!AbstractWindowRequestTree.this.fulfillable(request)) {
                    ((ButtonImage)rowPane.findPaneOfTypeByID("fulfill", ButtonImage.class)).hide();
                }
            }
        });
    }

    public boolean fulfillable(IRequest<?> tRequest) {
        if (!(tRequest.getRequest() instanceof IDeliverable)) {
            return false;
        }
        Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)tRequest.getRequest()).matches((ItemStack)stack);
        ImmutableList<RequestWrapper> requestWrappers = this.getOpenRequestTreeOfBuilding();
        RequestWrapper wrapper = requestWrappers.stream().filter(requestWrapper -> requestWrapper.getRequest().equals(tRequest)).findFirst().orElse(null);
        if (wrapper == null) {
            return false;
        }
        if (wrapper.overruleable && this.canFulFill()) {
            if (wrapper.getDepth() > 0) {
                if (!(tRequest.getRequester() instanceof IBuildingBasedRequester) || !((IBuildingBasedRequester)tRequest.getRequester()).getBuilding(this.colony.getRequestManager(), (IToken<?>)tRequest.getId()).map(iRequester -> iRequester.getLocation().equals(this.building.getLocation())).isPresent()) {
                    return false;
                }
                if (!this.isCreative && !InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate)) {
                    return false;
                }
            } else if (!this.isCreative && !InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate)) {
                return false;
            }
            return !(this instanceof WindowCitizen) || ((WindowCitizen)this).getCitizen().getInventory().hasSpace();
        }
        return false;
    }

    public boolean cancellable(IRequest<?> tRequest) {
        ImmutableList<RequestWrapper> requestWrappers = this.getOpenRequestTreeOfBuilding();
        RequestWrapper wrapper = requestWrappers.stream().filter(requestWrapper -> requestWrapper.getRequest().equals(tRequest)).findFirst().orElse(null);
        if (wrapper == null) {
            return false;
        }
        return wrapper.getDepth() <= 0;
    }

    protected final class RequestWrapper {
        private final IRequest<?> request;
        private final int depth;
        private final boolean overruleable;

        public RequestWrapper(IRequest<?> request, @NotNull int depth, IBuildingView buildingView) {
            this.request = request;
            this.depth = depth;
            this.overruleable = request.getRequester().getId().equals(buildingView.getId()) || buildingView.getResolverIds().contains(request.getRequester().getId()) || buildingView.getPosition().equals((Object)request.getRequester().getLocation().getInDimensionLocation());
        }

        public IRequest<?> getRequest() {
            return this.request;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

