/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowAssignCitizen;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.server.colony.building.RecallCitizenHutMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowHutCitizen
extends AbstractWindowBuilding<BuildingHome.View> {
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowhuthome.xml";
    private final BuildingHome.View home;
    private ScrollingList citizen;

    public WindowHutCitizen(BuildingHome.View building) {
        super(building, "minecolonies:gui/windowhuthome.xml");
        super.registerButton("assign", this::assignClicked);
        super.registerButton("remove", this::removeClicked);
        super.registerButton("recall", this::recallClicked);
        this.home = building;
    }

    @Override
    public void onOpened() {
        super.onOpened();
        final boolean isManualHousing = ((BuildingHome.View)this.building).getColony().isManualHousing();
        this.citizen = (ScrollingList)this.findPaneOfTypeByID("assignedCitizen", ScrollingList.class);
        this.citizen.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutCitizen.this.home.getResidents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowHutCitizen.this.home.getColony().getCitizen(WindowHutCitizen.this.home.getResidents().get(index));
                if (citizenDataView != null) {
                    ((Label)rowPane.findPaneOfTypeByID("name", Label.class)).setLabelText(citizenDataView.getName());
                    ((Button)rowPane.findPaneOfTypeByID("remove", Button.class)).setEnabled(isManualHousing);
                    if (citizenDataView.getWorkBuilding() != null) {
                        BlockPos work = citizenDataView.getWorkBuilding();
                        double distance2D = BlockPosUtil.getDistance2D(work, WindowHutCitizen.this.home.getPosition());
                        ((Label)rowPane.findPaneOfTypeByID("dist", Label.class)).setLabelText(LanguageHandler.format((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance2D}));
                    }
                }
            }
        });
        this.refreshView();
    }

    private void refreshView() {
        Button buttonAssign = (Button)this.findPaneOfTypeByID("assign", Button.class);
        int sparePlaces = ((BuildingHome.View)this.building).getBuildingLevel() - ((BuildingHome.View)this.building).getResidents().size();
        buttonAssign.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.gui.home.assign", (Object[])new Object[]{sparePlaces}));
        buttonAssign.setEnabled(sparePlaces > 0 && ((BuildingHome.View)this.building).getColony().isManualHousing());
        this.citizen.refreshElementPanes();
    }

    private void assignClicked() {
        if (((BuildingHome.View)this.building).getColony().isManualHousing()) {
            if (((BuildingHome.View)this.building).getBuildingLevel() == 0) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.workerhuts.level0", (Object[])new Object[0]);
                return;
            }
            if (((BuildingHome.View)this.building).getResidents().size() < ((BuildingHome.View)this.building).getBuildingLevel()) {
                WindowAssignCitizen window = new WindowAssignCitizen(((BuildingHome.View)this.building).getColony(), ((BuildingHome.View)this.building).getPosition());
                window.open();
            }
        }
    }

    private void removeClicked(@NotNull Button button) {
        if (((BuildingHome.View)this.building).getColony().isManualHousing()) {
            int row = this.citizen.getListElementIndexByPane((Pane)button);
            int citizenid = this.home.getResidents().get(row);
            this.home.removeResident(row);
            Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, false, citizenid));
            this.refreshView();
        }
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenHutMessage((AbstractBuildingView)this.building));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.homehut";
    }
}

