/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowBuildDecoration;
import com.minecolonies.coremod.items.ItemSupplyCampDeployer;
import com.minecolonies.coremod.items.ItemSupplyChestDeployer;
import com.minecolonies.coremod.network.messages.server.BuildToolPasteMessage;
import com.minecolonies.coremod.network.messages.server.BuildToolPlaceMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowMinecoloniesBuildTool
extends WindowBuildTool {
    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, String structureName, int rotation) {
        super(pos, structureName, rotation);
    }

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos) {
        super(pos);
    }

    public void place(StructureName structureName) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset).getBlockState();
        BuildToolPlaceMessage msg = new BuildToolPlaceMessage(structureName.toString(), structureName.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), structureName.isHut(), Settings.instance.getMirror(), state);
        if (structureName.isHut()) {
            Network.getNetwork().sendToServer(msg);
        } else {
            Minecraft.func_71410_x().func_212871_a_(() -> ((WindowBuildDecoration)new WindowBuildDecoration(msg, Settings.instance.getPosition(), structureName)).open());
        }
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean pasteDirectly() {
        return false;
    }

    public void paste(StructureName name, boolean complete) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset).getBlockState();
        if (name.isHut() || Settings.instance.getStaticSchematicName() != null && !Settings.instance.getStaticSchematicName().isEmpty()) {
            Network.getNetwork().sendToServer(new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), name.isHut(), Settings.instance.getMirror(), complete, state));
        } else {
            super.paste(name, complete);
        }
    }

    public void checkAndPlace() {
        ArrayList<PlacementError> placementErrorList = new ArrayList<PlacementError>();
        if (Settings.instance.getStaticSchematicName().contains("supplyship")) {
            if (ItemSupplyChestDeployer.canShipBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), new BlockPos((int)Settings.instance.getActiveStructure().getSizeX(), (int)Settings.instance.getActiveStructure().getSizeY(), (int)Settings.instance.getActiveStructure().getSizeZ()), placementErrorList, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                super.pasteNice();
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"item.supplyChestDeployer.invalid", (Object[])new Object[0]);
            }
        } else if (Settings.instance.getStaticSchematicName().contains("supplycamp") && ItemSupplyCampDeployer.canCampBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), new BlockPos((int)Settings.instance.getActiveStructure().getSizeX(), (int)Settings.instance.getActiveStructure().getSizeY(), (int)Settings.instance.getActiveStructure().getSizeZ()), placementErrorList, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            super.pasteNice();
        }
        if (!placementErrorList.isEmpty()) {
            Map blockPosListByErrorTypeMap = PlacementError.partitionPlacementErrorsByErrorType(placementErrorList);
            block6: for (Map.Entry entry : blockPosListByErrorTypeMap.entrySet()) {
                String errorMessage;
                PlacementError.PlacementErrorType placementErrorType = (PlacementError.PlacementErrorType)entry.getKey();
                List blockPosList = (List)entry.getValue();
                int numberOfBlocksTOReport = blockPosList.size() > 5 ? 5 : blockPosList.size();
                List blocksToReportList = blockPosList.subList(0, numberOfBlocksTOReport);
                String outputList = PlacementError.blockListToCommaSeparatedString(blocksToReportList);
                if (blockPosList.size() > numberOfBlocksTOReport) {
                    outputList = outputList + "...";
                }
                switch (placementErrorType) {
                    case NOT_WATER: {
                        errorMessage = String.format("item.supplycampdeployer.invalid.water_block_needed", outputList);
                        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[]{outputList});
                        continue block6;
                    }
                    case NOT_SOLID: {
                        errorMessage = String.format("item.supplycampdeployer.invalid.solid_block_needed", outputList);
                        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[]{outputList});
                        continue block6;
                    }
                    case NEEDS_AIR_ABOVE: {
                        errorMessage = String.format("item.supplycampdeployer.invalid.air_block_needed", outputList);
                        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[]{outputList});
                        continue block6;
                    }
                    case INSIDE_COLONY: {
                        errorMessage = "item.supplycampdeployer.invalid.inside_existing_colony";
                        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[0]);
                        continue block6;
                    }
                }
                errorMessage = "item.supplycampdeployer.invalid";
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[0]);
            }
        }
        if (!Screen.hasShiftDown()) {
            super.cancelClicked();
        }
    }

    public boolean hasMatchingBlock(@NotNull PlayerInventory inventory, String hut) {
        return InventoryUtils.hasItemInProvider((ICapabilityProvider)inventory.field_70458_d, item -> item.func_77973_b() instanceof BlockItem && ((BlockItem)item.func_77973_b()).func_179223_d() instanceof AbstractBlockHut && ((BlockItem)item.func_77973_b()).func_179223_d().getRegistryName().func_110623_a().contains(hut));
    }
}

