/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowClipBoard;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowRequestDetail
extends Window
implements ButtonHandler {
    private static final int BLACK = Color.getByName((String)"black", (int)0);
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowrequestdetail.xml";
    private static final String BOX_ID_REQUEST = "requestDetail";
    private static final String REQUESTER = "requester";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private static final String LIST_ELEMENT_ID_REQUEST_LOCATION = "targetLocation";
    private static final int Y_OFFSET_EACH_TEXTFIELD = 10;
    private static final String RESOLVER = "resolver";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private final IRequest<?> request;
    private final int colonyId;
    private int lifeCount = 0;
    private final Window prevWindow;

    public WindowRequestDetail(@Nullable Window prevWindow, IRequest<?> request, int colonyId) {
        super("minecolonies:gui/windowrequestdetail.xml");
        this.prevWindow = prevWindow;
        this.request = request;
        this.colonyId = colonyId;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.hasShiftDown()) {
            ++this.lifeCount;
        }
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            exampleStackDisplay.setItem(ItemStackUtils.EMPTY);
        }
    }

    public void onOpened() {
        String[] labels = new String[]{this.request.getLongDisplayString().func_150254_d()};
        Box box = (Box)this.findPaneOfTypeByID(BOX_ID_REQUEST, Box.class);
        int y = 10;
        int availableLabelWidth = box.getInteriorWidth() - 1 - box.getX();
        for (String s : labels) {
            String labelText = "\u00a7r\u00a70" + s;
            List multilineLabelStrings = this.mc.field_71466_p.func_78271_c(labelText, availableLabelWidth);
            for (String splitLabelText : multilineLabelStrings) {
                Label descriptionLabel = new Label();
                descriptionLabel.setColor(BLACK, BLACK);
                descriptionLabel.setLabelText(splitLabelText);
                box.addChild((Pane)descriptionLabel);
                descriptionLabel.setPosition(1, y);
                y += 10;
            }
        }
        Image logo = (Image)this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
        ItemIcon exampleStackDisplay = (ItemIcon)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
        List<ItemStack> displayStacks = this.request.getDisplayStacks();
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
        if (!displayStacks.isEmpty()) {
            exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
        } else {
            logo.setVisible(true);
            logo.setImage(this.request.getDisplayIcon());
            logo.setHoverToolTip(this.request.getResolverToolTip(colony));
        }
        String requester = this.request.getRequester().getRequesterDisplayName(colony.getRequestManager(), this.request).func_150254_d();
        ((Label)this.findPaneOfTypeByID(REQUESTER, Label.class)).setLabelText(requester);
        Label targetLabel = (Label)this.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_LOCATION, Label.class);
        targetLabel.setLabelText(this.request.getRequester().getLocation().toString());
        if (colony == null) {
            Log.getLogger().warn("---Colony Null in WindowRequestDetail---");
            return;
        }
        try {
            IRequestResolver<?> resolver = colony.getRequestManager().getResolverForRequest((IToken<?>)this.request.getId());
            if (resolver == null) {
                Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---");
                return;
            }
            ((Label)this.findPaneOfTypeByID(RESOLVER, Label.class)).setLabelText("Resolver: " + resolver.getRequesterDisplayName(colony.getRequestManager(), this.request).func_150254_d());
        }
        catch (IllegalArgumentException e) {
            Log.getLogger().warn("---IRequestResolver Null in WindowRequestDetail---", (Throwable)e);
        }
        Pane fulfillButton = this.window.getChildren().stream().filter(pane -> pane.getID().equals("fulfill")).findFirst().get();
        if (this.prevWindow instanceof WindowCitizen && !((WindowCitizen)this.prevWindow).fulfillable(this.request) || this.prevWindow instanceof WindowClipBoard) {
            fulfillButton.hide();
        }
        Pane cancelButton = this.window.getChildren().stream().filter(pane -> pane.getID().equals("cancel")).findFirst().get();
        if (this.prevWindow instanceof WindowCitizen && !((WindowCitizen)this.prevWindow).cancellable(this.request)) {
            cancelButton.hide();
        }
        box.setSize(box.getWidth(), y);
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("fulfill")) {
            if (this.prevWindow instanceof WindowCitizen) {
                ((WindowCitizen)this.prevWindow).fulfill(this.request);
            }
            this.window.close();
        } else if (button.getID().equals("cancel")) {
            if (this.prevWindow instanceof WindowCitizen) {
                ((WindowCitizen)this.prevWindow).cancel(this.request);
            }
            this.window.close();
        } else {
            this.prevWindow.open();
        }
    }
}

