/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowTownHallColonyDelete;
import com.minecolonies.coremod.network.messages.client.CreateColonyMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WindowTownHallColonyManage
extends AbstractWindowSkeleton {
    private static final String BUTTON_CLOSE = "cancel";
    private static final String BUTTON_DELETE = "delete";
    private static final String BUTTON_CREATE = "create";
    private static final String TEXT_NEARBY = "nearbycolony";
    private static final String TEXT_OWN = "owncolony";
    private static final String TEXT_FEEDBACK = "creationpossible";
    private final BlockPos pos;

    public WindowTownHallColonyManage(PlayerEntity player, BlockPos pos, World world) {
        super("minecolonies:gui/townhall/windowcolonymanagement.xml");
        this.pos = pos;
        IColony existingColony = IColonyManager.getInstance().getIColony(world, pos);
        if (existingColony != null) {
            ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.here", (Object[])new Object[]{existingColony.getName(), existingColony.getPermissions().getOwnerName()}));
        } else {
            int closeClonyID = WindowTownHallColonyManage.findNextNearbyColony(world, pos, (Integer)MineColonies.getConfig().getCommon().minColonyDistance.get());
            if (closeClonyID != 0) {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.near", (Object[])new Object[]{closeClonyID}));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.nonenearby", (Object[])new Object[0]));
            }
        }
        IColony ownerColony = IColonyManager.getInstance().getIColonyByOwner(world, player);
        if (ownerColony != null) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_DELETE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.own", (Object[])new Object[]{ownerColony.getCenter()}));
            if (((Boolean)MineColonies.getConfig().getCommon().allowInfiniteColonies.get()).booleanValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.denied.existingandabandon", (Object[])new Object[0]));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.denied.existing", (Object[])new Object[0]));
            }
        } else {
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.none", (Object[])new Object[0]));
            if (existingColony != null || IColonyManager.getInstance().isTooCloseToColony(world, pos)) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.denied.tooclose", (Object[])new Object[0]));
            }
        }
        if (((Boolean)MineColonies.getConfig().getCommon().restrictColonyPlacement.get()).booleanValue()) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(pos, world.func_175694_M()));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getCommon().minDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.tooclose", (Object[])new Object[]{MineColonies.getConfig().getCommon().minDistanceFromWorldSpawn.get()}));
            } else if (spawnDistance > (double)((Integer)MineColonies.getConfig().getCommon().maxDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.toofar", (Object[])new Object[]{MineColonies.getConfig().getCommon().maxDistanceFromWorldSpawn.get()}));
            }
        }
        if (((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).getTextContent().isEmpty()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CREATE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setTextContent(LanguageHandler.format((String)"com.minecolonies.coremod.gui.colony.allowed.create", (Object[])new Object[0]));
        }
        this.registerButton(BUTTON_CLOSE, () -> this.close());
        this.registerButton(BUTTON_CREATE, () -> this.onCreate());
        this.registerButton(BUTTON_DELETE, () -> new WindowTownHallColonyDelete().open());
    }

    public void onCreate() {
        new VanillaParticleMessage(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), ParticleTypes.field_197616_i).onExecute(null, false);
        Minecraft.func_71410_x().field_71441_e.func_184133_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_180425_c(), SoundEvents.field_219605_aC, SoundCategory.AMBIENT, 2.5f, 0.8f);
        Network.getNetwork().sendToServer(new CreateColonyMessage(this.pos));
        this.close();
    }

    private static int findNextNearbyColony(World world, BlockPos start, int range) {
        int startX = start.func_177958_n() >> 4;
        int startZ = start.func_177952_p() >> 4;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                int chunkX = startX + x;
                int chunkZ = startZ + z;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (cap == null) continue;
                if (cap.getOwningColony() != 0) {
                    return cap.getOwningColony();
                }
                if (cap.getAllCloseColonies().isEmpty()) continue;
                return cap.getAllCloseColonies().get(0);
            }
        }
        return 0;
    }
}

